/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.bridges.jni_uno;

import com.sun.star.bridges.jni_uno.JNI_info_holder;
import com.sun.star.lib.util.AsynchronousFinalizer;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.IQueryInterface;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class JNI_proxy
implements InvocationHandler {
    private static ClassLoader s_classloader;
    private static Class[] s_InvocationHandler;
    private long m_bridge_handle;
    private final IEnvironment m_java_env;
    private long m_receiver_handle;
    private long m_td_handle;
    private final Type m_type;
    private final String m_oid;
    private final Class m_class;
    private final AsynchronousFinalizer m_finalizer;

    public static String get_stack_trace(Throwable throwable) throws Throwable {
        boolean bl = false;
        if (null == throwable) {
            throwable = new Throwable();
            bl = true;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        stringWriter.flush();
        String string = stringWriter.toString();
        if (bl) {
            int n = string.indexOf(10);
            n = string.indexOf(10, n + 1);
            string = string.substring(n + 1);
        }
        return "\njava stack trace:\n" + string;
    }

    private native void finalize(long var1);

    protected void finalize() {
        if (this.m_finalizer != null) {
            this.m_finalizer.add(new AsynchronousFinalizer.Job(){

                @Override
                public void run() throws Throwable {
                    JNI_proxy.this.finalize(JNI_proxy.this.m_bridge_handle);
                }
            });
        }
    }

    private JNI_proxy(long l, IEnvironment iEnvironment, long l2, long l3, Type type, String string, AsynchronousFinalizer asynchronousFinalizer) {
        this.m_bridge_handle = l;
        this.m_java_env = iEnvironment;
        this.m_receiver_handle = l2;
        this.m_td_handle = l3;
        this.m_type = type;
        this.m_oid = string;
        this.m_class = this.m_type.getZClass();
        this.m_finalizer = asynchronousFinalizer;
    }

    public static Object create(long l, IEnvironment iEnvironment, long l2, long l3, Type type, String string, Constructor constructor, AsynchronousFinalizer asynchronousFinalizer) throws Throwable {
        JNI_proxy jNI_proxy = new JNI_proxy(l, iEnvironment, l2, l3, type, string, asynchronousFinalizer);
        Object t = constructor.newInstance(jNI_proxy);
        return iEnvironment.registerInterface(t, new String[]{string}, type);
    }

    public static Constructor get_proxy_ctor(Class clazz) throws Throwable {
        Class<?> clazz2 = Proxy.getProxyClass(s_classloader, clazz, IQueryInterface.class, com.sun.star.lib.uno.Proxy.class);
        return clazz2.getConstructor(s_InvocationHandler);
    }

    private native Object dispatch_call(long var1, String var3, Object[] var4) throws Throwable;

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        String string = method.getName();
        if (Object.class.equals(clazz)) {
            if (string.equals("hashCode")) {
                return this.m_oid.hashCode();
            }
            if (string.equals("equals")) {
                return this.isSame(objectArray[0]);
            }
            if (string.equals("toString")) {
                return this.toString() + " [oid=" + this.m_oid + ", type=" + this.m_type.getTypeName() + "]";
            }
        } else {
            if (clazz.isAssignableFrom(this.m_class)) {
                return this.dispatch_call(this.m_bridge_handle, string, objectArray);
            }
            if (IQueryInterface.class.equals(clazz)) {
                if (string.equals("queryInterface")) {
                    Object object2 = this.m_java_env.getRegisteredInterface(this.m_oid, (Type)objectArray[0]);
                    if (null == object2) {
                        return this.dispatch_call(this.m_bridge_handle, string, objectArray);
                    }
                    return object2;
                }
                if (string.equals("isSame")) {
                    return this.isSame(objectArray[0]);
                }
                if (string.equals("getOid")) {
                    return this.m_oid;
                }
            }
        }
        throw new RuntimeException("[jni_uno bridge error] unexpected call on proxy " + object.toString() + ": " + method.toString());
    }

    private Boolean isSame(Object object) {
        return object != null && this.m_oid.equals(UnoRuntime.generateOid(object));
    }

    static {
        if ("The Android Project".equals(System.getProperty("java.vendor"))) {
            boolean bl = false;
            try {
                System.loadLibrary("lo-bootstrap");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = true;
            }
            if (!bl) {
                NativeLibraryLoader.loadLibrary(JNI_info_holder.class.getClassLoader(), "java_uno");
            }
        } else {
            NativeLibraryLoader.loadLibrary(JNI_proxy.class.getClassLoader(), "java_uno");
        }
        s_classloader = JNI_proxy.class.getClassLoader();
        s_InvocationHandler = new Class[]{InvocationHandler.class};
    }
}

