/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.Profile;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.IdentityProviderShowInAccountConsole;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.account.AccountLinkUriRepresentation;
import org.keycloak.representations.account.LinkedAccountRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.validation.Validation;
import org.keycloak.theme.Theme;
import org.keycloak.utils.BrokerUtil;
import org.keycloak.utils.StreamsUtil;

public class LinkedAccountsResource {
    private static final Logger logger = Logger.getLogger(LinkedAccountsResource.class);
    private final KeycloakSession session;
    private final HttpRequest request;
    private final EventBuilder event;
    private final UserModel user;
    private final RealmModel realm;
    private final Auth auth;
    private final Set<String> socialIds;

    public LinkedAccountsResource(KeycloakSession session, HttpRequest request, Auth auth, EventBuilder event, UserModel user) {
        this.session = session;
        this.request = request;
        this.auth = auth;
        this.event = event;
        this.user = user;
        this.realm = session.getContext().getRealm();
        this.socialIds = session.getKeycloakSessionFactory().getProviderFactoriesStream(SocialIdentityProvider.class).map(ProviderFactory::getId).collect(Collectors.toSet());
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response linkedAccounts(@QueryParam(value="linked") Boolean linked, @QueryParam(value="search") String search, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        List<Object> linkedAccounts;
        this.auth.requireOneOf("manage-account", "view-profile");
        if (linked == null) {
            List<LinkedAccountRepresentation> linkedAccounts2 = this.getLinkedAccounts(this.session, this.realm, this.user);
            return Cors.builder().auth().allowedOrigins(this.auth.getToken()).add(Response.ok(linkedAccounts2));
        }
        if (linked.booleanValue()) {
            Set<IdentityProviderShowInAccountConsole> includedShowInAccountConsoleValues = Set.of(IdentityProviderShowInAccountConsole.ALWAYS, IdentityProviderShowInAccountConsole.WHEN_LINKED);
            linkedAccounts = StreamsUtil.paginatedStream(this.session.users().getFederatedIdentitiesStream(this.realm, this.user).map(fedIdentity -> this.toLinkedAccount(this.session.identityProviders().getByAlias(fedIdentity.getIdentityProvider()), fedIdentity.getUserName(), includedShowInAccountConsoleValues)).filter(account -> account != null && this.matchesLinkedProvider((LinkedAccountRepresentation)account, search)).sorted(), (Integer)firstResult, (Integer)maxResults).toList();
        } else {
            String fedAliasesToExclude = this.session.users().getFederatedIdentitiesStream(this.realm, this.user).map(FederatedIdentityModel::getIdentityProvider).collect(Collectors.joining(","));
            Map<String, String> searchOptions = Map.of("enabled", "true", "organizationId", "", "search", search == null ? "" : search, "aliasNotIn", fedAliasesToExclude, "showInAccountConsole", IdentityProviderShowInAccountConsole.ALWAYS.name());
            linkedAccounts = this.session.identityProviders().getAllStream(searchOptions, firstResult, maxResults).map(idp -> this.toLinkedAccount((IdentityProviderModel)idp, null, null)).toList();
        }
        return Cors.builder().auth().allowedOrigins(this.auth.getToken()).add(Response.ok(linkedAccounts));
    }

    private LinkedAccountRepresentation toLinkedAccount(IdentityProviderModel provider, String fedIdentity, Set<IdentityProviderShowInAccountConsole> includedShowInAccountConsoleValues) {
        if (provider == null || !provider.isEnabled()) {
            return null;
        }
        if (includedShowInAccountConsoleValues != null && !includedShowInAccountConsoleValues.contains(provider.getShowInAccountConsole())) {
            return null;
        }
        LinkedAccountRepresentation rep = new LinkedAccountRepresentation();
        rep.setConnected(fedIdentity != null);
        rep.setSocial(this.socialIds.contains(provider.getProviderId()));
        rep.setProviderAlias(provider.getAlias());
        rep.setDisplayName(KeycloakModelUtils.getIdentityProviderDisplayName((KeycloakSession)this.session, (IdentityProviderModel)provider));
        rep.setGuiOrder(provider.getConfig() != null ? (String)provider.getConfig().get("guiOrder") : null);
        rep.setProviderName(provider.getAlias());
        rep.setLinkedUsername(fedIdentity);
        return rep;
    }

    private boolean matchesLinkedProvider(LinkedAccountRepresentation linkedAccount, String search) {
        if (search == null) {
            return true;
        }
        if (search.startsWith("\"") && search.endsWith("\"")) {
            String name = search.substring(1, search.length() - 1);
            return linkedAccount.getProviderAlias().equals(name) || linkedAccount.getDisplayName().equals(name);
        }
        if (search.startsWith("*") && search.endsWith("*")) {
            String name = search.substring(1, search.length() - 1);
            return linkedAccount.getProviderAlias().contains(name) || linkedAccount.getDisplayName().contains(name);
        }
        if (search.endsWith("*")) {
            String name = search.substring(0, search.length() - 1);
            return linkedAccount.getProviderAlias().startsWith(name) || linkedAccount.getDisplayName().startsWith(name);
        }
        return linkedAccount.getProviderAlias().startsWith(search) || linkedAccount.getDisplayName().startsWith(search);
    }

    @Deprecated
    public List<LinkedAccountRepresentation> getLinkedAccounts(KeycloakSession session, RealmModel realm, UserModel user) {
        return session.identityProviders().getAllStream(Map.of("enabled", "true"), null, null).map(provider -> this.toLinkedAccountRepresentation((IdentityProviderModel)provider, session.users().getFederatedIdentitiesStream(realm, user))).filter(Objects::nonNull).sorted().toList();
    }

    @Deprecated
    private LinkedAccountRepresentation toLinkedAccountRepresentation(IdentityProviderModel provider, Stream<FederatedIdentityModel> identities) {
        boolean hide;
        String providerAlias = provider.getAlias();
        FederatedIdentityModel identity = this.getIdentity(identities, providerAlias);
        if (identity == null && provider.getOrganizationId() != null) {
            return null;
        }
        switch (provider.getShowInAccountConsole()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ALWAYS: {
                boolean bl = false;
                break;
            }
            case WHEN_LINKED: {
                boolean bl;
                if (identity == null) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case NEVER: {
                boolean bl = hide = true;
            }
        }
        if (hide) {
            return null;
        }
        String displayName = KeycloakModelUtils.getIdentityProviderDisplayName((KeycloakSession)this.session, (IdentityProviderModel)provider);
        String guiOrder = provider.getConfig() != null ? (String)provider.getConfig().get("guiOrder") : null;
        LinkedAccountRepresentation rep = new LinkedAccountRepresentation();
        rep.setConnected(identity != null);
        rep.setSocial(this.socialIds.contains(provider.getProviderId()));
        rep.setProviderAlias(providerAlias);
        rep.setDisplayName(displayName);
        rep.setGuiOrder(guiOrder);
        rep.setProviderName(provider.getAlias());
        if (identity != null) {
            rep.setLinkedUsername(identity.getUserName());
        }
        return rep;
    }

    @Deprecated
    private FederatedIdentityModel getIdentity(Stream<FederatedIdentityModel> identities, String providerAlias) {
        return identities.filter(model -> Objects.equals(model.getIdentityProvider(), providerAlias)).findFirst().orElse(null);
    }

    @GET
    @Path(value="/{providerAlias}")
    @Produces(value={"application/json"})
    @Deprecated
    public Response buildLinkedAccountURI(@PathParam(value="providerAlias") String providerAlias, @QueryParam(value="redirectUri") String redirectUri) {
        String errorMessage;
        this.auth.require("manage-account");
        logger.warnf("Using deprecated endpoint of Account REST service for linking user '%s' in the realm '%s' to identity provider '%s'. It is recommended to use application initiated actions (AIA) for linking identity provider with the user.", (Object)this.user.getUsername(), (Object)this.realm.getName(), (Object)providerAlias);
        if (redirectUri == null) {
            ErrorResponse.error("invalidRedirectUriMessage", Response.Status.BAD_REQUEST);
        }
        if ((errorMessage = this.checkCommonPreconditions(providerAlias)) != null) {
            throw ErrorResponse.error(errorMessage, Response.Status.BAD_REQUEST);
        }
        if (this.auth.getSession() == null) {
            throw ErrorResponse.error("sessionNotActiveMessage", Response.Status.BAD_REQUEST);
        }
        try {
            AccountLinkUriRepresentation rep = BrokerUtil.createClientInitiatedLinkURI("account-console", redirectUri, providerAlias, this.realm.getName(), this.auth.getSession().getId(), this.session.getContext().getUri().getBaseUri());
            return Cors.builder().auth().allowedOrigins(this.auth.getToken()).add(Response.ok((Object)rep));
        }
        catch (Exception spe) {
            spe.printStackTrace();
            throw ErrorResponse.error("failedToProcessResponseMessage", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="/{providerAlias}")
    @Produces(value={"application/json"})
    public Response removeLinkedAccount(@PathParam(value="providerAlias") String providerAlias) {
        this.auth.require("manage-account");
        String errorMessage = this.checkCommonPreconditions(providerAlias);
        if (errorMessage != null) {
            throw ErrorResponse.error(errorMessage, Response.Status.BAD_REQUEST);
        }
        FederatedIdentityModel link = this.session.users().getFederatedIdentity(this.realm, this.user, providerAlias);
        if (link == null) {
            throw ErrorResponse.error(this.translateErrorMessage("federatedIdentityLinkNotActiveMessage", new Object[0]), Response.Status.BAD_REQUEST);
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            if (Organizations.resolveHomeBroker(this.session, this.user).stream().map(IdentityProviderModel::getAlias).anyMatch(providerAlias::equals)) {
                throw ErrorResponse.error(this.translateErrorMessage("federatedIdentityBoundOrganization", new Object[0]), Response.Status.BAD_REQUEST);
            }
        }
        if (this.session.users().getFederatedIdentitiesStream(this.realm, this.user).count() <= 1L && !this.user.isFederated() && !this.isPasswordSet()) {
            throw ErrorResponse.error(this.translateErrorMessage("federatedIdentityRemovingLastProviderMessage", new Object[0]), Response.Status.BAD_REQUEST);
        }
        this.session.users().removeFederatedIdentity(this.realm, this.user, providerAlias);
        logger.debugv("Social provider {0} removed successfully from user {1}", (Object)providerAlias, (Object)this.user.getUsername());
        this.event.event(EventType.REMOVE_FEDERATED_IDENTITY).client(this.auth.getClient()).user(this.auth.getUser()).detail("username", this.auth.getUser().getUsername()).detail("identity_provider", link.getIdentityProvider()).detail("identity_provider_identity", link.getUserName()).success();
        return Cors.builder().auth().allowedOrigins(this.auth.getToken()).add(Response.noContent());
    }

    private String checkCommonPreconditions(String providerAlias) {
        this.auth.require("manage-account");
        if (Validation.isEmpty(providerAlias)) {
            return "missingIdentityProviderMessage";
        }
        if (!this.isValidProvider(providerAlias)) {
            return "identityProviderNotFoundMessage";
        }
        if (!this.user.isEnabled()) {
            return "accountDisabledMessage";
        }
        return null;
    }

    private String translateErrorMessage(String errorCode, Object ... params) {
        try {
            Locale locale = this.session.getContext().resolveLocale(this.user);
            String pattern = this.session.theme().getTheme(Theme.Type.ACCOUNT).getMessages(locale).getProperty(errorCode);
            return new MessageFormat(pattern, locale).format(params, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (IOException e) {
            return errorCode;
        }
    }

    private boolean isPasswordSet() {
        return this.user.credentialManager().isConfiguredFor("password");
    }

    private boolean isValidProvider(String providerAlias) {
        return this.session.identityProviders().getByAlias(providerAlias) != null;
    }
}

