/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import java.util.Objects;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public class SqmExistsPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<?> expression;

    public SqmExistsPredicate(SqmExpression<?> expression, NodeBuilder nodeBuilder) {
        this(expression, false, nodeBuilder);
    }

    public SqmExistsPredicate(SqmExpression<?> expression, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.expression = expression;
        expression.applyInferableType(expression.getNodeType());
    }

    @Override
    public SqmExistsPredicate copy(SqmCopyContext context) {
        SqmExistsPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmExistsPredicate predicate = context.registerCopy(this, new SqmExistsPredicate((SqmExpression<?>)this.expression.copy(context), this.isNegated(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public SqmExpression<?> getExpression() {
        return this.expression;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitExistsPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        if (this.isNegated()) {
            hql.append("not exists ");
        } else {
            hql.append("exists ");
        }
        this.expression.appendHqlString(hql, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmExistsPredicate)) return false;
        SqmExistsPredicate that = (SqmExistsPredicate)object;
        if (this.isNegated() != that.isNegated()) return false;
        if (!Objects.equals(this.expression, that.expression)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isNegated(), this.expression);
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmExistsPredicate(this.expression, !this.isNegated(), (NodeBuilder)this.nodeBuilder());
    }
}

