/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.hibernate.boot.MappingNotFoundException;
import org.hibernate.boot.jaxb.JaxbLogger;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.internal.InputStreamXmlSource;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.JaxbBindableMappingDescriptor;

public class FileXmlSource {
    public static Binding<? extends JaxbBindableMappingDescriptor> fromFile(File file, MappingBinder mappingBinder) {
        FileInputStream fis;
        String filePath = file.getPath();
        JaxbLogger.JAXB_LOGGER.tracef("Reading mappings from file: %s", filePath);
        Origin origin = new Origin(SourceType.FILE, filePath);
        if (!file.exists()) {
            throw new MappingNotFoundException(origin);
        }
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new MappingNotFoundException(e, origin);
        }
        return InputStreamXmlSource.fromStream(fis, origin, true, mappingBinder);
    }
}

