/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.vertx.http.runtime.ForwardedServerRequestWrapper;
import io.quarkus.vertx.http.runtime.ForwardingProxyOptions;
import io.quarkus.vertx.http.runtime.TrustedProxyCheck;
import io.smallrye.common.net.Inet;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class ForwardedProxyHandler
implements Handler<HttpServerRequest> {
    private static final Logger LOGGER = Logger.getLogger((String)ForwardedProxyHandler.class.getName());
    private final TrustedProxyCheck.TrustedProxyCheckBuilder proxyCheckBuilder;
    private final Supplier<Vertx> vertx;
    private final Handler<HttpServerRequest> delegate;
    private final ForwardingProxyOptions forwardingProxyOptions;

    public ForwardedProxyHandler(TrustedProxyCheck.TrustedProxyCheckBuilder proxyCheckBuilder, Supplier<Vertx> vertx, Handler<HttpServerRequest> delegate, ForwardingProxyOptions forwardingProxyOptions) {
        this.proxyCheckBuilder = proxyCheckBuilder;
        this.vertx = vertx;
        this.delegate = delegate;
        this.forwardingProxyOptions = forwardingProxyOptions;
    }

    public void handle(HttpServerRequest event) {
        if (event.remoteAddress() == null) {
            LOGGER.debug((Object)"Client address is not available, 'Forwarded' and 'X-Forwarded' headers are going to be ignored");
            this.handleForwardedServerRequest(event, TrustedProxyCheck.denyAll());
        } else if (event.remoteAddress().isDomainSocket()) {
            LOGGER.debug((Object)"Domain socket are not supported, 'Forwarded' and 'X-Forwarded' headers are going to be ignored");
            this.handleForwardedServerRequest(event, TrustedProxyCheck.denyAll());
        } else if (this.proxyCheckBuilder.hasHostNames()) {
            this.lookupHostNamesAndHandleRequest(event, this.proxyCheckBuilder.getHostNameToPort().entrySet().iterator(), this.proxyCheckBuilder, this.vertx.get().createDnsClient());
        } else {
            this.resolveProxyIpAndHandleRequest(event, this.proxyCheckBuilder);
        }
    }

    private void lookupHostNamesAndHandleRequest(HttpServerRequest event, Iterator<Map.Entry<String, Integer>> iterator, TrustedProxyCheck.TrustedProxyCheckBuilder builder, DnsClient dnsClient) {
        if (iterator.hasNext()) {
            Map.Entry<String, Integer> entry = iterator.next();
            String hostName = entry.getKey();
            this.resolveHostNameToAllIpAddresses(dnsClient, hostName, event.remoteAddress(), (Handler<Collection<String>>)((Handler)results -> {
                if (!results.isEmpty()) {
                    Set<InetAddress> trustedIPs = results.stream().map(Inet::parseInetAddress).filter(Objects::nonNull).collect(Collectors.toSet());
                    if (!trustedIPs.isEmpty()) {
                        this.lookupHostNamesAndHandleRequest(event, iterator, builder.withTrustedIP(trustedIPs, (Integer)entry.getValue()), dnsClient);
                    } else {
                        ForwardedProxyHandler.logInvalidIpAddress(hostName);
                        this.lookupHostNamesAndHandleRequest(event, iterator, builder, dnsClient);
                    }
                } else {
                    ForwardedProxyHandler.logDnsLookupFailure(hostName);
                    this.lookupHostNamesAndHandleRequest(event, iterator, builder, dnsClient);
                }
            }));
        } else if (builder.hasProxyChecks()) {
            this.resolveProxyIpAndHandleRequest(event, builder);
        } else {
            this.handleForwardedServerRequest(event, TrustedProxyCheck.denyAll());
        }
    }

    private void resolveHostNameToAllIpAddresses(DnsClient dnsClient, String hostName, SocketAddress callersSocketAddress, Handler<Collection<String>> handler) {
        ArrayList<Future<List<String>>> results = new ArrayList<Future<List<String>>>();
        InetAddress proxyIP = null;
        if (callersSocketAddress != null) {
            proxyIP = ((SocketAddressImpl)callersSocketAddress).ipAddress();
        }
        if (proxyIP == null || proxyIP instanceof Inet4Address) {
            results.add(dnsClient.resolveA(hostName));
        }
        if (proxyIP == null || proxyIP instanceof Inet6Address) {
            results.add(dnsClient.resolveAAAA(hostName));
        }
        this.processFutures(results, new ArrayList<String>(), handler);
    }

    private void processFutures(ArrayList<Future<List<String>>> future, Collection<String> results, Handler<Collection<String>> handler) {
        if (!future.isEmpty()) {
            Future<List<String>> poll = future.remove(0);
            poll.onComplete(result -> {
                if (result.succeeded() && result.result() != null) {
                    results.addAll((Collection)result.result());
                }
                this.processFutures(future, results, handler);
            });
        } else {
            handler.handle(results);
        }
    }

    private void resolveProxyIpAndHandleRequest(HttpServerRequest event, TrustedProxyCheck.TrustedProxyCheckBuilder builder) {
        InetAddress proxyIP = ((SocketAddressImpl)event.remoteAddress()).ipAddress();
        if (proxyIP == null) {
            proxyIP = Inet.parseInetAddress((String)event.remoteAddress().host());
        }
        if (proxyIP == null) {
            String hostName = Objects.requireNonNull(event.remoteAddress().hostName());
            this.resolveHostNameToAllIpAddresses(this.vertx.get().createDnsClient(), hostName, null, (Handler<Collection<String>>)((Handler)results -> {
                TrustedProxyCheck proxyCheck;
                if (!results.isEmpty()) {
                    Set<InetAddress> proxyIPs = results.stream().map(Inet::parseInetAddress).filter(Objects::nonNull).collect(Collectors.toSet());
                    if (!proxyIPs.isEmpty()) {
                        proxyCheck = builder.build(proxyIPs, event.remoteAddress().port());
                    } else {
                        ForwardedProxyHandler.logInvalidIpAddress(hostName);
                        proxyCheck = TrustedProxyCheck.denyAll();
                    }
                } else {
                    ForwardedProxyHandler.logDnsLookupFailure(hostName);
                    proxyCheck = TrustedProxyCheck.denyAll();
                }
                this.handleForwardedServerRequest(event, proxyCheck);
            }));
        } else {
            TrustedProxyCheck proxyCheck = builder.build(proxyIP, event.remoteAddress().port());
            this.handleForwardedServerRequest(event, proxyCheck);
        }
    }

    private void handleForwardedServerRequest(HttpServerRequest event, TrustedProxyCheck proxyCheck) {
        this.delegate.handle((Object)new ForwardedServerRequestWrapper(event, this.forwardingProxyOptions, proxyCheck));
    }

    private static void logInvalidIpAddress(String hostName) {
        LOGGER.debugf("Illegal state - DNS server returned invalid IP address for hostname '%s'", (Object)hostName);
    }

    private static void logDnsLookupFailure(String hostName) {
        LOGGER.debugf("Can't resolve proxy IP address from '%s'", (Object)hostName);
    }
}

