/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime.keystores;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.tls.runtime.config.KeyStoreCredentialProviderConfig;
import io.quarkus.tls.runtime.config.TrustStoreCredentialProviderConfig;
import jakarta.enterprise.inject.literal.NamedLiteral;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;

public class CredentialProviders {
    public static Optional<String> getKeyStorePassword(Optional<String> maybePasswordFromConfig, KeyStoreCredentialProviderConfig config) {
        if (maybePasswordFromConfig.isPresent()) {
            return maybePasswordFromConfig;
        }
        if (config.name().isPresent()) {
            CredentialsProvider provider = CredentialProviders.lookup(config.beanName().orElse(null));
            Map credentials = provider.getCredentials(config.name().get());
            return Optional.ofNullable((String)credentials.get(config.passwordKey()));
        }
        return Optional.empty();
    }

    public static Optional<String> getAliasPassword(Optional<String> maybePasswordFromConfig, KeyStoreCredentialProviderConfig config) {
        if (maybePasswordFromConfig.isPresent()) {
            return maybePasswordFromConfig;
        }
        if (config.name().isPresent()) {
            CredentialsProvider provider = CredentialProviders.lookup(config.beanName().orElse(null));
            Map credentials = provider.getCredentials(config.name().get());
            return Optional.ofNullable((String)credentials.get(config.aliasPasswordKey()));
        }
        return Optional.empty();
    }

    public static Optional<String> getTrustStorePassword(Optional<String> maybePasswordFromConfig, TrustStoreCredentialProviderConfig config) {
        if (maybePasswordFromConfig.isPresent()) {
            return maybePasswordFromConfig;
        }
        if (config.name().isPresent()) {
            CredentialsProvider provider = CredentialProviders.lookup(config.beanName().orElse(null));
            Map credentials = provider.getCredentials(config.name().get());
            return Optional.ofNullable((String)credentials.get(config.passwordKey()));
        }
        return Optional.empty();
    }

    static CredentialsProvider lookup(String name) {
        ArcContainer container = Arc.container();
        InstanceHandle instance = name == null ? container.instance(CredentialsProvider.class, new Annotation[0]) : container.instance(CredentialsProvider.class, new Annotation[]{NamedLiteral.of((String)name)});
        if (!instance.isAvailable()) {
            if (name == null) {
                throw new RuntimeException("Unable to find the default credentials provider");
            }
            throw new RuntimeException("Unable to find the credentials provider named '" + name + "'");
        }
        return (CredentialsProvider)instance.get();
    }
}

