/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;

public final class MultiDistinctOp<T>
extends AbstractMultiOperator<T, T> {
    private final Comparator<? super T> comparator;

    public MultiDistinctOp(Multi<? extends T> upstream) {
        this(upstream, null);
    }

    public MultiDistinctOp(Multi<? extends T> upstream, Comparator<? super T> comparator) {
        super(upstream);
        this.comparator = comparator;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> subscriber) {
        this.upstream.subscribe(new DistinctProcessor<T>(ParameterValidation.nonNullNpe(subscriber, "subscriber"), this.comparator));
    }

    static final class DistinctProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        final Collection<T> collection;

        DistinctProcessor(MultiSubscriber<? super T> downstream, Comparator<? super T> comparator) {
            super(downstream);
            this.collection = comparator == null ? new HashSet<T>() : new TreeSet<T>(comparator);
        }

        @Override
        public void onItem(T t) {
            boolean added;
            if (this.isDone()) {
                return;
            }
            try {
                added = this.collection.add(t);
            }
            catch (Throwable e) {
                this.failAndCancel(e);
                return;
            }
            if (added) {
                this.downstream.onItem(t);
            } else {
                this.request(1L);
            }
        }

        @Override
        public void onFailure(Throwable t) {
            super.onFailure(t);
            this.collection.clear();
        }

        @Override
        public void onCompletion() {
            super.onCompletion();
            this.collection.clear();
        }

        @Override
        public void cancel() {
            super.cancel();
            this.collection.clear();
        }
    }
}

