/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.platform.execution.serviceView.ServiceModel;
import com.intellij.platform.execution.serviceView.ServiceModelFilter;
import com.intellij.platform.execution.serviceView.ServiceViewState;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

abstract class ServiceViewModel
implements Disposable,
InvokerSupplier,
ServiceModel.ServiceModelEventListener {
    protected final ServiceModel myModel;
    protected final ServiceModelFilter myModelFilter;
    private final ServiceModelFilter.ServiceViewFilter myFilter;
    private final List<ServiceViewModelListener> myListeners;
    private volatile boolean myShowGroups;
    private volatile boolean myShowContributorRoots;

    protected ServiceViewModel(@NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, @NotNull ServiceModelFilter.ServiceViewFilter filter) {
        if (model == null) {
            ServiceViewModel.$$$reportNull$$$0(0);
        }
        if (modelFilter == null) {
            ServiceViewModel.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            ServiceViewModel.$$$reportNull$$$0(2);
        }
        this.myListeners = new CopyOnWriteArrayList<ServiceViewModelListener>();
        this.myShowGroups = true;
        this.myModel = model;
        this.myModelFilter = modelFilter;
        this.myFilter = filter;
        this.myModel.addEventListener(this);
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> getRoots() {
        return this.getRoots(false);
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> getVisibleRoots() {
        return this.getRoots(true);
    }

    @NotNull
    private List<? extends ServiceModel.ServiceViewItem> getRoots(boolean visible) {
        List roots = this.processGroups(this.doGetRoots(), visible);
        if (roots.stream().anyMatch(ServiceModel.ContributorNode.class::isInstance)) {
            roots = this.myShowContributorRoots ? ContainerUtil.filter(roots, item -> !(item instanceof ServiceModel.ContributorNode) || !this.getChildren((ServiceModel.ServiceViewItem)item, visible).isEmpty()) : roots.stream().flatMap(item -> item instanceof ServiceModel.ContributorNode ? this.getChildren((ServiceModel.ServiceViewItem)item, visible).stream() : Stream.of(item)).collect(Collectors.toList());
        }
        List list = roots;
        if (list == null) {
            ServiceViewModel.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    protected abstract @Unmodifiable List<? extends ServiceModel.ServiceViewItem> doGetRoots();

    void saveState(ServiceViewState viewState) {
        viewState.groupByContributor = this.myShowContributorRoots;
    }

    void filtersChanged() {
        this.notifyListeners();
    }

    @NotNull
    ServiceModelFilter.ServiceViewFilter getFilter() {
        ServiceModelFilter.ServiceViewFilter serviceViewFilter = this.myFilter;
        if (serviceViewFilter == null) {
            ServiceViewModel.$$$reportNull$$$0(4);
        }
        return serviceViewFilter;
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> getChildren(@NotNull ServiceModel.ServiceViewItem parent) {
        if (parent == null) {
            ServiceViewModel.$$$reportNull$$$0(5);
        }
        List<? extends ServiceModel.ServiceViewItem> list = this.getChildren(parent, true);
        if (list == null) {
            ServiceViewModel.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    protected List<? extends ServiceModel.ServiceViewItem> getChildren(@NotNull ServiceModel.ServiceViewItem parent, boolean visible) {
        if (parent == null) {
            ServiceViewModel.$$$reportNull$$$0(7);
        }
        return this.processGroups(this.myModelFilter.filter(parent.getChildren(), this.myFilter), visible);
    }

    @Nullable
    protected ServiceModel.ServiceViewItem findItemSafe(@NotNull ServiceModel.ServiceViewItem item) {
        ServiceModel.ServiceViewItem updatedItem;
        if (item == null) {
            ServiceViewModel.$$$reportNull$$$0(8);
        }
        if ((updatedItem = ServiceViewModel.findItem(item, this.myModel.getRoots())) != null) {
            return updatedItem;
        }
        return this.myModel.findItemSafe(item.getValue(), item.getRootContributor().getClass());
    }

    void addModelListener(@NotNull ServiceViewModelListener listener) {
        if (listener == null) {
            ServiceViewModel.$$$reportNull$$$0(9);
        }
        this.myListeners.add(listener);
    }

    void removeModelListener(@NotNull ServiceViewModelListener listener) {
        if (listener == null) {
            ServiceViewModel.$$$reportNull$$$0(10);
        }
        this.myListeners.remove(listener);
    }

    boolean isGroupByContributor() {
        return this.myShowContributorRoots;
    }

    void setGroupByContributor(boolean value) {
        if (this.myShowContributorRoots != value) {
            this.myShowContributorRoots = value;
            this.notifyListeners();
        }
    }

    protected void notifyListeners(ServiceEventListener.ServiceEvent e) {
        for (ServiceViewModelListener listener : this.myListeners) {
            listener.eventProcessed(e);
        }
    }

    protected void notifyListeners() {
        for (ServiceViewModelListener listener : this.myListeners) {
            listener.structureChanged();
        }
    }

    public void dispose() {
        this.myModel.removeEventListener(this);
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myModel.getInvoker();
        if (invoker == null) {
            ServiceViewModel.$$$reportNull$$$0(11);
        }
        return invoker;
    }

    @NotNull
    private List<? extends ServiceModel.ServiceViewItem> processGroups(@NotNull List<? extends ServiceModel.ServiceViewItem> items, boolean visible) {
        if (items == null) {
            ServiceViewModel.$$$reportNull$$$0(12);
        }
        if (visible) {
            items = ContainerUtil.filter(items, item -> item.getViewDescriptor().isVisible());
        }
        if (this.myShowGroups) {
            return this.filterEmptyGroups(items, visible);
        }
        List list = items.stream().flatMap(item -> item instanceof ServiceModel.ServiceGroupNode ? this.getChildren((ServiceModel.ServiceViewItem)item, visible).stream() : Stream.of(item)).collect(Collectors.toList());
        if (list == null) {
            ServiceViewModel.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private List<? extends ServiceModel.ServiceViewItem> filterEmptyGroups(@NotNull List<? extends ServiceModel.ServiceViewItem> items, boolean visible) {
        if (items == null) {
            ServiceViewModel.$$$reportNull$$$0(14);
        }
        List list = ContainerUtil.filter(items, item -> !(item instanceof ServiceModel.ServiceGroupNode) || !this.filterEmptyGroups(this.getChildren((ServiceModel.ServiceViewItem)item, visible), visible).isEmpty());
        if (list == null) {
            ServiceViewModel.$$$reportNull$$$0(15);
        }
        return list;
    }

    static ServiceViewModel createModel(@NotNull List<ServiceModel.ServiceViewItem> items, @Nullable ServiceViewContributor<?> contributor, @NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
        if (items == null) {
            ServiceViewModel.$$$reportNull$$$0(16);
        }
        if (model == null) {
            ServiceViewModel.$$$reportNull$$$0(17);
        }
        if (modelFilter == null) {
            ServiceViewModel.$$$reportNull$$$0(18);
        }
        if (contributor != null && items.size() > 1) {
            ServiceModel.ServiceViewItem contributorRoot = null;
            for (ServiceModel.ServiceViewItem serviceViewItem : model.getRoots()) {
                if (contributor != serviceViewItem.getContributor()) continue;
                contributorRoot = serviceViewItem;
                break;
            }
            if (contributorRoot != null && contributorRoot.getChildren().equals(items)) {
                return new ContributorModel(model, modelFilter, contributor, parentFilter);
            }
        }
        if (items.size() == 1) {
            AtomicReference<ServiceModel.ServiceViewItem> ref;
            ServiceModel.ServiceViewItem item = items.get(0);
            if (item instanceof ServiceModel.ContributorNode) {
                return new ContributorModel(model, modelFilter, item.getContributor(), parentFilter);
            }
            if (item instanceof ServiceModel.ServiceGroupNode) {
                ref = new AtomicReference<ServiceModel.ServiceGroupNode>((ServiceModel.ServiceGroupNode)item);
                return new GroupModel(model, modelFilter, ref, parentFilter);
            }
            if (ServiceViewModel.isSingleService(item)) {
                ref = new AtomicReference<ServiceModel.ServiceViewItem>(item);
                return new SingeServiceModel(model, modelFilter, ref, parentFilter);
            }
        }
        return new ServiceListModel(model, modelFilter, items, parentFilter);
    }

    private static boolean isSingleService(ServiceModel.ServiceViewItem item) {
        ServiceModel.ServiceNode node;
        if (!(!(item instanceof ServiceModel.ServiceNode) || (node = (ServiceModel.ServiceNode)item).isChildrenInitialized() && node.isLoaded())) {
            return false;
        }
        return item.getChildren().isEmpty();
    }

    @Nullable
    static ServiceViewModel loadModel(@NotNull ServiceViewState viewState, @NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter, @NotNull Map<String, ServiceViewContributor<?>> contributors) {
        if (viewState == null) {
            ServiceViewModel.$$$reportNull$$$0(19);
        }
        if (model == null) {
            ServiceViewModel.$$$reportNull$$$0(20);
        }
        if (modelFilter == null) {
            ServiceViewModel.$$$reportNull$$$0(21);
        }
        if (contributors == null) {
            ServiceViewModel.$$$reportNull$$$0(22);
        }
        switch (viewState.viewType) {
            case "contributor": {
                ServiceViewState.ServiceState serviceState = (ServiceViewState.ServiceState)ContainerUtil.getOnlyItem(viewState.roots);
                ServiceViewContributor<?> contributor = serviceState == null ? null : contributors.get(serviceState.contributor);
                return contributor == null ? null : new ContributorModel(model, modelFilter, contributor, parentFilter);
            }
            case "group": {
                ServiceViewContributor<?> contributor;
                ServiceViewState.ServiceState serviceState = (ServiceViewState.ServiceState)ContainerUtil.getOnlyItem(viewState.roots);
                ServiceViewContributor<?> serviceViewContributor = contributor = serviceState == null ? null : contributors.get(serviceState.contributor);
                if (contributor == null) {
                    return null;
                }
                ServiceModel.ServiceViewItem groupItem = model.findItemById(serviceState.path, contributor);
                if (!(groupItem instanceof ServiceModel.ServiceGroupNode)) {
                    return null;
                }
                AtomicReference<ServiceModel.ServiceGroupNode> ref = new AtomicReference<ServiceModel.ServiceGroupNode>((ServiceModel.ServiceGroupNode)groupItem);
                return new GroupModel(model, modelFilter, ref, parentFilter);
            }
            case "service": {
                ServiceViewContributor<?> contributor;
                ServiceViewState.ServiceState serviceState = (ServiceViewState.ServiceState)ContainerUtil.getOnlyItem(viewState.roots);
                ServiceViewContributor<?> serviceViewContributor = contributor = serviceState == null ? null : contributors.get(serviceState.contributor);
                if (contributor == null) {
                    return null;
                }
                ServiceModel.ServiceViewItem serviceItem = model.findItemById(serviceState.path, contributor);
                if (serviceItem == null) {
                    return null;
                }
                if (serviceItem.getChildren().isEmpty()) {
                    AtomicReference<ServiceModel.ServiceViewItem> ref = new AtomicReference<ServiceModel.ServiceViewItem>(serviceItem);
                    return new SingeServiceModel(model, modelFilter, ref, parentFilter);
                }
                new ServiceListModel(model, modelFilter, (List<ServiceModel.ServiceViewItem>)new SmartList((Object)serviceItem), parentFilter);
            }
            case "services": {
                ArrayList<ServiceModel.ServiceViewItem> items = new ArrayList<ServiceModel.ServiceViewItem>();
                for (ServiceViewState.ServiceState serviceState : viewState.roots) {
                    ServiceViewContributor<?> contributor = contributors.get(serviceState.contributor);
                    if (contributor == null) continue;
                    ContainerUtil.addIfNotNull(items, (Object)model.findItemById(serviceState.path, contributor));
                }
                return items.isEmpty() ? null : new ServiceListModel(model, modelFilter, items, parentFilter);
            }
        }
        return null;
    }

    @Nullable
    protected static ServiceModel.ServiceViewItem findItem(ServiceModel.ServiceViewItem viewItem, List<? extends ServiceModel.ServiceViewItem> modelItems) {
        return ServiceViewModel.findItem(ServiceViewModel.getPath(viewItem), modelItems);
    }

    @Nullable
    private static ServiceModel.ServiceViewItem findItem(Deque<ServiceModel.ServiceViewItem> path, List<? extends ServiceModel.ServiceViewItem> modelItems) {
        ServiceModel.ServiceViewItem node = path.removeFirst();
        for (ServiceModel.ServiceViewItem serviceViewItem : modelItems) {
            if (!serviceViewItem.equals(node)) continue;
            if (path.isEmpty()) {
                return serviceViewItem;
            }
            return ServiceViewModel.findItem(path, serviceViewItem.getChildren());
        }
        return null;
    }

    protected static Deque<ServiceModel.ServiceViewItem> getPath(ServiceModel.ServiceViewItem item) {
        LinkedList<ServiceModel.ServiceViewItem> path = new LinkedList<ServiceModel.ServiceViewItem>();
        do {
            path.addFirst(item);
        } while ((item = item.getParent()) != null);
        return path;
    }

    @Nullable
    private static List<String> getIdPath(@Nullable ServiceModel.ServiceViewItem item) {
        ArrayList<String> path = new ArrayList<String>();
        while (item != null) {
            String id = item.getViewDescriptor().getId();
            if (id == null) {
                return null;
            }
            path.add(id);
            item = item.getParent();
        }
        Collections.reverse(path);
        return path;
    }

    @Nullable
    private static ServiceViewState.ServiceState getState(@Nullable ServiceModel.ServiceViewItem item) {
        if (item == null) {
            return null;
        }
        List<String> path = ServiceViewModel.getIdPath(item);
        if (path == null) {
            return null;
        }
        ServiceViewState.ServiceState serviceState = new ServiceViewState.ServiceState();
        serviceState.contributor = item.getRootContributor().getClass().getName();
        serviceState.path = path;
        return serviceState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 11, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceViewModel";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewState";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "processGroups";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findItemSafe";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addModelListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeModelListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processGroups";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyGroups";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 11, 13, 15 -> new IllegalStateException(string);
        };
    }

    static interface ServiceViewModelListener {
        default public void eventProcessed(@NotNull ServiceEventListener.ServiceEvent e) {
            if (e == null) {
                ServiceViewModelListener.$$$reportNull$$$0(0);
            }
            this.structureChanged();
        }

        public void structureChanged();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/platform/execution/serviceView/ServiceViewModel$ServiceViewModelListener", "eventProcessed"));
        }
    }

    static final class ContributorModel
    extends ServiceViewModel {
        private static final String TYPE = "contributor";
        private final ServiceViewContributor<?> myContributor;

        ContributorModel(@NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, final @NotNull ServiceViewContributor<?> contributor, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            if (model == null) {
                ContributorModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                ContributorModel.$$$reportNull$$$0(1);
            }
            if (contributor == null) {
                ContributorModel.$$$reportNull$$$0(2);
            }
            super(model, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    return contributor.equals(item.getContributor());
                }
            });
            this.myContributor = contributor;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            List<? extends ServiceModel.ServiceViewItem> list = this.myModelFilter.filter(ContainerUtil.filter(this.myModel.getRoots(), (Condition)this.getFilter()), this.getFilter());
            if (list == null) {
                ContributorModel.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            if (e.contributorClass.isInstance(this.myContributor)) {
                this.notifyListeners(e);
            }
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            ServiceViewState.ServiceState serviceState = new ServiceViewState.ServiceState();
            serviceState.contributor = this.myContributor.getClass().getName();
            viewState.roots = new SmartList((Object)serviceState);
        }

        ServiceViewContributor<?> getContributor() {
            return this.myContributor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = TYPE;
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceViewModel$ContributorModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewModel$ContributorModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class GroupModel
    extends ServiceViewModel {
        private static final String TYPE = "group";
        private final AtomicReference<ServiceModel.ServiceGroupNode> myGroupRef;

        GroupModel(@NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, final @NotNull AtomicReference<ServiceModel.ServiceGroupNode> groupRef, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            if (model == null) {
                GroupModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                GroupModel.$$$reportNull$$$0(1);
            }
            if (groupRef == null) {
                GroupModel.$$$reportNull$$$0(2);
            }
            super(model, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    ServiceModel.ServiceGroupNode group = (ServiceModel.ServiceGroupNode)groupRef.get();
                    ServiceModel.ServiceViewItem parent = item.getParent();
                    return parent != null && group != null && ServiceViewModel.getPath(parent).equals(ServiceViewModel.getPath(group));
                }
            });
            this.myGroupRef = groupRef;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            ServiceModel.ServiceGroupNode group = this.myGroupRef.get();
            List<Object> list = group == null ? Collections.emptyList() : this.getChildren(group, false);
            if (list == null) {
                GroupModel.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            ServiceModel.ServiceGroupNode group = this.myGroupRef.get();
            if (group == null || !e.contributorClass.isInstance(group.getRootContributor())) {
                return;
            }
            this.myGroupRef.set((ServiceModel.ServiceGroupNode)GroupModel.findItem(group, this.myModel.getRoots()));
            this.notifyListeners(e);
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            ContainerUtil.addIfNotNull(viewState.roots, (Object)ServiceViewModel.getState(this.myGroupRef.get()));
        }

        ServiceModel.ServiceGroupNode getGroup() {
            return this.myGroupRef.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupRef";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceViewModel$GroupModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewModel$GroupModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class SingeServiceModel
    extends ServiceViewModel {
        private static final String TYPE = "service";
        private final AtomicReference<ServiceModel.ServiceViewItem> myServiceRef;

        SingeServiceModel(@NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, final @NotNull AtomicReference<ServiceModel.ServiceViewItem> serviceRef, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            if (model == null) {
                SingeServiceModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                SingeServiceModel.$$$reportNull$$$0(1);
            }
            if (serviceRef == null) {
                SingeServiceModel.$$$reportNull$$$0(2);
            }
            super(model, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    return item.equals(serviceRef.get());
                }
            });
            this.myServiceRef = serviceRef;
        }

        @Override
        @NotNull
        protected @Unmodifiable List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            ServiceModel.ServiceViewItem service = this.myServiceRef.get();
            List list = ContainerUtil.createMaybeSingletonList((Object)service);
            if (list == null) {
                SingeServiceModel.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            ServiceModel.ServiceViewItem service = this.myServiceRef.get();
            if (service == null || !e.contributorClass.isInstance(service.getRootContributor())) {
                return;
            }
            this.myServiceRef.set(this.findItemSafe(service));
            this.notifyListeners(e);
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            ContainerUtil.addIfNotNull(viewState.roots, (Object)ServiceViewModel.getState(this.myServiceRef.get()));
        }

        ServiceModel.ServiceViewItem getService() {
            return this.myServiceRef.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceRef";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceViewModel$SingeServiceModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewModel$SingeServiceModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class ServiceListModel
    extends ServiceViewModel {
        private static final String TYPE = "services";
        private final List<ServiceModel.ServiceViewItem> myRoots;

        ServiceListModel(@NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, final @NotNull List<ServiceModel.ServiceViewItem> roots, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            if (model == null) {
                ServiceListModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                ServiceListModel.$$$reportNull$$$0(1);
            }
            if (roots == null) {
                ServiceListModel.$$$reportNull$$$0(2);
            }
            super(model, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    return roots.contains(item);
                }
            });
            this.myRoots = new CopyOnWriteArrayList<ServiceModel.ServiceViewItem>(roots);
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            List<? extends ServiceModel.ServiceViewItem> list = this.myModelFilter.filter(this.myRoots, this.getFilter());
            if (list == null) {
                ServiceListModel.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            boolean update = false;
            ArrayList<ServiceModel.ServiceViewItem> toRemove = new ArrayList<ServiceModel.ServiceViewItem>();
            for (int i = 0; i < this.myRoots.size(); ++i) {
                ServiceModel.ServiceViewItem node = this.myRoots.get(i);
                if (!e.contributorClass.isInstance(node.getRootContributor())) continue;
                ServiceModel.ServiceViewItem updatedNode = this.findItemSafe(node);
                if (updatedNode != null) {
                    this.myRoots.remove(i);
                    this.myRoots.add(i, updatedNode);
                } else {
                    toRemove.add(node);
                }
                update = true;
            }
            this.myRoots.removeAll(toRemove);
            if (update) {
                this.notifyListeners(e);
            }
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            for (ServiceModel.ServiceViewItem root : this.myRoots) {
                ContainerUtil.addIfNotNull(viewState.roots, (Object)ServiceViewModel.getState(root));
            }
        }

        List<ServiceModel.ServiceViewItem> getItems() {
            return this.myRoots;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceViewModel$ServiceListModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewModel$ServiceListModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class AllServicesModel
    extends ServiceViewModel {
        AllServicesModel(@NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, final @NotNull Collection<ServiceViewContributor<?>> contributors) {
            if (model == null) {
                AllServicesModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                AllServicesModel.$$$reportNull$$$0(1);
            }
            if (contributors == null) {
                AllServicesModel.$$$reportNull$$$0(2);
            }
            super(model, modelFilter, new ServiceModelFilter.ServiceViewFilter(null){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    return contributors.contains(item.getRootContributor());
                }
            });
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            List<? extends ServiceModel.ServiceViewItem> list = this.myModelFilter.filter(ContainerUtil.filter(this.myModel.getRoots(), (Condition)this.getFilter()), this.getFilter());
            if (list == null) {
                AllServicesModel.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            this.notifyListeners(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributors";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceViewModel$AllServicesModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewModel$AllServicesModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

