/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.segments;

import java.util.ArrayList;
import java.util.List;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.PointFlag;
import tim.prune.cmd.SetSegmentsCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;

public class MergeSegmentsFunction
extends GenericFunction {
    public MergeSegmentsFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "menu.range.mergetracksegments";
    }

    @Override
    public void begin() {
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        if (n < 0 || n2 <= n) {
            return;
        }
        List<PointFlag> list = this.getFlags(this._app.getTrackInfo().getTrack(), n, n2);
        if (!list.isEmpty()) {
            SetSegmentsCmd setSegmentsCmd = new SetSegmentsCmd(list);
            setSegmentsCmd.setConfirmText(I18nManager.getText("confirm.mergetracksegments"));
            setSegmentsCmd.setDescription(this.getName());
            this._app.execute(setSegmentsCmd);
        }
    }

    private List<PointFlag> getFlags(Track track, int n, int n2) {
        DataPoint dataPoint;
        ArrayList<PointFlag> arrayList = new ArrayList<PointFlag>();
        boolean bl = true;
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint2 = track.getPoint(n3);
            if (!dataPoint2.isWaypoint()) {
                boolean bl2 = dataPoint2.getSegmentStart();
                if (bl) {
                    if (!bl2) {
                        arrayList.add(new PointFlag(dataPoint2, true));
                    }
                    bl = false;
                } else if (bl2) {
                    arrayList.add(new PointFlag(dataPoint2, false));
                }
            }
            ++n3;
        }
        if (!arrayList.isEmpty() && (dataPoint = track.getNextTrackPoint(n2 + 1)) != null) {
            arrayList.add(new PointFlag(dataPoint, true));
        }
        return arrayList;
    }
}

