import * as Util from 'resource:///org/gnome/shell/misc/util.js';
import * as Main from 'resource:///org/gnome/shell/ui/main.js';
import * as MessageTray from 'resource:///org/gnome/shell/ui/messageTray.js';
import * as Resources from './resource_helpers.js';

export class PanelHelper {
    static notify(details, iconName, action = 4, urgency = 1) {
        const icon = Resources.Icon.getByName(iconName);
        const source = new MessageTray.Source({
            title: 'SuperGFX',
            icon: icon,
            iconName: iconName,
            policy: new MessageTray.NotificationGenericPolicy(),
        });
        const notification = new MessageTray.Notification({
            source: source,
            title: 'Graphics',
            body: details,
            gicon: icon,
            iconName: iconName,
            isTransient: true,
        });
        Main.messageTray.add(source);

        switch (action) {
            case 0:
                notification.urgency = 3;
                notification.addAction('Log Out Now!', () => {
                    Util.spawnCommandLine('gnome-session-quit');
                });
                break;
            case 1:
                notification.urgency = 3;
                notification.addAction('Reboot Now!', () => {
                    Util.spawnCommandLine('shutdown -ar now');
                });
                break;
            default:
                notification.urgency = urgency;
        }
        source.addNotification(notification);
    }
}
