/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Platform;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.Container;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.Tooltip;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Ray;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.PinchToZoomGesture;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.FPSCounter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import jogamp.graph.ui.TreeTool;

public final class Scene
implements Container,
GLEventListener {
    public static final float DEFAULT_SCENE_DIST = -0.2f;
    public static final float DEFAULT_ANGLE = 0.7853982f;
    public static final float DEFAULT_ZNEAR = 0.1f;
    public static final float DEFAULT_ZFAR = 7000.0f;
    public static final float DEFAULT_Z16_EPSILON = FloatUtil.getZBufferEpsilon(16, -0.2f, 0.1f);
    public static final float DEFAULT_ACTIVE_ZOFFSET_SCALE = 10.0f;
    public static final float DEFAULT_ACTIVE_TOPLEVEL_ZOFFSET_SCALE = 100.0f;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_PICKING = false;
    private final List<Shape> shapes = new CopyOnWriteArrayList<Shape>();
    private Shape[] displayShapeArray = new Shape[0];
    private final List<Shape> renderedShapesB0 = new ArrayList<Shape>();
    private final List<Shape> renderedShapesB1 = new ArrayList<Shape>();
    private final List<Shape> renderedShapesB2 = new ArrayList<Shape>();
    private volatile List<Shape> renderedShapes = this.renderedShapesB1;
    private int renderedShapesIdx = 1;
    private final AtomicReference<Tooltip> tooltipActive = new AtomicReference();
    private final AtomicReference<Shape> tooltipHUD = new AtomicReference();
    private final List<Group> topLevel = new ArrayList<Group>();
    private boolean doFrustumCulling = false;
    private float[] clearColor = null;
    private int clearMask;
    private final RegionRenderer renderer;
    private final AABBox planeBox = new AABBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private volatile Shape activeShape = null;
    private volatile Group activeTopLevel = null;
    private SBCMouseListener sbcMouseListener = null;
    private SBCGestureListener sbcGestureListener = null;
    private PinchToZoomGesture pinchToZoomGesture = null;
    private SBCKeyListener sbcKeyListener = null;
    private final GLReadBufferUtil screenshot;
    private GLAutoDrawable cDrawable = null;
    private volatile boolean displayedOnce = false;
    private final Object syncDisplayedOnce = new Object();
    private final List<GLRunnable> disposeActions = new ArrayList<GLRunnable>();
    private float activeZOffsetScale = 10.0f;
    private float activeTopLevelZOffsetScale = 100.0f;
    private final PMVMatrix4f dispMEPSPMv = new PMVMatrix4f();
    private final Ray dispMEPSRay = new Ray();
    private final Vec3f dispMEPSObjPos = new Vec3f();
    private int screenShotCount = 0;
    private PMVMatrixSetup pmvMatrixSetup = new DefaultPMVMatrixSetup();

    public static float getZEpsilon(int n, PMVMatrixSetup pMVMatrixSetup) {
        return FloatUtil.getZBufferEpsilon(n, pMVMatrixSetup.getSceneDist(), pMVMatrixSetup.getZNear());
    }

    private static RegionRenderer createRenderer() {
        return RegionRenderer.create(RegionRenderer.defaultBlendEnable, RegionRenderer.defaultBlendDisable);
    }

    public Scene() {
        this(Scene.createRenderer());
    }

    public Scene(int n) {
        this(Scene.createRenderer());
        this.getRenderer().setSampleCount(n);
    }

    public Scene(RegionRenderer regionRenderer) {
        if (null == regionRenderer) {
            throw new IllegalArgumentException("Null RegionRenderer");
        }
        this.renderer = regionRenderer;
        this.screenshot = Platform.OSType.ANDROID != Platform.getOSType() ? new GLReadBufferUtil(false, false) : null;
    }

    public RegionRenderer getRenderer() {
        return this.renderer;
    }

    public final void setClearParams(float[] fArray, int n) {
        this.clearColor = fArray;
        this.clearMask = n;
    }

    public final float[] getClearColor() {
        return this.clearColor;
    }

    public final int getClearMask() {
        return this.clearMask;
    }

    @Override
    public final void setPMvCullingEnabled(boolean bl) {
        this.doFrustumCulling = bl;
    }

    @Override
    public final boolean isPMvCullingEnabled() {
        return this.doFrustumCulling;
    }

    @Override
    public final boolean isCullingEnabled() {
        return this.doFrustumCulling;
    }

    public synchronized void attachGLAutoDrawable(GLAutoDrawable gLAutoDrawable) {
        this.cDrawable = gLAutoDrawable;
    }

    public synchronized void detachGLAutoDrawable(GLAutoDrawable gLAutoDrawable) {
        if (this.cDrawable == gLAutoDrawable) {
            this.cDrawable = null;
        }
    }

    public synchronized void attachInputListenerTo(GLWindow gLWindow) {
        this.cDrawable = gLWindow;
        if (null == this.sbcMouseListener) {
            this.sbcMouseListener = new SBCMouseListener();
            gLWindow.addMouseListener(this.sbcMouseListener);
            this.sbcGestureListener = new SBCGestureListener();
            gLWindow.addGestureListener(this.sbcGestureListener);
            this.pinchToZoomGesture = new PinchToZoomGesture(gLWindow.getNativeSurface(), false);
            gLWindow.addGestureHandler(this.pinchToZoomGesture);
        }
        if (null == this.sbcKeyListener) {
            this.sbcKeyListener = new SBCKeyListener();
            gLWindow.addKeyListener(this.sbcKeyListener);
        }
    }

    public synchronized void detachInputListenerFrom(GLWindow gLWindow) {
        if (null != this.sbcMouseListener) {
            gLWindow.removeMouseListener(this.sbcMouseListener);
            this.sbcMouseListener = null;
            gLWindow.removeGestureListener(this.sbcGestureListener);
            this.sbcGestureListener = null;
            gLWindow.removeGestureHandler(this.pinchToZoomGesture);
            this.pinchToZoomGesture = null;
        }
        if (null == this.sbcKeyListener) {
            gLWindow.removeKeyListener(this.sbcKeyListener);
            this.sbcKeyListener = null;
        }
    }

    @Override
    public int getShapeCount() {
        return this.shapes.size();
    }

    @Override
    public List<Shape> getShapes() {
        return this.shapes;
    }

    @Override
    public List<Shape> getRenderedShapes() {
        return this.renderedShapes;
    }

    @Override
    public void addShape(Shape shape) {
        this.shapes.add(shape);
    }

    @Override
    public Shape removeShape(Shape shape) {
        if (this.shapes.remove(shape)) {
            return shape;
        }
        return null;
    }

    @Override
    public void removeShapes(Collection<? extends Shape> collection) {
        for (Shape shape : collection) {
            this.removeShape(shape);
        }
    }

    @Override
    public boolean removeShape(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Shape shape) {
        if (this.shapes.remove(shape)) {
            shape.destroy(gL2ES2, regionRenderer);
            return true;
        }
        return false;
    }

    public boolean removeShape(GL2ES2 gL2ES2, Shape shape) {
        return this.removeShape(gL2ES2, this.renderer, shape);
    }

    @Override
    public void addShapes(Collection<? extends Shape> collection) {
        for (Shape shape : collection) {
            this.addShape(shape);
        }
    }

    @Override
    public void removeShapes(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Collection<? extends Shape> collection) {
        for (Shape shape : collection) {
            this.removeShape(gL2ES2, regionRenderer, shape);
        }
    }

    public void removeShapes(GL2ES2 gL2ES2, Collection<? extends Shape> collection) {
        this.removeShapes(gL2ES2, this.renderer, collection);
    }

    @Override
    public void removeAllShapes(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        int n = this.shapes.size();
        for (int i = n - 1; i >= 0; --i) {
            this.removeShape(gL2ES2, regionRenderer, this.shapes.get(i));
        }
    }

    public void removeAllShapes(GL2ES2 gL2ES2) {
        this.removeAllShapes(gL2ES2, this.renderer);
    }

    @Override
    public boolean contains(Shape shape) {
        return TreeTool.contains(this, shape);
    }

    @Override
    public Shape getShapeByIdx(int n) {
        if (0 > n) {
            return null;
        }
        return this.shapes.get(n);
    }

    @Override
    public Shape getShapeByID(int n) {
        return TreeTool.getShapeByID(this, n);
    }

    @Override
    public Shape getShapeByName(String string) {
        return TreeTool.getShapeByName(this, string);
    }

    public int getSampleCount() {
        return this.renderer.getSampleCount();
    }

    public int setSampleCount(int n) {
        return this.renderer.setSampleCount(n);
    }

    public int getAAQuality() {
        return this.renderer.getAAQuality();
    }

    public int setAAQuality(int n) {
        return this.renderer.setAAQuality(n);
    }

    public void setSharpness(float f) {
        TreeTool.forAll(this, shape -> {
            if (shape instanceof GraphShape) {
                ((GraphShape)shape).setSharpness(f);
            }
            return false;
        });
    }

    public void markShapesDirty() {
        TreeTool.forAll(this, shape -> {
            shape.markShapeDirty();
            return false;
        });
    }

    public void markStatesDirty() {
        TreeTool.forAll(this, shape -> {
            shape.markStateDirty();
            return false;
        });
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        if (null == this.cDrawable) {
            this.cDrawable = gLAutoDrawable;
        }
        this.renderer.init(gLAutoDrawable.getGL().getGL2ES2());
    }

    public boolean invoke(boolean bl, GLRunnable gLRunnable) throws IllegalStateException {
        if (null != this.cDrawable) {
            return this.cDrawable.invoke(bl, gLRunnable);
        }
        return false;
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        if (null != this.cDrawable) {
            this.cDrawable.addGLEventListener(gLEventListener);
        }
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        if (null != this.cDrawable) {
            this.cDrawable.removeGLEventListener(gLEventListener);
        }
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.renderer.reshapeNotify(n, n2, n3, n4);
        this.setupMatrix(this.renderer.getMatrix(), this.renderer.getViewport());
        this.pmvMatrixSetup.setPlaneBox(this.planeBox, this.renderer.getMatrix(), this.renderer.getViewport());
    }

    @Override
    public final boolean isOutside(PMVMatrix4f pMVMatrix4f, Shape shape) {
        if (this.doFrustumCulling) {
            pMVMatrix4f.pushMv();
            shape.applyMatToMv(pMVMatrix4f);
            boolean bl = pMVMatrix4f.getFrustum().isOutside(shape.getBounds());
            pMVMatrix4f.popMv();
            return bl;
        }
        return false;
    }

    @Override
    public boolean isOutside2(Matrix4f matrix4f, Shape shape, PMVMatrix4f pMVMatrix4f) {
        if (this.doFrustumCulling) {
            return pMVMatrix4f.getFrustum().isOutside(shape.getBounds());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        List<Shape> list;
        int n;
        int n2 = this.shapes.size();
        Arrays.fill(this.displayShapeArray, null);
        Shape[] shapeArray = this.shapes.toArray(this.displayShapeArray);
        this.displayShapeArray = shapeArray;
        Arrays.sort(shapeArray, 0, n2, Shape.ZAscendingComparator);
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        PMVMatrix4f pMVMatrix4f = this.renderer.getMatrix();
        switch (this.renderedShapesIdx) {
            case 0: {
                n = 1;
                list = this.renderedShapesB1;
                break;
            }
            case 1: {
                n = 2;
                list = this.renderedShapesB2;
                break;
            }
            default: {
                n = 0;
                list = this.renderedShapesB0;
            }
        }
        if (null != this.clearColor) {
            gL2ES2.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
            gL2ES2.glClear(this.clearMask);
        }
        this.renderer.enable(gL2ES2, true);
        Object object = list;
        synchronized (object) {
            list.clear();
            for (int i = 0; i < n2; ++i) {
                Shape shape = shapeArray[i];
                if (!shape.isVisible()) continue;
                pMVMatrix4f.pushMv();
                shape.applyMatToMv(pMVMatrix4f);
                if (!this.doFrustumCulling || !pMVMatrix4f.getFrustum().isOutside(shape.getBounds())) {
                    shape.draw(gL2ES2, this.renderer);
                    list.add(shape);
                    shape.setDiscarded(false);
                } else {
                    shape.setDiscarded(true);
                }
                pMVMatrix4f.popMv();
            }
        }
        this.renderer.enable(gL2ES2, false);
        this.renderedShapes = list;
        this.renderedShapesIdx = n;
        object = this.syncDisplayedOnce;
        synchronized (object) {
            this.displayedOnce = true;
            this.syncDisplayedOnce.notifyAll();
        }
        object = this.tooltipActive.get();
        if (null != object) {
            this.tickTooltip(gLAutoDrawable, pMVMatrix4f, (Tooltip)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayGLSelect(GLAutoDrawable gLAutoDrawable, Object[] objectArray) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2ES2.glClear(16640);
        PMVMatrix4f pMVMatrix4f = this.renderer.getMatrix();
        this.renderer.enable(gL2ES2, true, RegionRenderer.defaultBlendDisable, RegionRenderer.defaultBlendDisable);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Shape shape = (Shape)objectArray[i];
            if (!shape.isVisible()) continue;
            pMVMatrix4f.pushMv();
            shape.applyMatToMv(pMVMatrix4f);
            if (!this.doFrustumCulling || !pMVMatrix4f.getFrustum().isOutside(shape.getBounds())) {
                float f = ((float)i + 1.0f) / ((float)n + 2.0f);
                this.renderer.setColorStatic(f, f, f, 1.0f);
                shape.drawToSelect(gL2ES2, this.renderer);
            }
            pMVMatrix4f.popMv();
        }
        this.renderer.enable(gL2ES2, false, RegionRenderer.defaultBlendDisable, RegionRenderer.defaultBlendDisable);
        Object object = this.syncDisplayedOnce;
        synchronized (object) {
            this.displayedOnce = true;
            this.syncDisplayedOnce.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDisplayed() {
        Object object = this.syncDisplayedOnce;
        synchronized (object) {
            while (!this.displayedOnce) {
                try {
                    this.syncDisplayedOnce.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        int n;
        Object object = this.syncDisplayedOnce;
        synchronized (object) {
            this.displayedOnce = false;
            this.syncDisplayedOnce.notifyAll();
        }
        if (gLAutoDrawable instanceof GLWindow) {
            object = (GLWindow)gLAutoDrawable;
            this.detachInputListenerFrom((GLWindow)object);
        }
        object = gLAutoDrawable.getGL().getGL2ES2();
        for (n = 0; n < this.shapes.size(); ++n) {
            this.shapes.get(n).destroy((GL2ES2)object, this.renderer);
        }
        for (n = 0; n < this.disposeActions.size(); ++n) {
            try {
                this.disposeActions.get(n).run(gLAutoDrawable);
                continue;
            }
            catch (Throwable throwable) {
                System.err.println("Scene.dispose: Caught Exception @ User Disposable[" + n + "]: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        this.shapes.clear();
        this.topLevel.clear();
        this.displayShapeArray = new Shape[0];
        this.renderedShapesB0.clear();
        this.renderedShapesB1.clear();
        this.renderedShapesB2.clear();
        this.renderedShapes = this.renderedShapesB1;
        this.renderedShapesIdx = 1;
        this.disposeActions.clear();
        if (gLAutoDrawable == this.cDrawable) {
            this.cDrawable = null;
        }
        this.renderer.destroy((GL2ES2)object);
        if (null != this.screenshot) {
            this.screenshot.dispose((GL)object);
        }
    }

    public void addDisposeAction(GLRunnable gLRunnable) {
        this.disposeActions.add(gLRunnable);
    }

    public void winToShapeCoord(Shape shape, int n, int n2, PMVMatrix4f pMVMatrix4f, Vec3f vec3f, Runnable runnable) {
        if (null == shape) {
            return;
        }
        Recti recti = this.getViewport();
        this.setupMatrix(pMVMatrix4f);
        TreeTool.forOne(this, pMVMatrix4f, shape, () -> {
            if (null != shape.winToShapeCoord(pMVMatrix4f, recti, n, n2, vec3f)) {
                runnable.run();
            }
        });
    }

    @Override
    public AABBox getBounds(PMVMatrix4f pMVMatrix4f, Shape shape) {
        AABBox aABBox = new AABBox();
        if (null == shape) {
            return aABBox;
        }
        this.setupMatrix(pMVMatrix4f);
        TreeTool.forOne(this, pMVMatrix4f, shape, () -> shape.getBounds().transform(pMVMatrix4f.getMv(), aABBox));
        return aABBox;
    }

    public final PMVMatrixSetup getPMVMatrixSetup() {
        return this.pmvMatrixSetup;
    }

    public final void setPMVMatrixSetup(PMVMatrixSetup pMVMatrixSetup) {
        this.pmvMatrixSetup = pMVMatrixSetup;
    }

    public void setupMatrix(PMVMatrix4f pMVMatrix4f, Recti recti) {
        this.pmvMatrixSetup.set(pMVMatrix4f, recti);
    }

    public void setupMatrix(PMVMatrix4f pMVMatrix4f) {
        Recti recti = this.renderer.getViewport();
        this.setupMatrix(pMVMatrix4f, recti);
    }

    public final Recti getViewport(Recti recti) {
        return this.renderer.getViewport(recti);
    }

    public Recti getViewport() {
        return this.renderer.getViewport();
    }

    public int getWidth() {
        return this.renderer.getWidth();
    }

    public int getHeight() {
        return this.renderer.getHeight();
    }

    public PMVMatrix4f getMatrix() {
        return this.renderer.getMatrix();
    }

    public AABBox getBounds() {
        return this.planeBox;
    }

    public float getZEpsilon(int n) {
        return FloatUtil.getZBufferEpsilon(n, this.pmvMatrixSetup.getSceneDist(), this.pmvMatrixSetup.getZNear());
    }

    public static void winToPlaneCoord(PMVMatrix4f pMVMatrix4f, Recti recti, float f, float f2, float f3, float f4, float f5, Vec3f vec3f) {
        float f6 = FloatUtil.getOrthoWinZ(f5, f, f2);
        pMVMatrix4f.mapWinToObj(f3, f4, f6, recti, vec3f);
    }

    public void surfaceToPlaneSize(Recti recti, float f, float f2, float f3, Vec2f vec2f) {
        PMVMatrix4f pMVMatrix4f = new PMVMatrix4f();
        this.setupMatrix(pMVMatrix4f, recti);
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Scene.winToPlaneCoord(pMVMatrix4f, recti, 0.1f, 7000.0f, recti.x(), recti.y(), f3, vec3f);
        Scene.winToPlaneCoord(pMVMatrix4f, recti, 0.1f, 7000.0f, recti.width(), recti.height(), f3, vec3f2);
        vec2f.set(vec3f2.x() - vec3f.x(), vec3f2.y() - vec3f.y());
    }

    public void surfaceToPlaneSize(Recti recti, Vec2f vec2f) {
        this.surfaceToPlaneSize(recti, 0.1f, 7000.0f, 0.2f, vec2f);
    }

    public final Shape getActiveShape() {
        return this.activeShape;
    }

    public void releaseActiveShape() {
        Shape shape = this.activeShape;
        if (null != shape) {
            Group group = this.activeTopLevel;
            shape.setActive(false, 0.0f);
            this.activeShape = null;
            this.activeTopLevel = null;
            if (null != group) {
                group.setActiveTopLevel(false, 0.0f);
            }
        }
    }

    private void setActiveShape(Shape shape) {
        Shape shape2 = this.activeShape;
        if (shape2 != shape && null != shape) {
            float f = this.getZEpsilon(16);
            boolean bl = this.topLevel.contains(shape);
            float f2 = (bl ? this.activeZOffsetScale : this.activeTopLevelZOffsetScale) * f;
            if (shape.setActive(true, f2)) {
                Group group = this.activeTopLevel;
                Group group2 = bl ? (Group)shape : this.getTopLevelParent(shape);
                int n = 0;
                if (null != shape2 && group2 != shape2) {
                    shape2.setActive(false, 0.0f);
                    n += 10;
                }
                if (group != group2) {
                    n += 100;
                    if (null != group) {
                        group.setActiveTopLevel(false, 0.0f);
                        n += 1000;
                    }
                    if (null != group2 && !bl) {
                        group2.setActiveTopLevel(true, this.activeTopLevelZOffsetScale * f);
                        n += 10000;
                    }
                    this.activeTopLevel = group2;
                }
                n += 0;
                this.activeShape = shape;
            }
        }
    }

    public float getActiveShapeZOffsetScale() {
        return this.activeZOffsetScale;
    }

    public void setActiveShapeZOffsetScale(float f) {
        this.activeZOffsetScale = f;
    }

    public float getActiveTopLevelZOffsetScale() {
        return this.activeTopLevelZOffsetScale;
    }

    public void setActiveTopLevelZOffsetScale(float f) {
        this.activeTopLevelZOffsetScale = f;
    }

    void addTopLevel(Group group) {
        this.topLevel.add(group);
    }

    void removeTopLevel(Group group) {
        this.topLevel.add(group);
    }

    private Group getTopLevelParent(Shape shape) {
        for (Group group : this.topLevel) {
            if (!group.contains(shape)) continue;
            return group;
        }
        return null;
    }

    private void dumpTopLevelParent() {
        int n = 0;
        for (Group group : this.topLevel) {
            boolean bl = group.isActive();
            System.err.printf("- %02d: 0x%08x %s %s/%s, %s%n", n++, System.identityHashCode(group), bl ? "****" : "____", group.getClass().getSimpleName(), group.getName(), group);
            if (!group.isActive()) continue;
            int n2 = n - 1;
            int[] nArray = new int[]{0};
            TreeTool.forAll(group, shape -> {
                boolean bl = shape.isActive();
                Object[] objectArray = new Object[7];
                objectArray[0] = n2;
                int n2 = nArray[0];
                nArray[0] = n2 + 1;
                objectArray[1] = n2;
                objectArray[2] = System.identityHashCode(shape);
                objectArray[3] = bl ? "****" : "____";
                objectArray[4] = shape.getClass().getSimpleName();
                objectArray[5] = shape.getName();
                objectArray[6] = shape;
                System.err.printf("- %02d:%02d: 0x%08x %s %s/%s, %s%n", objectArray);
                return false;
            });
        }
    }

    public void pickShapeGL(final int n, final int n2, final Vec3f vec3f, final Shape[] shapeArray, final Runnable runnable) {
        if (null == this.cDrawable) {
            return;
        }
        this.cDrawable.invoke(false, new GLRunnable(){

            @Override
            public boolean run(GLAutoDrawable gLAutoDrawable) {
                Shape shape;
                shapeArray[0] = shape = Scene.this.pickShapeGLImpl(gLAutoDrawable, n, n2);
                if (null != shape) {
                    PMVMatrix4f pMVMatrix4f = Scene.this.renderer.getMatrix();
                    pMVMatrix4f.pushMv();
                    shape.applyMatToMv(pMVMatrix4f);
                    boolean bl = null != shapeArray[0].winToShapeCoord(Scene.this.getMatrix(), Scene.this.getViewport(), n, n2, vec3f);
                    pMVMatrix4f.popMv();
                    if (bl) {
                        runnable.run();
                    }
                }
                return false;
            }
        });
    }

    private Shape pickShapeGLImpl(GLAutoDrawable gLAutoDrawable, int n, int n2) {
        Object[] objectArray = this.shapes.toArray();
        Arrays.sort(objectArray, Shape.ZAscendingComparator);
        GLPixelStorageModes gLPixelStorageModes = new GLPixelStorageModes();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)4);
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.displayGLSelect(gLAutoDrawable, objectArray);
        gLPixelStorageModes.setPackAlignment(gL2ES2, 4);
        try {
            gL2ES2.glReadPixels(n, n2, 1, 1, 6408, 5121, byteBuffer);
        }
        catch (GLException gLException) {
            gLException.printStackTrace();
            return null;
        }
        gLPixelStorageModes.restore(gL2ES2);
        int n3 = this.shapes.size();
        int n4 = byteBuffer.get(0) & 0xFF;
        float f = (float)n4 / 255.0f;
        int n5 = Math.round(f * ((float)n3 + 2.0f) - 1.0f);
        System.err.printf("pickGL: glWin %d / %d, byte %d, color %f, index %d of [0..%d[%n", n, n2, n4, Float.valueOf(f), n5, n3);
        if (0 <= n5 && n5 < n3) {
            return (Shape)objectArray[n5];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Shape pickForAllRenderedDesc(Container container, PMVMatrix4f pMVMatrix4f, PickVisitor pickVisitor) {
        List<Shape> list;
        Shape shape = null;
        List<Shape> list2 = list = container.getRenderedShapes();
        synchronized (list2) {
            for (int i = list.size() - 1; null == shape && i >= 0; --i) {
                Shape shape2;
                Shape shape3 = list.get(i);
                pMVMatrix4f.pushMv();
                shape3.applyMatToMv(pMVMatrix4f);
                shape = pickVisitor.visit(shape3, pMVMatrix4f);
                if (shape3 instanceof Container && null != (shape2 = Scene.pickForAllRenderedDesc((Container)((Object)shape3), pMVMatrix4f, pickVisitor))) {
                    shape = shape2;
                }
                pMVMatrix4f.popMv();
            }
        }
        return shape;
    }

    public Shape pickShape(PMVMatrix4f pMVMatrix4f, Ray ray, int n, int n2, Vec3f vec3f, Shape.Visitor1 visitor1) {
        this.setupMatrix(pMVMatrix4f);
        Recti recti = this.getViewport();
        int[] nArray = new int[]{-1};
        return Scene.pickForAllRenderedDesc(this, pMVMatrix4f, (shape, pMVMatrix4f2) -> {
            AABBox aABBox;
            nArray[0] = nArray[0] + 1;
            if (pMVMatrix4f.mapWinToRay(n, n2, 0.0f, 0.3f, recti, ray) && (aABBox = shape.getBounds()).intersectsRay(ray)) {
                if (null == aABBox.getRayIntersection(vec3f, ray, 1.1920929E-7f, true)) {
                    throw new InternalError("Ray " + ray + ", box " + aABBox);
                }
                if (visitor1.visit(shape)) {
                    return shape;
                }
            }
            return null;
        });
    }

    private final Shape dispatchMouseEventPickShape(MouseEvent mouseEvent, int n, int n2) {
        Shape shape2 = this.pickShape(this.dispMEPSPMv, this.dispMEPSRay, n, n2, this.dispMEPSObjPos, shape -> {
            if (!shape.isInteractive()) {
                return false;
            }
            return shape.dispatchMouseEvent(mouseEvent, n, n2, this.dispMEPSObjPos);
        });
        if (null != shape2) {
            this.setActiveShape(shape2);
            return shape2;
        }
        this.releaseActiveShape();
        return null;
    }

    private final void dispatchMouseEventForShape(Shape shape, MouseEvent mouseEvent, int n, int n2) {
        PMVMatrix4f pMVMatrix4f = new PMVMatrix4f();
        Vec3f vec3f = new Vec3f();
        this.winToShapeCoord(shape, n, n2, pMVMatrix4f, vec3f, () -> shape.dispatchMouseEvent(mouseEvent, n, n2, vec3f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTooltipActive(Tooltip tooltip) {
        AtomicReference<Tooltip> atomicReference = this.tooltipActive;
        synchronized (atomicReference) {
            this.tooltipActive.set(tooltip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTooltip() {
        Tooltip tooltip;
        Object object = this.tooltipActive;
        synchronized (object) {
            tooltip = this.tooltipActive.get();
            if (null != tooltip && tooltip.stop(false)) {
                this.tooltipActive.set(null);
            }
        }
        object = this.tooltipHUD.getAndSet(null);
        if (null != object) {
            this.invoke(false, arg_0 -> this.lambda$clearTooltip$9(tooltip, (Shape)object, arg_0));
        }
    }

    private void setTooltipHUD(Shape shape) {
        this.addShape(shape);
        this.tooltipHUD.set(shape);
    }

    private void tickTooltip(GLAutoDrawable gLAutoDrawable, PMVMatrix4f pMVMatrix4f, Tooltip tooltip) {
        if (null == this.tooltipHUD.get()) {
            Shape[] shapeArray = new Shape[]{null};
            if (tooltip.tick() && TreeTool.forOne(this, pMVMatrix4f, tooltip.getTool(), () -> {
                AABBox aABBox = tooltip.getToolMvBounds(pMVMatrix4f);
                shapeArray[0] = tooltip.createTip(this, aABBox);
            })) {
                this.setTooltipHUD(shapeArray[0]);
            }
        }
    }

    public String getStatusText(GLAutoDrawable gLAutoDrawable, int n, float f) {
        float f2;
        float f3;
        float f4;
        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
        if (null != gLAnimatorControl) {
            f4 = gLAnimatorControl.getLastFPS();
            f3 = gLAnimatorControl.getTotalFPS();
            f2 = (float)gLAnimatorControl.getLastFPSPeriod() / (float)gLAnimatorControl.getUpdateFPSFrames();
        } else {
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = 0.0f;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = gLAutoDrawable.getChosenGLCapabilities();
        String string = Region.getRenderModeString(n, this.getAAQuality(), this.getSampleCount(), gLCapabilitiesImmutable.getNumSamples());
        String string2 = this.getRenderer().hintBitsSet(1) ? ", blend" : "";
        return String.format("%03.1f/%03.1f fps, %.1f ms/f, vsync %d, dpi %.1f, %s%s, a %d", Float.valueOf(f4), Float.valueOf(f3), Float.valueOf(f2), gLAutoDrawable.getGL().getSwapInterval(), Float.valueOf(f), string, string2, gLCapabilitiesImmutable.getAlphaBits());
    }

    public static String getStatusText(FPSCounter fPSCounter) {
        float f = fPSCounter.getLastFPS();
        float f2 = fPSCounter.getTotalFPS();
        float f3 = (float)fPSCounter.getLastFPSPeriod() / (float)fPSCounter.getUpdateFPSFrames();
        return String.format("%03.1f/%03.1f fps, %.1f ms/f", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3));
    }

    public File nextScreenshotFile(String string, String string2, int n, GLCapabilitiesImmutable gLCapabilitiesImmutable, String string3) {
        String string4 = null != string && string.length() > 0 ? string : "";
        String string5 = null != string2 && string2.length() > 0 ? string2 + "-" : "";
        RegionRenderer regionRenderer = this.getRenderer();
        String string6 = Region.getRenderModeString(n, this.getAAQuality(), this.getSampleCount(), gLCapabilitiesImmutable.getNumSamples());
        String string7 = null != string3 && string3.length() > 0 ? string3 + "-" : "";
        return new File(String.format((Locale)null, "%s%s%s-%ssnap%02d-%04dx%04d.png", string4, string5, string6, string7, this.screenShotCount++, regionRenderer.getWidth(), regionRenderer.getHeight()));
    }

    public int getScreenshotCount() {
        return this.screenShotCount;
    }

    public boolean isScreenshotSupported() {
        return null != this.screenshot;
    }

    public void screenshot(GL gL, File file) {
        if (null != this.screenshot && this.screenshot.readPixels(gL, false)) {
            this.screenshot.write(file);
            System.err.println("Wrote: " + file);
        }
    }

    public void screenshot(boolean bl, File file) {
        if (null != this.cDrawable) {
            this.cDrawable.invoke(bl, gLAutoDrawable -> {
                this.screenshot(gLAutoDrawable.getGL(), file);
                return true;
            });
        }
    }

    private /* synthetic */ boolean lambda$clearTooltip$9(Tooltip tooltip, Shape shape, GLAutoDrawable gLAutoDrawable) {
        if (null != tooltip) {
            if (shape == this.removeShape(shape)) {
                tooltip.destroyTip(gLAutoDrawable.getGL().getGL2ES2(), this.renderer, shape);
            }
        } else {
            this.removeShape(gLAutoDrawable.getGL().getGL2ES2(), this.renderer, shape);
        }
        return true;
    }

    public static interface PMVMatrixSetup {
        public float getSceneDist();

        public float getAngle();

        public float getZNear();

        public float getZFar();

        public void set(PMVMatrix4f var1, Recti var2);

        public void setPlaneBox(AABBox var1, PMVMatrix4f var2, Recti var3);
    }

    private final class SBCMouseListener
    implements MouseListener {
        private int lx;
        private int ly;
        private int lId;
        private boolean mouseOver;

        private SBCMouseListener() {
            this.clear();
        }

        private final void clear() {
            this.lx = -1;
            this.ly = -1;
            this.lId = -1;
            this.mouseOver = false;
        }

        private final Shape dispatchPickShape(MouseEvent mouseEvent, int n, int n2) {
            Shape shape = Scene.this.dispatchMouseEventPickShape(mouseEvent, n, n2);
            if (null == shape) {
                this.clear();
            }
            return shape;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (-1 == this.lId || mouseEvent.getPointerId(0) == this.lId) {
                this.lx = mouseEvent.getX();
                this.ly = mouseEvent.getY();
                this.lId = mouseEvent.getPointerId(0);
            }
            int n = mouseEvent.getX();
            int n2 = Scene.this.getHeight() - mouseEvent.getY() - 1;
            this.dispatchPickShape(mouseEvent, n, n2);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = Scene.this.getHeight() - mouseEvent.getY() - 1;
            if (this.mouseOver && null != Scene.this.activeShape && Scene.this.activeShape.isInteractive() && !Scene.this.pinchToZoomGesture.isWithinGesture() && mouseEvent.getPointerId(0) == this.lId) {
                Scene.this.dispatchMouseEventForShape(Scene.this.activeShape, mouseEvent, n, n2);
            } else {
                this.dispatchPickShape(mouseEvent, n, n2);
            }
            if (!this.mouseOver && 1 == mouseEvent.getPointerCount()) {
                Scene.this.releaseActiveShape();
                this.clear();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = Scene.this.getHeight() - mouseEvent.getY() - 1;
            this.dispatchPickShape(mouseEvent, n, n2);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Scene.this.clearTooltip();
            if (null != Scene.this.activeShape && Scene.this.activeShape.isInteractive() && !Scene.this.pinchToZoomGesture.isWithinGesture() && mouseEvent.getPointerId(0) == this.lId) {
                this.lx = mouseEvent.getX();
                this.ly = mouseEvent.getY();
                int n = mouseEvent.getX();
                int n2 = Scene.this.getHeight() - mouseEvent.getY() - 1;
                Scene.this.dispatchMouseEventForShape(Scene.this.activeShape, mouseEvent, n, n2);
            }
        }

        @Override
        public void mouseWheelMoved(MouseEvent mouseEvent) {
            Scene.this.clearTooltip();
            int n = this.lx;
            int n2 = Scene.this.getHeight() - this.ly - 1;
            if (this.mouseOver && null != Scene.this.activeShape && Scene.this.activeShape.isInteractive() && !Scene.this.pinchToZoomGesture.isWithinGesture() && mouseEvent.getPointerId(0) == this.lId) {
                Scene.this.dispatchMouseEventForShape(Scene.this.activeShape, mouseEvent, n, n2);
            } else {
                this.dispatchPickShape(mouseEvent, n, n2);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (-1 == this.lId || mouseEvent.getPointerId(0) == this.lId) {
                this.lx = mouseEvent.getX();
                this.ly = mouseEvent.getY();
                this.lId = mouseEvent.getPointerId(0);
            }
            Scene.this.clearTooltip();
            int n = this.lx;
            int n2 = Scene.this.getHeight() - this.ly - 1;
            Shape shape = this.dispatchPickShape(mouseEvent, n, n2);
            if (null != shape) {
                this.mouseOver = true;
                Scene.this.setTooltipActive(shape.startTooltip(true));
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Scene.this.clearTooltip();
            Scene.this.releaseActiveShape();
            this.clear();
        }
    }

    private final class SBCGestureListener
    implements GestureHandler.GestureListener {
        private SBCGestureListener() {
        }

        @Override
        public void gestureDetected(GestureHandler.GestureEvent gestureEvent) {
            Shape shape;
            InputEvent inputEvent;
            Scene.this.clearTooltip();
            if (null != Scene.this.activeShape && (inputEvent = gestureEvent.getTrigger()) instanceof MouseEvent && (shape = Scene.this.activeShape).isInteractive()) {
                MouseEvent mouseEvent = (MouseEvent)inputEvent;
                int n = mouseEvent.getX();
                int n2 = Scene.this.getHeight() - mouseEvent.getY() - 1;
                PMVMatrix4f pMVMatrix4f = new PMVMatrix4f();
                Vec3f vec3f = new Vec3f();
                Scene.this.winToShapeCoord(shape, n, n2, pMVMatrix4f, vec3f, () -> shape.dispatchGestureEvent(gestureEvent, n, n2, pMVMatrix4f, Scene.this.renderer.getViewport(), vec3f));
            }
        }
    }

    private final class SBCKeyListener
    implements KeyListener {
        private SBCKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (null != Scene.this.activeShape && Scene.this.activeShape.isInteractive()) {
                Scene.this.activeShape.dispatchKeyEvent(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (null != Scene.this.activeShape && Scene.this.activeShape.isInteractive()) {
                Scene.this.activeShape.dispatchKeyEvent(keyEvent);
            }
        }
    }

    public static class DefaultPMVMatrixSetup
    implements PMVMatrixSetup {
        private final float scene_dist;
        private final float angle;
        private final float zNear;
        private final float zFar;

        public DefaultPMVMatrixSetup(float f, float f2, float f3, float f4) {
            if (!(f2 > 0.0f) || !(f3 > f2)) {
                throw new IllegalArgumentException("zNear is " + f2 + ", but must be > 0 and < zFar, zFar " + f3);
            }
            this.scene_dist = f;
            this.zNear = f2;
            this.zFar = f3;
            this.angle = f4;
        }

        public DefaultPMVMatrixSetup(float f, float f2, float f3) {
            this(f, f2, f3, 0.7853982f);
        }

        public DefaultPMVMatrixSetup(float f) {
            this(f, 0.1f, 7000.0f, 0.7853982f);
        }

        public DefaultPMVMatrixSetup() {
            this(-0.2f, 0.1f, 7000.0f, 0.7853982f);
        }

        @Override
        public void set(PMVMatrix4f pMVMatrix4f, Recti recti) {
            float f = (float)recti.width() / (float)recti.height();
            pMVMatrix4f.loadPIdentity();
            pMVMatrix4f.perspectiveP(this.angle, f, this.zNear, this.zFar);
            pMVMatrix4f.translateP(0.0f, 0.0f, this.scene_dist);
            pMVMatrix4f.loadMvIdentity();
        }

        @Override
        public void setPlaneBox(AABBox aABBox, PMVMatrix4f pMVMatrix4f, Recti recti) {
            float f = -this.scene_dist;
            Vec3f vec3f = new Vec3f();
            Vec3f vec3f2 = new Vec3f();
            Scene.winToPlaneCoord(pMVMatrix4f, recti, this.zNear, this.zFar, recti.x(), recti.y(), f, vec3f);
            Scene.winToPlaneCoord(pMVMatrix4f, recti, this.zNear, this.zFar, recti.width(), recti.height(), f, vec3f2);
            aABBox.setSize(vec3f, vec3f2);
        }

        @Override
        public float getSceneDist() {
            return this.scene_dist;
        }

        @Override
        public float getAngle() {
            return this.angle;
        }

        @Override
        public float getZNear() {
            return this.zNear;
        }

        @Override
        public float getZFar() {
            return this.zFar;
        }
    }

    private static interface PickVisitor {
        public Shape visit(Shape var1, PMVMatrix4f var2);
    }
}

