/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;

class ElementReferenceValue
extends TypedValue {
    private static final long serialVersionUID = 1L;
    private String refname = null;

    ElementReferenceValue() {
        super(CSSValue.Type.ELEMENT_REFERENCE);
    }

    protected ElementReferenceValue(ElementReferenceValue elementReferenceValue) {
        super(elementReferenceValue);
        this.refname = elementReferenceValue.refname;
    }

    @Override
    public String getCssText() {
        return "element(#" + this.refname + ")";
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)"element(#");
        simpleWriter.write((CharSequence)this.refname);
        simpleWriter.write(')');
    }

    @Override
    public void setCssText(String string) throws DOMException {
        LexicalUnit lexicalUnit;
        this.checkModifiableProperty();
        CSSParser cSSParser = new CSSParser();
        try {
            lexicalUnit = cSSParser.parsePropertyValue(new StringReader(string));
        }
        catch (IOException iOException) {
            lexicalUnit = null;
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(5, "Bad element reference: " + string);
            dOMException.initCause(cSSException);
            throw dOMException;
        }
        if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.ELEMENT_REFERENCE || lexicalUnit.getNextLexicalUnit() != null) {
            throw new DOMException(13, "Not an element reference: " + string);
        }
        PrimitiveValue.LexicalSetter lexicalSetter = this.newLexicalSetter();
        lexicalSetter.setLexicalUnit(lexicalUnit);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        switch (cSSValueSyntax.getCategory()) {
            case image: 
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.refname == null ? 0 : this.refname.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ElementReferenceValue elementReferenceValue = (ElementReferenceValue)object;
        if (this.refname == null) {
            return elementReferenceValue.refname == null;
        }
        return this.refname.equals(elementReferenceValue.refname);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getStringValue() {
        return this.refname;
    }

    @Override
    public void setStringValue(CSSValue.Type type, String string) throws DOMException {
        if (type != this.getPrimitiveType()) {
            throw new DOMException(13, "Type not supported.");
        }
        if (string == null || (string = string.trim()).length() == 0) {
            throw new DOMException(5, "Empty or null value.");
        }
        this.refname = string;
    }

    @Override
    public ElementReferenceValue clone() {
        return new ElementReferenceValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(ElementReferenceValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            ElementReferenceValue.this.refname = lexicalUnit.getStringValue();
            if (ElementReferenceValue.this.refname == null) {
                LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
                if (lexicalUnit2 != null) {
                    this.checkProxyValue(lexicalUnit2);
                }
                throw new DOMException(12, "Invalid element reference: " + lexicalUnit.toString());
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
    }
}

