/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseBoxShorthandBuilder;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.util.BufferSimpleWriter;
import java.util.Set;

class BoxShorthandBuilder
extends BaseBoxShorthandBuilder {
    private final String topProperty;
    private final String rightProperty;
    private final String bottomProperty;
    private final String leftProperty;
    private byte keyword_state_top = 0;
    private byte keyword_state_bottom = 0;
    private byte keyword_state_left = 0;
    private byte keyword_state_right = 0;
    private boolean appended = false;

    BoxShorthandBuilder(String string, BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super(string, baseCSSStyleDeclaration);
        this.topProperty = string + "-top";
        this.rightProperty = string + "-right";
        this.bottomProperty = string + "-bottom";
        this.leftProperty = string + "-left";
    }

    @Override
    protected int getMinimumSetSize() {
        return 4;
    }

    @Override
    boolean isExcludedValue(StyleValue styleValue) {
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (cssType == CSSValue.CssType.TYPED) {
            CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)styleValue);
            short s = cSSTypedValue.getUnitType();
            return !CSSUnit.isLengthUnitType(s) && !cSSTypedValue.isNumberZero() && s != 2 && cSSTypedValue.getPrimitiveType() != CSSValue.Type.IDENT;
        }
        return cssType == CSSValue.CssType.LIST;
    }

    private int sameValueScore(Set<String> set, byte by) {
        StyleValue styleValue = this.getCSSValue(this.topProperty);
        StyleValue styleValue2 = this.getCSSValue(this.bottomProperty);
        StyleValue styleValue3 = this.getCSSValue(this.leftProperty);
        StyleValue styleValue4 = this.getCSSValue(this.rightProperty);
        int n = 0;
        if (!set.contains(this.leftProperty) || this.keyword_state_left != by) {
            styleValue3 = null;
        }
        if (!set.contains(this.rightProperty) || this.keyword_state_right != by) {
            styleValue4 = null;
        }
        if (!set.contains(this.bottomProperty) || this.keyword_state_bottom != by) {
            styleValue2 = null;
        }
        if (!set.contains(this.topProperty) || this.keyword_state_top != by) {
            styleValue = null;
        }
        if (styleValue3 == null || styleValue4 == null || this.valueEquals(styleValue3, styleValue4)) {
            n += 16;
        }
        if (styleValue == null || styleValue2 == null || this.valueEquals(styleValue, styleValue2)) {
            n += 4;
        }
        if (styleValue == null) {
            styleValue = styleValue2;
        }
        if (styleValue3 == null) {
            styleValue3 = styleValue4;
        }
        if (styleValue == null || styleValue3 == null || this.valueEquals(styleValue, styleValue3)) {
            ++n;
        }
        return n;
    }

    @Override
    int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        if (this.hasPropertiesToExclude(set)) {
            return 1;
        }
        if (this.checkValuesForType(CSSValue.Type.INTERNAL, set) != 0) {
            return 1;
        }
        this.keyword_state_top = this.keywordState(this.getCSSValue(this.topProperty));
        this.keyword_state_bottom = this.keywordState(this.getCSSValue(this.bottomProperty));
        this.keyword_state_left = this.keywordState(this.getCSSValue(this.leftProperty));
        this.keyword_state_right = this.keywordState(this.getCSSValue(this.rightProperty));
        int n = this.keyword_state_top + this.keyword_state_bottom + this.keyword_state_left + this.keyword_state_right;
        byte by = 0;
        int n2 = n % 5;
        if (n2 > 1) {
            by = 1;
        } else if (n >= 10) {
            by = 5;
        }
        if (n == 0 || n == 4 || n == 20) {
            return this.appendPropertyBoxText(stringBuilder, set, bl, by);
        }
        if (this.appendPropertyBoxText(stringBuilder, set, bl, by) != 0) {
            return 1;
        }
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(stringBuilder);
        DeclarationFormattingContext declarationFormattingContext = this.getParentStyle().getFormattingContext();
        if (set.contains(this.bottomProperty) && this.keyword_state_bottom != by) {
            this.appendIndividualProperty(bufferSimpleWriter, declarationFormattingContext, this.bottomProperty, bl);
        }
        if (set.contains(this.leftProperty) && this.keyword_state_left != by) {
            this.appendIndividualProperty(bufferSimpleWriter, declarationFormattingContext, this.leftProperty, bl);
        }
        if (set.contains(this.rightProperty) && this.keyword_state_right != by) {
            this.appendIndividualProperty(bufferSimpleWriter, declarationFormattingContext, this.rightProperty, bl);
        }
        if (set.contains(this.topProperty) && this.keyword_state_top != by) {
            this.appendIndividualProperty(bufferSimpleWriter, declarationFormattingContext, this.topProperty, bl);
        }
        return 0;
    }

    private void appendIndividualProperty(BufferSimpleWriter bufferSimpleWriter, DeclarationFormattingContext declarationFormattingContext, String string, boolean bl) {
        StringBuilder stringBuilder = bufferSimpleWriter.getBuffer();
        stringBuilder.append(string).append(':');
        BaseCSSStyleDeclaration.appendMinifiedCssText(bufferSimpleWriter, declarationFormattingContext, this.getCSSValue(string), string);
        this.appendPriority(stringBuilder, bl);
    }

    private int appendPropertyBoxText(StringBuilder stringBuilder, Set<String> set, boolean bl, byte by) {
        stringBuilder.append(this.getShorthandName()).append(':');
        this.appended = false;
        switch (this.sameValueScore(set, by)) {
            case 21: {
                String string = this.topProperty;
                if (!(set.contains(string) && this.keyword_state_top == by || set.contains(string = this.bottomProperty) && this.keyword_state_bottom == by || set.contains(string = this.rightProperty) && this.keyword_state_right == by || set.contains(string = this.leftProperty) && this.keyword_state_left == by)) {
                    stringBuilder.append('0');
                    break;
                }
                if (!this.appendValueIfSaneAndNotInitial(stringBuilder, string)) {
                    return 1;
                }
                if (this.appended) break;
                stringBuilder.append('0');
                break;
            }
            case 20: {
                String string = this.topProperty;
                if (!(set.contains(string) && this.keyword_state_top == by || set.contains(string = this.bottomProperty) && this.keyword_state_bottom == by)) {
                    stringBuilder.append('0');
                    this.appended = true;
                }
                if (!this.appended && !this.appendValueIfSaneAndNotInitial(stringBuilder, string)) {
                    return 1;
                }
                if (!this.appended) {
                    stringBuilder.append('0');
                } else {
                    this.appended = false;
                }
                stringBuilder.append(' ');
                string = this.leftProperty;
                if (!(set.contains(string) && this.keyword_state_left == by || set.contains(string = this.rightProperty) && this.keyword_state_right == by)) {
                    stringBuilder.append('0');
                    this.appended = true;
                }
                if (!this.appended && !this.appendValueIfSaneAndNotInitial(stringBuilder, string)) {
                    return 1;
                }
                if (this.appended) break;
                stringBuilder.append('0');
                break;
            }
            case 16: 
            case 17: {
                if (set.contains(this.topProperty) && this.keyword_state_top == by && !this.appendValueIfSaneAndNotInitial(stringBuilder, this.topProperty)) {
                    return 1;
                }
                if (!this.appended) {
                    stringBuilder.append('0');
                } else {
                    this.appended = false;
                }
                stringBuilder.append(' ');
                String string = this.leftProperty;
                if (!(set.contains(string) && this.keyword_state_left == by || set.contains(string = this.rightProperty) && this.keyword_state_right == by)) {
                    stringBuilder.append('0');
                    this.appended = true;
                }
                if (!this.appended && !this.appendValueIfSaneAndNotInitial(stringBuilder, string)) {
                    return 1;
                }
                if (!this.appended) {
                    stringBuilder.append('0');
                } else {
                    this.appended = false;
                }
                stringBuilder.append(' ');
                if (set.contains(this.bottomProperty) && this.keyword_state_bottom == by && !this.appendValueIfSaneAndNotInitial(stringBuilder, this.bottomProperty)) {
                    return 1;
                }
                if (this.appended) break;
                stringBuilder.append('0');
                break;
            }
            default: {
                if (set.contains(this.topProperty) && this.keyword_state_top == by && !this.appendValueIfSaneAndNotInitial(stringBuilder, this.topProperty)) {
                    return 1;
                }
                if (!this.appended) {
                    stringBuilder.append('0');
                } else {
                    this.appended = false;
                }
                stringBuilder.append(' ');
                if (set.contains(this.rightProperty) && this.keyword_state_right == by && !this.appendValueIfSaneAndNotInitial(stringBuilder, this.rightProperty)) {
                    return 1;
                }
                if (!this.appended) {
                    stringBuilder.append('0');
                } else {
                    this.appended = false;
                }
                stringBuilder.append(' ');
                if (set.contains(this.bottomProperty) && this.keyword_state_bottom == by && !this.appendValueIfSaneAndNotInitial(stringBuilder, this.bottomProperty)) {
                    return 1;
                }
                if (!this.appended) {
                    stringBuilder.append('0');
                } else {
                    this.appended = false;
                }
                stringBuilder.append(' ');
                if (set.contains(this.leftProperty) && this.keyword_state_left == by && !this.appendValueIfSaneAndNotInitial(stringBuilder, this.leftProperty)) {
                    return 1;
                }
                if (this.appended) break;
                stringBuilder.append('0');
            }
        }
        this.appendPriority(stringBuilder, bl);
        return 0;
    }

    private boolean appendValueIfSaneAndNotInitial(StringBuilder stringBuilder, String string) {
        StyleValue styleValue = this.getCSSValue(string);
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (cssType != CSSValue.CssType.LIST) {
            if (cssType == CSSValue.CssType.TYPED) {
                CSSValue.Type type = styleValue.getPrimitiveType();
                if (type != CSSValue.Type.STRING) {
                    CSSTypedValue cSSTypedValue;
                    String string2;
                    if (type == CSSValue.Type.IDENT && !(string2 = (cSSTypedValue = (CSSTypedValue)((Object)styleValue)).getStringValue()).equalsIgnoreCase("auto")) {
                        return false;
                    }
                    if (this.isNotInitialValue(styleValue, string)) {
                        if (this.appended) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(styleValue.getMinifiedCssText(string));
                        this.appended = true;
                    }
                }
            } else if (cssType == CSSValue.CssType.KEYWORD) {
                if (styleValue.getPrimitiveType() == CSSValue.Type.INHERIT || styleValue.getPrimitiveType() == CSSValue.Type.REVERT) {
                    if (this.appended) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(styleValue.getCssText());
                    this.appended = true;
                }
            } else if (cssType == CSSValue.CssType.PROXY) {
                return false;
            }
            return true;
        }
        return false;
    }
}

