/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.app;

import java.sql.ResultSet;
import java.util.Objects;
import org.jkiss.dbeaver.model.admin.sessions.AbstractServerSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class DB2ServerApplication
extends AbstractServerSession {
    private String databaseName;
    private final Long agentId;
    private String authorisationId;
    private String applicationName;
    private final String applicationId;
    private String applicationStatus;
    private String statusChangeTime;
    private String sequenceNo;
    private String clientDatabaseAlias;
    private String clientProductId;
    private Long clientPId;
    private String clientPlatform;
    private String clientProtocol;
    private String clientNName;
    private Integer coordNodeNum;
    private Long coordAgentPid;
    private Long numAssociatedAgents;
    private String tpmonClientUserid;
    private String tpmonClientWorkstationNane;
    private String tpmonClientApplicationName;
    private String tpmonAccountingString;

    public DB2ServerApplication(ResultSet dbResult) {
        this.clientDatabaseAlias = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLIENT_DB_ALIAS");
        this.databaseName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DB_NAME");
        this.agentId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"AGENT_ID");
        this.authorisationId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"AUTHID");
        this.applicationName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"APPL_NAME");
        this.applicationId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"APPL_ID");
        this.applicationStatus = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"APPL_STATUS");
        this.statusChangeTime = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS_CHANGE_TIME");
        this.sequenceNo = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SEQUENCE_NO");
        this.clientProductId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLIENT_PRDID");
        this.clientPId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CLIENT_PID");
        this.clientPlatform = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLIENT_PLATFORM");
        this.clientProtocol = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLIENT_PROTOCOL");
        this.clientNName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLIENT_NNAME");
        this.coordNodeNum = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"COORD_NODE_NUM");
        this.numAssociatedAgents = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"COORD_AGENT_PID");
        this.numAssociatedAgents = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NUM_ASSOC_AGENTS");
        this.tpmonClientUserid = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TPMON_CLIENT_USERID");
        this.tpmonClientWorkstationNane = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TPMON_CLIENT_WKSTN");
        this.tpmonClientApplicationName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TPMON_CLIENT_APP");
        this.tpmonAccountingString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TPMON_ACC_STR");
    }

    public String getActiveQuery() {
        return null;
    }

    public String getSessionId() {
        return this.agentId.toString();
    }

    public String toString() {
        return this.agentId.toString();
    }

    @Property(viewable=true, editable=false, order=1)
    public String getApplicationId() {
        return this.applicationId;
    }

    @Property(viewable=true, editable=false, order=2)
    public Long getAgentId() {
        return this.agentId;
    }

    @Property(viewable=true, editable=false, order=3)
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Property(viewable=true, editable=false, order=4)
    public String getApplicationName() {
        return this.applicationName;
    }

    @Property(viewable=true, editable=false, order=5)
    public String getApplicationStatus() {
        return this.applicationStatus;
    }

    @Property(viewable=true, editable=false, order=6)
    public String getAuthorisationId() {
        return this.authorisationId;
    }

    @Property(viewable=true, editable=false, order=7, category="Client")
    public String getClientNName() {
        return this.clientNName;
    }

    @Property(viewable=true, editable=false, order=8, category="Client")
    public String getClientDatabaseAlias() {
        return this.clientDatabaseAlias;
    }

    @Property(viewable=true, editable=false, order=9, category="Client")
    public Long getClientPId() {
        return this.clientPId;
    }

    @Property(viewable=true, editable=false, order=10, category="Client")
    public String getClientProductId() {
        return this.clientProductId;
    }

    @Property(viewable=true, editable=false, order=11, category="Client")
    public String getClientPlatform() {
        return this.clientPlatform;
    }

    @Property(viewable=false)
    public String getTpmonAccountingString() {
        return this.tpmonAccountingString;
    }

    @Property(viewable=false, category="Client")
    public String getClientProtocol() {
        return this.clientProtocol;
    }

    @Property(viewable=false)
    public String getStatusChangeTime() {
        return this.statusChangeTime;
    }

    @Property(viewable=false)
    public String getSequenceNo() {
        return this.sequenceNo;
    }

    @Property(viewable=false)
    public Integer getCoordNodeNum() {
        return this.coordNodeNum;
    }

    @Property(viewable=false)
    public Long getCoordAgentPid() {
        return this.coordAgentPid;
    }

    @Property(viewable=false)
    public Long getNumAssociatedAgents() {
        return this.numAssociatedAgents;
    }

    @Property(viewable=false, category="Client")
    public String getTpmonClientUserid() {
        return this.tpmonClientUserid;
    }

    @Property(viewable=false, category="Client")
    public String getTpmonClientWorkstationNane() {
        return this.tpmonClientWorkstationNane;
    }

    @Property(viewable=true, category="Client")
    public String getTpmonClientApplicationName() {
        return this.tpmonClientApplicationName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DB2ServerApplication that = (DB2ServerApplication)((Object)o);
        return Objects.equals(this.agentId, that.agentId) && Objects.equals(this.applicationId, that.applicationId);
    }

    public int hashCode() {
        return Objects.hash(this.agentId, this.applicationId);
    }
}

