/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModelDescriptor;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.utils.ArrayUtils;

public class GenericMetaModelRegistry {
    protected static final Log log = Log.getLog(GenericMetaModelRegistry.class);
    private final Map<String, GenericMetaModelDescriptor> metaModels = new HashMap<String, GenericMetaModelDescriptor>();
    private static final String EXTENSION_ID = "org.jkiss.dbeaver.generic.meta";
    private static volatile GenericMetaModelRegistry instance = null;

    public static synchronized GenericMetaModelRegistry getInstance() {
        if (instance == null) {
            instance = new GenericMetaModelRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private GenericMetaModelRegistry(IExtensionRegistry extensionRegistry) {
        this.metaModels.put("standard", new GenericMetaModelDescriptor());
        IConfigurationElement[] extElements = extensionRegistry.getConfigurationElementsFor(EXTENSION_ID);
        IConfigurationElement[] iConfigurationElementArray = extElements;
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            GenericMetaModelDescriptor metaModel = new GenericMetaModelDescriptor(ext);
            this.metaModels.put(metaModel.getId(), metaModel);
            for (String replaces : metaModel.getModelReplacements()) {
                this.metaModels.put(replaces, metaModel);
            }
            ++n2;
        }
        for (GenericMetaModelDescriptor metaModel : new ArrayList<GenericMetaModelDescriptor>(this.metaModels.values())) {
            for (String driverClass : ArrayUtils.safeArray((Object[])metaModel.getDriverClass())) {
                this.metaModels.put(driverClass, metaModel);
            }
        }
    }

    public GenericMetaModelDescriptor getStandardMetaModel() {
        return this.metaModels.get("standard");
    }

    public GenericMetaModel getMetaModel(DBPDataSourceContainer dataSourceContainer) throws DBException {
        GenericMetaModelDescriptor metaModel = null;
        Object metaModelId = dataSourceContainer.getDriver().getDriverParameter("meta-model");
        if (metaModelId != null && !"standard".equals(metaModelId) && (metaModel = this.metaModels.get(metaModelId.toString())) == null) {
            log.warn((Object)("Meta model '" + String.valueOf(metaModelId) + "' not recognized. Default one will be used"));
        }
        if (metaModel == null) {
            metaModel = this.metaModels.get(dataSourceContainer.getDriver().getDriverClassName());
        }
        if (metaModel == null) {
            metaModel = this.getStandardMetaModel();
        }
        return metaModel.getInstance();
    }
}

