﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/organizations/Organizations_EXPORTS.h>

namespace Aws {
namespace Organizations {
namespace Model {
enum class AccountStatus { NOT_SET, ACTIVE, SUSPENDED, PENDING_CLOSURE };

namespace AccountStatusMapper {
AWS_ORGANIZATIONS_API AccountStatus GetAccountStatusForName(const Aws::String& name);

AWS_ORGANIZATIONS_API Aws::String GetNameForAccountStatus(AccountStatus value);
}  // namespace AccountStatusMapper
}  // namespace Model
}  // namespace Organizations
}  // namespace Aws
