/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.core.context.java.JavaIdMapping;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlColumn;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlGeneratedValue;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlSequenceGenerator;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlTableGenerator;
import org.eclipse.jpt.core.resource.orm.EnumType;
import org.eclipse.jpt.core.resource.orm.TemporalType;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.resource.orm.XmlGeneratedValue;
import org.eclipse.jpt.core.resource.orm.XmlId;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.utility.TextRange;

public class VirtualXmlId
extends XmlId {
    protected OrmTypeMapping ormTypeMapping;
    protected final JavaIdMapping javaAttributeMapping;
    protected final VirtualXmlAttributeMapping virtualXmlAttributeMapping;
    protected final VirtualXmlColumn column;
    protected final VirtualXmlGeneratedValue virtualGeneratedValue;
    protected final VirtualXmlTableGenerator virtualTableGenerator;
    protected final VirtualXmlSequenceGenerator virtualSequenceGenerator;

    public VirtualXmlId(OrmTypeMapping ormTypeMapping, JavaIdMapping javaIdMapping) {
        this.ormTypeMapping = ormTypeMapping;
        this.javaAttributeMapping = javaIdMapping;
        this.virtualXmlAttributeMapping = new VirtualXmlAttributeMapping(ormTypeMapping, javaIdMapping);
        this.column = new VirtualXmlColumn(ormTypeMapping, javaIdMapping.getColumn());
        this.virtualGeneratedValue = new VirtualXmlGeneratedValue(javaIdMapping, this.isOrmMetadataComplete());
        this.virtualTableGenerator = new VirtualXmlTableGenerator(javaIdMapping.getGeneratorContainer(), this.isOrmMetadataComplete());
        this.virtualSequenceGenerator = new VirtualXmlSequenceGenerator(javaIdMapping.getGeneratorContainer(), this.isOrmMetadataComplete());
    }

    protected boolean isOrmMetadataComplete() {
        return this.ormTypeMapping.isMetadataComplete();
    }

    public String getMappingKey() {
        return this.virtualXmlAttributeMapping.getMappingKey();
    }

    public String getName() {
        return this.virtualXmlAttributeMapping.getName();
    }

    public void setName(String newName) {
        this.virtualXmlAttributeMapping.setName(newName);
    }

    public TextRange getNameTextRange() {
        return this.virtualXmlAttributeMapping.getNameTextRange();
    }

    public XmlColumn getColumn() {
        return this.column;
    }

    public void setColumn(XmlColumn value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public TemporalType getTemporal() {
        if (this.isOrmMetadataComplete()) {
            return null;
        }
        if (this.javaAttributeMapping.getConverter().getType() == "temporalConverter") {
            org.eclipse.jpt.core.context.TemporalType javaTemporalType = ((TemporalConverter)((Object)this.javaAttributeMapping.getConverter())).getTemporalType();
            return org.eclipse.jpt.core.context.TemporalType.toOrmResourceModel(javaTemporalType);
        }
        return null;
    }

    public void setTemporal(TemporalType newTemporal) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public XmlGeneratedValue getGeneratedValue() {
        if (this.isOrmMetadataComplete()) {
            return null;
        }
        if (this.javaAttributeMapping.getGeneratedValue() != null) {
            return this.virtualGeneratedValue;
        }
        return null;
    }

    public void setGeneratedValue(XmlGeneratedValue value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public XmlSequenceGenerator getSequenceGenerator() {
        if (this.isOrmMetadataComplete()) {
            return null;
        }
        if (this.javaAttributeMapping.getGeneratorContainer().getSequenceGenerator() != null) {
            return this.virtualSequenceGenerator;
        }
        return null;
    }

    public void setSequenceGenerator(XmlSequenceGenerator value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public XmlTableGenerator getTableGenerator() {
        if (this.isOrmMetadataComplete()) {
            return null;
        }
        if (this.javaAttributeMapping.getGeneratorContainer().getTableGenerator() != null) {
            return this.virtualTableGenerator;
        }
        return null;
    }

    public void setTableGenerator(XmlTableGenerator value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public EnumType getEnumerated() {
        throw new UnsupportedOperationException("enumerated not supported on id mappings");
    }

    public void setEnumerated(EnumType value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public boolean isLob() {
        throw new UnsupportedOperationException("lob not supported on id mappings");
    }

    public void setLob(boolean value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public TextRange getEnumeratedTextRange() {
        return null;
    }

    public TextRange getLobTextRange() {
        return null;
    }

    public TextRange getTemporalTextRange() {
        return null;
    }
}

