/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsfappconfig;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.core.jsfappconfig.WebContentRelativeJSFAppConfigLocater;

public class ContextParamSpecifiedJSFAppConfigLocater
extends WebContentRelativeJSFAppConfigLocater {
    protected ContextParamAdapter contextParamAdapter = null;

    public void startLocating() {
        this.locateProviders();
        Object webAppObj = this.getModelObject();
        if (webAppObj != null) {
            this.contextParamAdapter = new ContextParamAdapter();
            if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                this.startLocatingJ2EEConfigs((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj);
            } else if (webAppObj instanceof WebApp) {
                this.startLocatingJEEConfigs((WebApp)webAppObj);
            }
        }
    }

    private Object getModelObject() {
        IModelProvider provider;
        Object modelObject = null;
        IProject project = this.getJSFAppConfigManager().getProject();
        if (project.isAccessible() && (provider = ModelProviderManager.getModelProvider((IProject)project)) != null && !project.getWorkspace().isTreeLocked()) {
            modelObject = provider.getModelObject();
        }
        return modelObject;
    }

    public void stopLocating() {
        if (this.contextParamAdapter != null) {
            Object webAppObj = this.getModelObject();
            if (webAppObj != null) {
                if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                    this.stopLocatingJ2EEConfigs((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj);
                } else if (webAppObj instanceof WebApp) {
                    this.stopLocatingJEEConfigs((WebApp)webAppObj);
                }
            }
            this.contextParamAdapter = null;
        }
    }

    private void startLocatingJ2EEConfigs(org.eclipse.jst.j2ee.webapplication.WebApp webApp) {
        EList contextParams;
        webApp.eAdapters().add((Object)this.contextParamAdapter);
        EList contexts = webApp.getContexts();
        if (contexts != null) {
            for (ContextParam contextParam : contexts) {
                contextParam.eAdapters().add((Object)this.contextParamAdapter);
            }
        }
        if ((contextParams = webApp.getContextParams()) != null) {
            for (org.eclipse.jst.j2ee.common.ParamValue paramValue : contextParams) {
                paramValue.eAdapters().add((Object)this.contextParamAdapter);
            }
        }
    }

    private void startLocatingJEEConfigs(WebApp webApp) {
        ((EObject)webApp).eAdapters().add((Object)this.contextParamAdapter);
        List params = webApp.getContextParams();
        if (params != null) {
            for (EObject contextParam : params) {
                contextParam.eAdapters().add((Object)this.contextParamAdapter);
            }
        }
    }

    private void stopLocatingJ2EEConfigs(org.eclipse.jst.j2ee.webapplication.WebApp webApp) {
        EList contextParams;
        webApp.eAdapters().remove((Object)this.contextParamAdapter);
        EList contexts = webApp.getContexts();
        if (contexts != null) {
            for (ContextParam contextParam : contexts) {
                contextParam.eAdapters().remove((Object)this.contextParamAdapter);
            }
        }
        if ((contextParams = webApp.getContextParams()) != null) {
            for (org.eclipse.jst.j2ee.common.ParamValue paramValue : contextParams) {
                paramValue.eAdapters().remove((Object)this.contextParamAdapter);
            }
        }
    }

    private void stopLocatingJEEConfigs(WebApp webApp) {
        ((EObject)webApp).eAdapters().remove((Object)this.contextParamAdapter);
        List contextParams = webApp.getContextParams();
        if (contextParams != null) {
            for (EObject paramValue : contextParams) {
                paramValue.eAdapters().remove((Object)this.contextParamAdapter);
            }
        }
    }

    protected List getFilenames() {
        return JSFAppConfigUtils.getConfigFilesFromContextParam(this.getJSFAppConfigManager().getProject());
    }

    class ContextParamAdapter
    extends AdapterImpl {
        ContextParamAdapter() {
        }

        public void notifyChanged(Notification notification) {
            block15: {
                Object objNotifier;
                block14: {
                    objNotifier = notification.getNotifier();
                    if (!(objNotifier instanceof org.eclipse.jst.j2ee.webapplication.WebApp) && !(objNotifier instanceof WebApp)) break block14;
                    int eventType = notification.getEventType();
                    switch (eventType) {
                        case 3: {
                            Object objNewValue = notification.getNewValue();
                            if (objNewValue instanceof ContextParam || objNewValue instanceof ParamValue) {
                                this.contextParamAdded((EObject)objNewValue);
                                break;
                            }
                            if (objNewValue instanceof org.eclipse.jst.j2ee.common.ParamValue) {
                                this.paramValueAdded((EObject)objNewValue);
                                break;
                            }
                            break block15;
                        }
                        case 4: {
                            Object objOldValue = notification.getOldValue();
                            if (objOldValue instanceof ContextParam || objOldValue instanceof ParamValue) {
                                this.contextParamRemoved((EObject)objOldValue);
                                break;
                            }
                            if (!(objOldValue instanceof org.eclipse.jst.j2ee.common.ParamValue)) break block15;
                            this.paramValueRemoved((EObject)objOldValue);
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block15;
                }
                if (objNotifier instanceof ContextParam || objNotifier instanceof ParamValue) {
                    if (notification.getEventType() != 8) {
                        ContextParamSpecifiedJSFAppConfigLocater.this.locateProviders();
                    }
                } else if (objNotifier instanceof org.eclipse.jst.j2ee.common.ParamValue && notification.getEventType() != 8) {
                    ContextParamSpecifiedJSFAppConfigLocater.this.locateProviders();
                }
            }
        }

        protected void contextParamAdded(EObject contextParam) {
            if (this.isConfigFilesContextParam(contextParam)) {
                ContextParamSpecifiedJSFAppConfigLocater.this.locateProviders();
            }
            contextParam.eAdapters().add((Object)this);
        }

        protected void paramValueAdded(EObject paramValue) {
            if (this.isConfigFilesParamValue(paramValue)) {
                ContextParamSpecifiedJSFAppConfigLocater.this.locateProviders();
            }
            paramValue.eAdapters().add((Object)this);
        }

        protected void contextParamRemoved(EObject contextParam) {
            if (this.isConfigFilesContextParam(contextParam)) {
                ContextParamSpecifiedJSFAppConfigLocater.this.locateProviders();
            }
            contextParam.eAdapters().remove((Object)this);
        }

        protected void paramValueRemoved(EObject paramValue) {
            if (this.isConfigFilesParamValue(paramValue)) {
                ContextParamSpecifiedJSFAppConfigLocater.this.locateProviders();
            }
            paramValue.eAdapters().remove((Object)this);
        }

        protected boolean isConfigFilesContextParam(EObject contextParam) {
            boolean isConfigFiles = false;
            if (contextParam != null) {
                String name = null;
                if (contextParam instanceof ContextParam) {
                    name = ((ContextParam)contextParam).getParamName();
                } else if (contextParam instanceof ParamValue) {
                    name = ((ParamValue)contextParam).getParamName();
                }
                if (name != null && name.equals("javax.faces.CONFIG_FILES")) {
                    isConfigFiles = true;
                }
            }
            return isConfigFiles;
        }

        protected boolean isConfigFilesParamValue(EObject paramVal) {
            boolean isConfigFiles = false;
            if (paramVal != null) {
                String name = null;
                if (paramVal instanceof org.eclipse.jst.j2ee.common.ParamValue) {
                    name = ((org.eclipse.jst.j2ee.common.ParamValue)paramVal).getName();
                } else if (paramVal instanceof ParamValue) {
                    name = ((ParamValue)paramVal).getParamName();
                }
                if (name != null && name.equals("javax.faces.CONFIG_FILES")) {
                    isConfigFiles = true;
                }
            }
            return isConfigFiles;
        }
    }
}

