/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;

public class IndexSelector {
    IJavaScriptSearchScope searchScope;
    SearchPattern pattern;
    IPath[] indexLocations;

    public IndexSelector(IJavaScriptSearchScope searchScope, SearchPattern pattern) {
        this.searchScope = searchScope;
        this.pattern = pattern;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IJavaScriptElement focus, boolean isPolymorphicSearch, IPath projectOrJarPath) {
        try {
            IJavaScriptModel model;
            IJavaScriptProject project;
            IIncludePathEntry[] focusEntries = null;
            if (isPolymorphicSearch) {
                JavaProject focusProject = (JavaProject)focus;
                focusEntries = focusProject.getExpandedClasspath();
            }
            if ((project = IndexSelector.getJavaProject(projectOrJarPath, model = focus.getJavaScriptModel())) != null) {
                return IndexSelector.canSeeFocus(focus, (JavaProject)project, focusEntries);
            }
            IJavaScriptProject[] allProjects = model.getJavaScriptProjects();
            int i = 0;
            int length = allProjects.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                JavaProject otherProject = (JavaProject)allProjects[i];
                IIncludePathEntry entry = otherProject.getClasspathEntryFor(projectOrJarPath);
                if (entry != null && entry.getEntryKind() == 1 && IndexSelector.canSeeFocus(focus, otherProject, focusEntries)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IJavaScriptElement focus, JavaProject javaProject, IIncludePathEntry[] focusEntriesForPolymorphicSearch) {
        try {
            IIncludePathEntry entry;
            int i;
            IPath focusPath;
            if (focus.equals(javaProject)) {
                return true;
            }
            if (focusEntriesForPolymorphicSearch != null) {
                IPath projectPath = javaProject.getProject().getFullPath();
                int i2 = 0;
                int length = focusEntriesForPolymorphicSearch.length;
                while (i2 < length) {
                    IIncludePathEntry entry2 = focusEntriesForPolymorphicSearch[i2];
                    if (entry2.getEntryKind() == 2 && entry2.getPath().equals((Object)projectPath)) {
                        return true;
                    }
                    ++i2;
                }
            }
            if (focus instanceof LibraryFragmentRoot || focus instanceof PackageFragmentRoot) {
                focusPath = focus.getPath();
                IIncludePathEntry[] entries = javaProject.getExpandedClasspath();
                i = 0;
                int length = entries.length;
                while (true) {
                    if (i >= length) {
                        if (!(focus instanceof LibraryFragmentRoot)) break;
                        return false;
                    }
                    entry = entries[i];
                    if ((entry.getEntryKind() == 1 || entry.getEntryKind() == 3) && entry.getPath().equals((Object)focusPath)) {
                        return true;
                    }
                    ++i;
                }
            }
            focusPath = null;
            focusPath = focus instanceof PackageFragmentRoot ? ((JavaProject)focus.getParent()).getProject().getFullPath() : ((JavaProject)focus).getProject().getFullPath();
            IIncludePathEntry[] entries = javaProject.getExpandedClasspath();
            i = 0;
            int length = entries.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                entry = entries[i];
                if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)focusPath)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
    }

    private void initializeIndexLocations() {
        IPath[] projectsAndJars = this.searchScope.enclosingProjectsAndJars();
        IndexManager manager = JavaModelManager.getJavaModelManager().getIndexManager();
        SimpleSet locations = new SimpleSet();
        IJavaScriptElement focus = MatchLocator.projectOrJarFocus(this.pattern);
        if (focus == null) {
            int i = 0;
            while (i < projectsAndJars.length) {
                locations.add(manager.computeIndexLocation(projectsAndJars[i]));
                ++i;
            }
        } else {
            try {
                int length = projectsAndJars.length;
                JavaProject[] projectsCanSeeFocus = new JavaProject[length];
                SimpleSet visitedProjects = new SimpleSet(length);
                int projectIndex = 0;
                SimpleSet jarsToCheck = new SimpleSet(length);
                IIncludePathEntry[] focusEntries = null;
                if (this.pattern instanceof MethodPattern) {
                    JavaProject focusProject = focus instanceof LibraryFragmentRoot || focus instanceof PackageFragmentRoot ? (JavaProject)focus.getParent() : (JavaProject)focus;
                    focusEntries = focusProject.getExpandedClasspath();
                }
                JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
                int i = 0;
                while (i < length) {
                    IPath path = projectsAndJars[i];
                    JavaProject project = (JavaProject)IndexSelector.getJavaProject(path, model);
                    if (project != null) {
                        visitedProjects.add(project);
                        if (IndexSelector.canSeeFocus(focus, project, focusEntries)) {
                            locations.add(manager.computeIndexLocation(path));
                            projectsCanSeeFocus[projectIndex++] = project;
                        }
                    } else {
                        jarsToCheck.add(path);
                    }
                    ++i;
                }
                i = 0;
                while (i < projectIndex && jarsToCheck.elementSize > 0) {
                    IIncludePathEntry[] entries = projectsCanSeeFocus[i].getResolvedClasspath();
                    int j = entries.length;
                    while (--j >= 0) {
                        IPath path;
                        IIncludePathEntry entry = entries[j];
                        if (entry.getEntryKind() != 1 || !jarsToCheck.includes(path = entry.getPath())) continue;
                        locations.add(manager.computeIndexLocation(entry.getPath()));
                        jarsToCheck.remove(path);
                    }
                    ++i;
                }
                if (jarsToCheck.elementSize > 0) {
                    IJavaScriptProject[] allProjects = model.getJavaScriptProjects();
                    int i2 = 0;
                    int l = allProjects.length;
                    while (i2 < l && jarsToCheck.elementSize > 0) {
                        JavaProject project = (JavaProject)allProjects[i2];
                        if (!visitedProjects.includes(project)) {
                            IIncludePathEntry[] entries = project.getResolvedClasspath();
                            int j = entries.length;
                            while (--j >= 0) {
                                IPath path;
                                IIncludePathEntry entry = entries[j];
                                if (entry.getEntryKind() != 1 || !jarsToCheck.includes(path = entry.getPath())) continue;
                                locations.add(manager.computeIndexLocation(entry.getPath()));
                                jarsToCheck.remove(path);
                            }
                        }
                        ++i2;
                    }
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        this.indexLocations = new IPath[locations.elementSize];
        Object[] values = locations.values;
        int count = 0;
        int i = values.length;
        while (--i >= 0) {
            if (values[i] == null) continue;
            this.indexLocations[count++] = (IPath)values[i];
        }
    }

    public IPath[] getIndexLocations() {
        if (this.indexLocations == null) {
            this.initializeIndexLocations();
        }
        return this.indexLocations;
    }

    private static IJavaScriptProject getJavaProject(IPath path, IJavaScriptModel model) {
        IJavaScriptProject project = model.getJavaScriptProject(path.lastSegment());
        if (project.exists()) {
            return project;
        }
        return null;
    }
}

