/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestOperation;
import org.eclipse.jst.j2ee.internal.common.ClasspathModel;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.operations.UpdateJavaBuildPathOperation;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JARDependencyOperation
extends AbstractDataModelOperation
implements JARDependencyDataModelProperties {
    public JARDependencyOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    private void saveModel(ClasspathModel model, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
        if (!model.isDirty()) {
            return;
        }
        this.validateEdit(model);
        monitor.beginTask("", 2);
        UpdateManifestOperation mfOperation = this.createManifestOperation(model);
        this.createBuildPathOperation(model);
        try {
            mfOperation.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1), null);
        }
        catch (Exception e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    protected void validateEdit(ClasspathModel aModel) throws CoreException {
        Set affectedFiles = aModel.getAffectedFiles();
        IFile[] files = affectedFiles.toArray(new IFile[affectedFiles.size()]);
        IStatus result = J2EEPlugin.getWorkspace().validateEdit(files, null);
        if (!result.isOK()) {
            throw new CoreException(result);
        }
    }

    protected UpdateJavaBuildPathOperation createBuildPathOperation(ClasspathModel aModel) {
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)aModel.getProject());
        return new UpdateJavaBuildPathOperation(javaProject, aModel.getClassPathSelection());
    }

    private UpdateManifestOperation createManifestOperation(ClasspathModel aModel) {
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel(UpdateManifestDataModelProvider.class);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)aModel.getProject().getName());
        updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", (Object)UpdateManifestDataModelProvider.convertClasspathStringToList(aModel.getClassPathSelection().toString()));
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)J2EEProjectUtilities.getManifestFile(aModel.getProject()));
        return new UpdateManifestOperation(updateManifestDataModel);
    }

    public final IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) throws ExecutionException {
        IProject proj = ProjectUtilities.getProject((String)this.model.getStringProperty("UpdateManifestDataModel.PROJECT_NAME"));
        IProject earProject = ProjectUtilities.getProject((String)this.model.getStringProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME"));
        ClasspathModel clpModel = new ClasspathModel(J2EEProjectUtilities.readManifest(proj));
        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
        if (!earComponent.exists()) {
            return OK_STATUS;
        }
        clpModel.setSelectedEARComponent(earComponent);
        clpModel.setProject(proj);
        try {
            int jarManipulationType = this.model.getIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE");
            switch (jarManipulationType) {
                case 0: {
                    List jarList = (List)this.model.getNestedModel("AbstractJARDependencyDataModel.NESTED_MODEL_UPDATE_MAINFEST").getProperty("UpdateManifestDataModel.CLASSPATH_LIST");
                    if (!jarList.isEmpty()) {
                        int i = 0;
                        while (i < jarList.size()) {
                            String jarName = (String)jarList.get(i);
                            clpModel.selectDependencyIfNecessary(jarName);
                            ++i;
                        }
                        break;
                    }
                    IProject refproj = ProjectUtilities.getProject((String)this.model.getStringProperty("AbstractJARDependencyDataModel.REFERENCED_PROJECT_NAME"));
                    clpModel.selectDependencyIfNecessary(refproj);
                    break;
                }
                case 1: {
                    List jarList = (List)this.model.getNestedModel("AbstractJARDependencyDataModel.NESTED_MODEL_UPDATE_MAINFEST").getProperty("UpdateManifestDataModel.CLASSPATH_LIST");
                    int i = 0;
                    while (i < jarList.size()) {
                        String jarName = (String)jarList.get(i);
                        clpModel.removeDependency(jarName);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    IProject refproj = ProjectUtilities.getProject((String)this.model.getStringProperty("AbstractJARDependencyDataModel.REFERENCED_PROJECT_NAME"));
                    IProject oppositeProject = ProjectUtilities.getProject((String)this.model.getStringProperty("AbstractJARDependencyDataModel.OPPOSITE_PROJECT_NAME"));
                    clpModel.getClassPathSelection().invertClientJARSelection(refproj, oppositeProject);
                }
            }
            if (clpModel.isDirty()) {
                try {
                    this.saveModel(clpModel, monitor);
                }
                catch (InvocationTargetException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                catch (InterruptedException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                catch (CoreException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
        }
        finally {
            if (clpModel != null) {
                clpModel.dispose();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        return OK_STATUS;
    }
}

