/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.indexer;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

public class FileEncodingRegistry
implements Serializable {
    private Map<String, String> fFilePathToEncodingMap = null;
    private String defaultEncoding;

    public FileEncodingRegistry(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        this.fFilePathToEncodingMap = new TreeMap<String, String>();
    }

    public void setDefaultEncoding(String newDefaultEncoding) {
        this.defaultEncoding = newDefaultEncoding;
    }

    public void registerFileEncoding(String filename, String encoding) {
        if (this.defaultEncoding.equals(encoding)) {
            return;
        }
        if (this.fFilePathToEncodingMap != null) {
            this.fFilePathToEncodingMap.put(filename, encoding);
        }
    }

    public void unregisterFile(String filename) {
        if (this.fFilePathToEncodingMap != null) {
            this.fFilePathToEncodingMap.remove(filename);
        }
    }

    public String getFileEncoding(String filename) {
        String fileEncoding = null;
        if (this.fFilePathToEncodingMap != null) {
            fileEncoding = this.fFilePathToEncodingMap.get(filename);
        }
        if (fileEncoding != null) {
            return fileEncoding;
        }
        return this.defaultEncoding;
    }

    public void clear() {
        if (this.fFilePathToEncodingMap != null) {
            this.fFilePathToEncodingMap.clear();
        }
        this.fFilePathToEncodingMap = null;
        this.defaultEncoding = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.fFilePathToEncodingMap != null && this.fFilePathToEncodingMap.isEmpty()) {
            this.fFilePathToEncodingMap = null;
        }
        out.defaultWriteObject();
    }
}

