/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.fix.ICleanUpCore;
import org.eclipse.jdt.internal.corext.fix.ILinkedFixCore;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.IInvocationContextCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;
import org.eclipse.ltk.core.refactoring.TextChange;

public class FixCorrectionProposalCore
extends LinkedCorrectionProposalCore {
    private final IProposableFix fFix;
    private final ICleanUpCore fCleanUp;
    private CompilationUnit fCompilationUnit;

    public FixCorrectionProposalCore(IProposableFix fix, ICleanUpCore cleanUp, int relevance, IInvocationContextCore context) {
        super(fix.getDisplayString(), context.getCompilationUnit(), (ASTRewrite)null, relevance);
        this.fFix = fix;
        this.fCleanUp = cleanUp;
        this.fCompilationUnit = context.getASTRoot();
    }

    public ICleanUpCore getCleanUp() {
        return this.fCleanUp;
    }

    public CompilationUnit getAstCompilationUnit() {
        return this.fCompilationUnit;
    }

    public IStatus getFixStatus() {
        return this.fFix.getStatus();
    }

    @Override
    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        String info;
        StringBuilder result = new StringBuilder();
        IStatus status = this.getFixStatus();
        if (status != null && !status.isOK()) {
            result.append("<b>");
            if (status.getSeverity() == 2) {
                result.append(CorrectionMessages.FixCorrectionProposal_WarningAdditionalProposalInfo);
            } else if (status.getSeverity() == 4) {
                result.append(CorrectionMessages.FixCorrectionProposal_ErrorAdditionalProposalInfo);
            }
            result.append("</b>");
            result.append(status.getMessage());
            result.append("<br><br>");
        }
        if ((info = this.fFix.getAdditionalProposalInfo()) != null) {
            result.append(info);
        } else {
            result.append(super.getAdditionalProposalInfo(monitor));
        }
        return result.toString();
    }

    @Override
    public int getRelevance() {
        IStatus status = this.getFixStatus();
        if (status != null && !status.isOK()) {
            return super.getRelevance() - 100;
        }
        return super.getRelevance();
    }

    @Override
    public TextChange createTextChange() throws CoreException {
        CompilationUnitChange createChange = this.fFix.createChange(null);
        createChange.setSaveMode(4);
        if (this.fFix instanceof ILinkedFixCore) {
            this.setLinkedProposalModel(((ILinkedFixCore)((Object)this.fFix)).getLinkedPositionsCore());
        }
        return createChange;
    }
}

