/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.refactoring.util.AbstractChecker;

public class UnsafeCheckTester
extends AbstractChecker {
    private ASTNode fExpression;
    private int fStartOffset;
    private int fEndOffset;
    private ASTNode fCommonNode;
    private CompilationUnit fCompilationUnitNode;
    private ICompilationUnit fCu;
    private Set<AbstractChecker.Position> fMatchNodePosSet;
    private Set<IBinding> fInvocationSet;
    private HashMap<IBinding, ITypeBinding> fInvocationHashMap;
    private HashMap<AbstractChecker.Position, ITypeBinding> fMatchNodePosHashMap;

    public UnsafeCheckTester(CompilationUnit fCompilationUnitNode, ICompilationUnit fCu, ASTNode commonNode, ASTNode expression, int startOffset, int endOffset) {
        this.fCompilationUnitNode = fCompilationUnitNode;
        this.fCu = fCu;
        this.fCommonNode = commonNode;
        this.fExpression = expression;
        this.fStartOffset = startOffset;
        this.fEndOffset = endOffset;
        this.fMatchNodePosSet = new HashSet<AbstractChecker.Position>();
        this.fInvocationSet = new HashSet<IBinding>();
        this.fInvocationHashMap = new HashMap();
        this.fMatchNodePosHashMap = new HashMap();
        InvocationVisitor iv = new InvocationVisitor();
        this.fExpression.accept((ASTVisitor)iv);
    }

    public boolean hasUnsafeCheck() {
        MiddleCodeVisitor middleCodeVisitor = new MiddleCodeVisitor(this.fStartOffset, this.fEndOffset);
        this.fCommonNode.accept((ASTVisitor)middleCodeVisitor);
        return middleCodeVisitor.hasNullCheck() || middleCodeVisitor.hasCastCheck();
    }

    private IASTFragment getIASTFragment(ASTNode astNode) throws JavaModelException {
        int length = astNode.getLength();
        int startPosition = astNode.getStartPosition();
        return ASTFragmentFactory.createFragmentForSourceRange((ISourceRange)new SourceRange(startPosition, length), (ASTNode)this.fCompilationUnitNode, this.fCu);
    }

    private ASTNode getEnclosingBodyNode(ASTNode node) {
        StructuralPropertyDescriptor location = null;
        while (node != null && !(node instanceof BodyDeclaration)) {
            location = node.getLocationInParent();
            if ((node = node.getParent()) instanceof LambdaExpression) break;
        }
        if (node != null && (location == MethodDeclaration.BODY_PROPERTY || location == Initializer.BODY_PROPERTY || location == LambdaExpression.BODY_PROPERTY && ((LambdaExpression)node).resolveMethodBinding() != null)) {
            return (ASTNode)node.getStructuralProperty(location);
        }
        return null;
    }

    private Expression getOriginalExpression(Expression expr) {
        while (expr instanceof ParenthesizedExpression || expr instanceof CastExpression) {
            if (expr instanceof ParenthesizedExpression) {
                ParenthesizedExpression pe = (ParenthesizedExpression)expr;
                expr = pe.getExpression();
                continue;
            }
            CastExpression ce = (CastExpression)expr;
            expr = ce.getExpression();
        }
        return expr;
    }

    private class InvocationVisitor
    extends ASTVisitor {
        private InvocationVisitor() {
        }

        public void preVisit(ASTNode node) {
            Expression temp = null;
            if (node instanceof CastExpression) {
                CastExpression castExpression = (CastExpression)node;
                ITypeBinding resolveBinding = castExpression.getType().resolveBinding();
                Expression expression = UnsafeCheckTester.this.getOriginalExpression(castExpression.getExpression());
                IBinding targetBinding = null;
                if (expression instanceof Name && (targetBinding = ((Name)expression).resolveBinding()) != null) {
                    UnsafeCheckTester.this.fInvocationHashMap.put(targetBinding, resolveBinding);
                } else {
                    UnsafeCheckTester.this.fMatchNodePosHashMap.put(new AbstractChecker.Position(UnsafeCheckTester.this, expression.getStartPosition(), expression.getLength()), resolveBinding);
                }
            } else if (node instanceof MethodInvocation) {
                MethodInvocation mi = (MethodInvocation)node;
                temp = mi.getExpression();
            } else if (node instanceof FieldAccess) {
                FieldAccess fa = (FieldAccess)node;
                temp = fa.getExpression();
            } else if (node instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)node;
                temp = qn.getQualifier();
            } else if (node instanceof ArrayAccess) {
                ArrayAccess aa = (ArrayAccess)node;
                temp = aa.getArray();
            }
            if (temp != null) {
                try {
                    IASTFragment[] allMatches;
                    temp = UnsafeCheckTester.this.getOriginalExpression(temp);
                    IASTFragment[] iASTFragmentArray = allMatches = ASTFragmentFactory.createFragmentForFullSubtree(UnsafeCheckTester.this.getEnclosingBodyNode((ASTNode)temp)).getSubFragmentsMatching(UnsafeCheckTester.this.getIASTFragment((ASTNode)temp));
                    int n = allMatches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IASTFragment match = iASTFragmentArray[n2];
                        ASTNode associatedNode = match.getAssociatedNode();
                        if (associatedNode != null) {
                            UnsafeCheckTester.this.fMatchNodePosSet.add(new AbstractChecker.Position(UnsafeCheckTester.this, associatedNode.getStartPosition(), associatedNode.getLength()));
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                IBinding resolveBinding = null;
                if (temp instanceof Name) {
                    resolveBinding = ((Name)temp).resolveBinding();
                }
                if (resolveBinding != null) {
                    UnsafeCheckTester.this.fInvocationSet.add(resolveBinding);
                }
            }
        }
    }

    private class MiddleCodeVisitor
    extends ASTVisitor {
        int startPosition;
        int endPosition;
        boolean nullFlag;
        boolean castFlag;

        public MiddleCodeVisitor(int startPosition, int endPosition) {
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.nullFlag = false;
            this.castFlag = false;
        }

        public boolean hasNullCheck() {
            return this.nullFlag;
        }

        public boolean hasCastCheck() {
            return this.castFlag;
        }

        public boolean preVisit2(ASTNode node) {
            InfixExpression infixExpression;
            InfixExpression.Operator op;
            int sl = node.getStartPosition();
            int el = node.getStartPosition() + node.getLength();
            if (el < this.startPosition || sl > this.endPosition || this.nullFlag || this.castFlag) {
                return false;
            }
            if (sl < this.startPosition || el > this.endPosition) {
                return super.preVisit2(node);
            }
            if (node instanceof InstanceofExpression) {
                InstanceofExpression instanceofExpression = (InstanceofExpression)node;
                Expression leftOperand = UnsafeCheckTester.this.getOriginalExpression(instanceofExpression.getLeftOperand());
                Type rightOperand = instanceofExpression.getRightOperand();
                ITypeBinding resolveBinding = rightOperand.resolveBinding();
                IBinding targetBinding = null;
                if (leftOperand instanceof Name && (targetBinding = ((Name)leftOperand).resolveBinding()) != null && this.hasInheritanceRelationship(UnsafeCheckTester.this.fInvocationHashMap.get(targetBinding), resolveBinding)) {
                    this.castFlag = true;
                    return false;
                }
                if (this.hasInheritanceRelationship(UnsafeCheckTester.this.fMatchNodePosHashMap.get(new AbstractChecker.Position(UnsafeCheckTester.this, leftOperand.getStartPosition(), leftOperand.getLength())), resolveBinding)) {
                    this.castFlag = true;
                    return false;
                }
                return super.preVisit2(node);
            }
            Expression target = null;
            if (node instanceof InfixExpression && (InfixExpression.Operator.toOperator((String)(op = (infixExpression = (InfixExpression)node).getOperator()).toString()) == InfixExpression.Operator.EQUALS || InfixExpression.Operator.toOperator((String)op.toString()) == InfixExpression.Operator.NOT_EQUALS)) {
                Expression leftExpression = infixExpression.getLeftOperand();
                Expression rightExpression = infixExpression.getRightOperand();
                if (rightExpression.getNodeType() == 33) {
                    target = leftExpression;
                } else if (leftExpression.getNodeType() == 33) {
                    target = rightExpression;
                }
            }
            if (target != null) {
                target = UnsafeCheckTester.this.getOriginalExpression(target);
                IBinding targetBinding = null;
                if (target instanceof Name && (targetBinding = ((Name)target).resolveBinding()) != null && UnsafeCheckTester.this.fInvocationSet.contains(targetBinding)) {
                    this.nullFlag = true;
                    return false;
                }
                if (UnsafeCheckTester.this.fMatchNodePosSet.contains(new AbstractChecker.Position(UnsafeCheckTester.this, target.getStartPosition(), target.getLength()))) {
                    this.nullFlag = true;
                    return false;
                }
            }
            return super.preVisit2(node);
        }

        private boolean hasInheritanceRelationship(ITypeBinding itb1, ITypeBinding itb2) {
            if (itb2 == null || itb1 == null) {
                return false;
            }
            if (itb1 == itb2) {
                return true;
            }
            ITypeBinding superclass = itb2.getSuperclass();
            ITypeBinding[] interfaces = itb2.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (this.hasInheritanceRelationship(itb1, interfaces[i])) {
                    return true;
                }
                ++i;
            }
            return superclass != null && this.hasInheritanceRelationship(itb1, superclass);
        }
    }
}

