/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.fix.Messages;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public class ConvertToStringBufferFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public ConvertToStringBufferFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    public static ConvertToStringBufferFixCore createConvertToStringBufferFix(CompilationUnit compilationUnit, ASTNode node) {
        BodyDeclaration parentDecl = ASTResolving.findParentBodyDeclaration(node);
        if (!(parentDecl instanceof MethodDeclaration) && !(parentDecl instanceof Initializer)) {
            return null;
        }
        AST ast = node.getAST();
        ITypeBinding stringBinding = ast.resolveWellKnownType("java.lang.String");
        if (node instanceof Expression && !(node instanceof InfixExpression)) {
            node = node.getParent();
        }
        if (node instanceof VariableDeclarationFragment) {
            node = ((VariableDeclarationFragment)node).getInitializer();
        } else if (node instanceof Assignment) {
            node = ((Assignment)node).getRightHandSide();
        }
        InfixExpression oldInfixExpression = null;
        while (node instanceof InfixExpression) {
            InfixExpression curr = (InfixExpression)node;
            if (curr.resolveTypeBinding() != stringBinding || curr.getOperator() != InfixExpression.Operator.PLUS) break;
            oldInfixExpression = curr;
            node = node.getParent();
        }
        if (oldInfixExpression == null) {
            return null;
        }
        SimpleName existingBuffer = ConvertToStringBufferFixCore.getEnclosingAppendBuffer(oldInfixExpression);
        String bufferOrBuilderName = JavaModelUtil.is50OrHigher(compilationUnit.getTypeRoot().getJavaProject()) ? "StringBuilder" : "StringBuffer";
        String mechanismName = BasicElementLabels.getJavaElementName(existingBuffer == null ? bufferOrBuilderName : existingBuffer.getIdentifier());
        String label = Messages.format(CorrectionMessages.QuickAssistProcessor_convert_to_string_buffer_description, mechanismName);
        return new ConvertToStringBufferFixCore(label, compilationUnit, new ConvertToStringBufferProposalOperation(oldInfixExpression));
    }

    private static SimpleName getEnclosingAppendBuffer(InfixExpression infixExpression) {
        String typeName;
        IBinding binding;
        Expression expression;
        MethodInvocation methodInvocation;
        if (infixExpression.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY && (methodInvocation = (MethodInvocation)infixExpression.getParent()).getParent() instanceof Statement && "append".equals(methodInvocation.getName().getIdentifier()) && (expression = methodInvocation.getExpression()) instanceof SimpleName && (binding = ((SimpleName)expression).resolveBinding()) instanceof IVariableBinding && ("java.lang.StringBuilder".equals(typeName = ((IVariableBinding)binding).getType().getQualifiedName()) || "java.lang.StringBuffer".equals(typeName))) {
            return (SimpleName)expression;
        }
        return null;
    }

    private static void collectInfixPlusOperands(Expression expression, List<Expression> collector) {
        if (expression instanceof InfixExpression && ((InfixExpression)expression).getOperator() == InfixExpression.Operator.PLUS) {
            InfixExpression infixExpression = (InfixExpression)expression;
            ConvertToStringBufferFixCore.collectInfixPlusOperands(infixExpression.getLeftOperand(), collector);
            ConvertToStringBufferFixCore.collectInfixPlusOperands(infixExpression.getRightOperand(), collector);
            List extendedOperands = infixExpression.extendedOperands();
            for (Expression expression2 : extendedOperands) {
                ConvertToStringBufferFixCore.collectInfixPlusOperands(expression2, collector);
            }
        } else {
            collector.add(expression);
        }
    }

    private static class ConvertToStringBufferProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private InfixExpression oldInfixExpression;

        public ConvertToStringBufferProposalOperation(InfixExpression oldInfixExpression) {
            this.oldInfixExpression = oldInfixExpression;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            NLSElement[] nLSElementArray;
            String bufferName;
            Statement insertAfter;
            ListRewrite listRewrite;
            ICompilationUnit cu = cuRewrite.getCu();
            AST ast = cuRewrite.getAST();
            String bufferOrBuilderName = JavaModelUtil.is50OrHigher(cu.getJavaProject()) ? "StringBuilder" : "StringBuffer";
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            SimpleName existingBuffer = ConvertToStringBufferFixCore.getEnclosingAppendBuffer(this.oldInfixExpression);
            String groupID = "nameId";
            Statement enclosingStatement = ASTResolving.findParentStatement((ASTNode)this.oldInfixExpression);
            if (existingBuffer != null) {
                if (ASTNodes.isControlStatementBody(enclosingStatement.getLocationInParent())) {
                    Block newBlock = ast.newBlock();
                    listRewrite = rewrite.getListRewrite((ASTNode)newBlock, Block.STATEMENTS_PROPERTY);
                    insertAfter = null;
                    rewrite.replace((ASTNode)enclosingStatement, (ASTNode)newBlock, null);
                } else {
                    listRewrite = rewrite.getListRewrite(enclosingStatement.getParent(), (ChildListPropertyDescriptor)enclosingStatement.getLocationInParent());
                    insertAfter = enclosingStatement;
                }
                bufferName = existingBuffer.getIdentifier();
            } else {
                VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
                List<String> fExcludedVariableNames = Arrays.asList(ASTResolving.getUsedVariableNames((ASTNode)this.oldInfixExpression));
                SimpleType bufferType = ast.newSimpleType(ast.newName(bufferOrBuilderName));
                ClassInstanceCreation newBufferExpression = ast.newClassInstanceCreation();
                String[] newBufferNames = StubUtility.getVariableNameSuggestions(5, cu.getJavaProject(), bufferOrBuilderName, 0, fExcludedVariableNames, true);
                bufferName = newBufferNames[0];
                SimpleName bufferNameDeclaration = ast.newSimpleName(bufferName);
                frag.setName(bufferNameDeclaration);
                LinkedProposalPositionGroupCore pg = linkedModel.getPositionGroup(groupID, true);
                pg.addPosition(rewrite.track((ASTNode)bufferNameDeclaration), true);
                nLSElementArray = newBufferNames;
                int n = nLSElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NLSElement newBufferName = nLSElementArray[n2];
                    pg.addProposal((String)((Object)newBufferName), 10);
                    ++n2;
                }
                newBufferExpression.setType((Type)bufferType);
                frag.setInitializer((Expression)newBufferExpression);
                VariableDeclarationStatement bufferDeclaration = ast.newVariableDeclarationStatement(frag);
                bufferDeclaration.setType((Type)ast.newSimpleType(ast.newName(bufferOrBuilderName)));
                insertAfter = bufferDeclaration;
                Statement statement = ASTResolving.findParentStatement((ASTNode)this.oldInfixExpression);
                if (ASTNodes.isControlStatementBody(statement.getLocationInParent())) {
                    Block newBlock = ast.newBlock();
                    listRewrite = rewrite.getListRewrite((ASTNode)newBlock, Block.STATEMENTS_PROPERTY);
                    listRewrite.insertFirst((ASTNode)bufferDeclaration, null);
                    listRewrite.insertLast(rewrite.createMoveTarget((ASTNode)statement), null);
                    rewrite.replace((ASTNode)statement, (ASTNode)newBlock, null);
                } else {
                    listRewrite = rewrite.getListRewrite(statement.getParent(), (ChildListPropertyDescriptor)statement.getLocationInParent());
                    listRewrite.insertBefore((ASTNode)bufferDeclaration, (ASTNode)statement, null);
                }
            }
            ArrayList<Expression> operands = new ArrayList<Expression>();
            ConvertToStringBufferFixCore.collectInfixPlusOperands((Expression)this.oldInfixExpression, operands);
            Statement lastAppend = insertAfter;
            int tagsCount = 0;
            for (Expression operand : operands) {
                boolean tagged = false;
                NLSLine nlsLine = NLSUtil.scanCurrentLine(cu, operand.getStartPosition());
                if (nlsLine != null) {
                    nLSElementArray = nlsLine.getElements();
                    int newBlock = nLSElementArray.length;
                    int statement = 0;
                    while (statement < newBlock) {
                        NLSElement element = nLSElementArray[statement];
                        if (element.getPosition().getOffset() == operand.getStartPosition() && element.hasTag()) {
                            tagged = true;
                            ++tagsCount;
                        }
                        ++statement;
                    }
                }
                ExpressionStatement appendExpressionStatement = null;
                if (tagged) {
                    String appendCall = bufferName + ".append(" + String.valueOf(operand) + "); //$NON-NLS-1$";
                    appendExpressionStatement = (ExpressionStatement)rewrite.createStringPlaceholder(appendCall, 21);
                } else {
                    MethodInvocation appendIncovationExpression = ast.newMethodInvocation();
                    appendIncovationExpression.setName(ast.newSimpleName("append"));
                    SimpleName bufferNameReference = ast.newSimpleName(bufferName);
                    if (existingBuffer == null) {
                        linkedModel.getPositionGroup(groupID, true).addPosition(rewrite.track((ASTNode)bufferNameReference), true);
                    }
                    appendIncovationExpression.setExpression((Expression)bufferNameReference);
                    appendIncovationExpression.arguments().add(rewrite.createCopyTarget((ASTNode)operand));
                    appendExpressionStatement = ast.newExpressionStatement((Expression)appendIncovationExpression);
                }
                if (lastAppend == null) {
                    listRewrite.insertFirst((ASTNode)appendExpressionStatement, null);
                } else {
                    listRewrite.insertAfter((ASTNode)appendExpressionStatement, (ASTNode)lastAppend, null);
                }
                lastAppend = appendExpressionStatement;
            }
            if (existingBuffer != null) {
                linkedModel.setEndPosition(rewrite.track((ASTNode)lastAppend));
                if (insertAfter != null) {
                    rewrite.remove((ASTNode)enclosingStatement, null);
                }
            } else {
                MethodInvocation bufferToString = ast.newMethodInvocation();
                bufferToString.setName(ast.newSimpleName("toString"));
                SimpleName bufferNameReference = ast.newSimpleName(bufferName);
                bufferToString.setExpression((Expression)bufferNameReference);
                linkedModel.getPositionGroup(groupID, true).addPosition(rewrite.track((ASTNode)bufferNameReference), true);
                if (tagsCount > 0) {
                    ASTNodes.replaceAndRemoveNLSByCount(rewrite, (ASTNode)this.oldInfixExpression, bufferToString.toString().replaceAll(",", ", "), tagsCount, null, cuRewrite);
                } else {
                    rewrite.replace((ASTNode)this.oldInfixExpression, (ASTNode)bufferToString, null);
                }
                linkedModel.setEndPosition(rewrite.track((ASTNode)bufferToString));
            }
        }
    }
}

