/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.Messages;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessorUtil;

public class AddMissingMethodDeclarationFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public AddMissingMethodDeclarationFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    public static AddMissingMethodDeclarationFixCore createAddMissingMethodDeclaration(CompilationUnit compilationUnit, ASTNode node) {
        IMethodBinding methodBinding;
        String packageName;
        String typeDeclarationName;
        String methodReferenceQualifiedName;
        ExpressionMethodReference methodReferenceNode;
        ExpressionMethodReference expressionMethodReference = methodReferenceNode = node instanceof ExpressionMethodReference ? (ExpressionMethodReference)node : ASTNodes.getParent(node, ExpressionMethodReference.class);
        if (methodReferenceNode == null) {
            return null;
        }
        TypeDeclaration typeDeclaration = ASTNodes.getParent((ASTNode)methodReferenceNode, TypeDeclaration.class);
        if (QuickAssistProcessorUtil.isTypeReferenceToInstanceMethod((MethodReference)methodReferenceNode) && !(methodReferenceQualifiedName = ((Name)methodReferenceNode.getExpression()).getFullyQualifiedName()).equals(typeDeclarationName = (packageName = compilationUnit.getPackage() != null ? compilationUnit.getPackage().getName().getFullyQualifiedName() + "." : "") + typeDeclaration.getName().getFullyQualifiedName()) && !methodReferenceQualifiedName.equals(typeDeclaration.getName().getFullyQualifiedName())) {
            return null;
        }
        VariableDeclarationStatement variableDeclarationStatement = ASTNodes.getParent((ASTNode)methodReferenceNode, VariableDeclarationStatement.class);
        MethodInvocation methodInvocationNode = ASTNodes.getParent((ASTNode)methodReferenceNode, MethodInvocation.class);
        Assignment variableAssignment = ASTNodes.getParent((ASTNode)methodReferenceNode, Assignment.class);
        String label = Messages.format(CorrectionMessages.AddUnimplementedMethodReferenceOperation_AddMissingMethod_group, new String[]{methodReferenceNode.getName().getIdentifier(), typeDeclaration.getName().getIdentifier()});
        if ((variableAssignment != null || variableDeclarationStatement != null) && methodInvocationNode == null) {
            Type type = null;
            ReturnType returnType = null;
            if (variableDeclarationStatement != null) {
                type = variableDeclarationStatement.getType();
                returnType = AddMissingMethodDeclarationFixCore.getReturnType(type);
            } else {
                Expression leftHandSide = variableAssignment.getLeftHandSide();
                ITypeBinding assignmentTypeBinding = leftHandSide.resolveTypeBinding();
                if (assignmentTypeBinding == null) {
                    return null;
                }
                returnType = new ReturnType();
                returnType.binding = assignmentTypeBinding;
            }
            if (returnType.binding == null) {
                return null;
            }
            return new AddMissingMethodDeclarationFixCore(label, compilationUnit, new AddMissingMethodDeclarationProposalOperation(methodReferenceNode, returnType, null));
        }
        IMethodBinding iMethodBinding = methodBinding = methodInvocationNode == null ? null : methodInvocationNode.resolveMethodBinding();
        if (methodBinding == null) {
            return null;
        }
        List arguments = methodInvocationNode.arguments();
        int index = -1;
        int i = 0;
        while (i < arguments.size()) {
            ASTNode argNode = (ASTNode)arguments.get(i);
            if (argNode.equals((Object)methodReferenceNode)) {
                index = i;
                break;
            }
            ++i;
        }
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        if (index >= parameterTypes.length) {
            return null;
        }
        return new AddMissingMethodDeclarationFixCore(label, compilationUnit, new AddMissingMethodDeclarationProposalOperation(methodReferenceNode, null, methodBinding));
    }

    private static ReturnType getReturnType(Type variableType) {
        ITypeBinding returnTypeBinding;
        ReturnType returnType = new ReturnType();
        if (variableType instanceof ParameterizedType && (returnTypeBinding = (variableType = (Type)((ParameterizedType)variableType).typeArguments().get(0)).resolveBinding()) != null) {
            returnType.binding = returnTypeBinding.isCapture() ? returnTypeBinding.getErasure() : (returnTypeBinding.isWildcardType() ? returnTypeBinding.getBound() : returnTypeBinding);
        }
        return returnType;
    }

    private static class AddMissingMethodDeclarationProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private ExpressionMethodReference methodReferenceNode;
        private ReturnType returnType;
        private IMethodBinding methodBinding;

        public AddMissingMethodDeclarationProposalOperation(ExpressionMethodReference methodReferenceNode, ReturnType returnType, IMethodBinding methodBinding) {
            if (returnType == null && methodBinding == null) {
                throw new IllegalArgumentException("both returnType and methodBinding cannot be null.");
            }
            this.methodReferenceNode = methodReferenceNode;
            this.returnType = returnType;
            this.methodBinding = methodBinding;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            boolean addStaticModifier = false;
            TypeDeclaration typeDeclaration = ASTNodes.getParent((ASTNode)this.methodReferenceNode, TypeDeclaration.class);
            if (QuickAssistProcessorUtil.isTypeReferenceToInstanceMethod((MethodReference)this.methodReferenceNode)) {
                addStaticModifier = true;
            }
            AST ast = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)typeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            VariableDeclarationStatement variableDeclarationStatement = ASTNodes.getParent((ASTNode)this.methodReferenceNode, VariableDeclarationStatement.class);
            MethodInvocation methodInvocationNode = ASTNodes.getParent((ASTNode)this.methodReferenceNode, MethodInvocation.class);
            Assignment variableAssignment = ASTNodes.getParent((ASTNode)this.methodReferenceNode, Assignment.class);
            if ((variableAssignment != null || variableDeclarationStatement != null) && methodInvocationNode == null) {
                IMethodBinding functionalInterfaceMethod;
                this.returnType.type = importRewrite.addImport(this.returnType.binding, ast);
                MethodDeclaration newMethodDeclaration = ast.newMethodDeclaration();
                newMethodDeclaration.setName((SimpleName)rewrite.createCopyTarget((ASTNode)this.methodReferenceNode.getName()));
                newMethodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
                if (addStaticModifier) {
                    newMethodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
                }
                IMethodBinding iMethodBinding = functionalInterfaceMethod = variableDeclarationStatement == null ? this.returnType.binding.getFunctionalInterfaceMethod() : variableDeclarationStatement.getType().resolveBinding().getFunctionalInterfaceMethod();
                if (functionalInterfaceMethod != null) {
                    this.returnType.type = importRewrite.addImport(functionalInterfaceMethod.getReturnType(), ast);
                    this.returnType.binding = functionalInterfaceMethod.getReturnType();
                    ITypeBinding[] typeArguments = functionalInterfaceMethod.getParameterTypes();
                    int i = 0;
                    while (i < typeArguments.length) {
                        ITypeBinding iTypeBinding = typeArguments[i];
                        SingleVariableDeclaration newSingleVariableDeclaration = ast.newSingleVariableDeclaration();
                        newSingleVariableDeclaration.setName(ast.newSimpleName(iTypeBinding.getErasure().getName().toLowerCase() + (i + 1)));
                        newSingleVariableDeclaration.setType(importRewrite.addImport(iTypeBinding.getErasure(), ast));
                        newMethodDeclaration.parameters().add(newSingleVariableDeclaration);
                        ++i;
                    }
                }
                newMethodDeclaration.setReturnType2(this.returnType.type);
                Block newBlock = AddMissingMethodDeclarationProposalOperation.getNewReturnBlock(ast, this.returnType.binding);
                newMethodDeclaration.setBody(newBlock);
                listRewrite.insertLast((ASTNode)newMethodDeclaration, null);
            } else {
                Type newReturnType;
                MethodDeclaration newMethodDeclaration;
                ITypeBinding returnTypeBindingFunctionalInterface;
                ITypeBinding[] parameterTypesFunctionalInterface;
                ITypeBinding[] typeArguments;
                block23: {
                    List arguments = methodInvocationNode.arguments();
                    int index = -1;
                    int i = 0;
                    while (i < arguments.size()) {
                        ASTNode node = (ASTNode)arguments.get(i);
                        if (node.equals((Object)this.methodReferenceNode)) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    ITypeBinding[] parameterTypes = this.methodBinding.getParameterTypes();
                    typeArguments = this.methodBinding.getTypeArguments();
                    parameterTypesFunctionalInterface = parameterTypes[index].getFunctionalInterfaceMethod().getParameterTypes();
                    returnTypeBindingFunctionalInterface = parameterTypes[index].getFunctionalInterfaceMethod().getReturnType();
                    newMethodDeclaration = ast.newMethodDeclaration();
                    newMethodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
                    if (addStaticModifier) {
                        newMethodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
                    }
                    newReturnType = null;
                    if (returnTypeBindingFunctionalInterface.isPrimitive()) {
                        newReturnType = ast.newPrimitiveType(PrimitiveType.toCode((String)returnTypeBindingFunctionalInterface.getName()));
                    } else {
                        newReturnType = importRewrite.addImport(returnTypeBindingFunctionalInterface, ast);
                        ITypeBinding[] typeParameters = typeDeclaration.resolveBinding().getTypeParameters();
                        if (returnTypeBindingFunctionalInterface.isTypeVariable() || returnTypeBindingFunctionalInterface.isParameterizedType()) {
                            ITypeBinding[] iTypeBindingArray = typeParameters;
                            int n = typeParameters.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ITypeBinding typeParameter = iTypeBindingArray[n2];
                                if (!Bindings.equals((IBinding)typeParameter, (IBinding)returnTypeBindingFunctionalInterface)) {
                                    ++n2;
                                    continue;
                                }
                                break block23;
                            }
                            TypeParameter newTypeParameter = ast.newTypeParameter();
                            newTypeParameter.setName(ast.newSimpleName(returnTypeBindingFunctionalInterface.getName()));
                            AddMissingMethodDeclarationProposalOperation.addIfMissing(newMethodDeclaration, newTypeParameter);
                        }
                    }
                }
                newMethodDeclaration.setName((SimpleName)rewrite.createCopyTarget((ASTNode)this.methodReferenceNode.getName()));
                newMethodDeclaration.setReturnType2(newReturnType);
                int i = 0;
                while (i < parameterTypesFunctionalInterface.length) {
                    block24: {
                        ITypeBinding parameterType2 = parameterTypesFunctionalInterface[i];
                        SingleVariableDeclaration newSingleVariableDeclaration = ast.newSingleVariableDeclaration();
                        if (parameterType2.isCapture()) {
                            newSingleVariableDeclaration.setName(ast.newSimpleName(parameterType2.getErasure().getName().toLowerCase() + (i + 1)));
                            newSingleVariableDeclaration.setType(importRewrite.addImport(parameterType2.getErasure(), ast));
                        } else {
                            newSingleVariableDeclaration.setName(ast.newSimpleName(parameterType2.getName().toLowerCase() + (i + 1)));
                            newSingleVariableDeclaration.setType(importRewrite.addImport(parameterType2, ast));
                        }
                        newMethodDeclaration.parameters().add(newSingleVariableDeclaration);
                        ITypeBinding[] typeParameters = typeDeclaration.resolveBinding().getTypeParameters();
                        if (parameterType2.isTypeVariable()) {
                            ITypeBinding[] typeBounds;
                            ITypeBinding[] iTypeBindingArray = typeParameters;
                            int n = typeParameters.length;
                            int n3 = 0;
                            while (n3 < n) {
                                ITypeBinding typeParameter = iTypeBindingArray[n3];
                                if (!Bindings.equals((IBinding)typeParameter, (IBinding)parameterType2)) {
                                    ++n3;
                                    continue;
                                }
                                break block24;
                            }
                            TypeParameter newTypeParameter = ast.newTypeParameter();
                            newTypeParameter.setName(ast.newSimpleName(importRewrite.addImport(parameterType2)));
                            ITypeBinding[] iTypeBindingArray2 = typeBounds = parameterType2.getTypeBounds();
                            int n4 = typeBounds.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                ITypeBinding typeBound = iTypeBindingArray2[n5];
                                newTypeParameter.typeBounds().add(importRewrite.addImport(typeBound, ast));
                                ++n5;
                            }
                            AddMissingMethodDeclarationProposalOperation.addIfMissing(newMethodDeclaration, newTypeParameter);
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < typeArguments.length) {
                    ITypeBinding typeArgument = typeArguments[i];
                    SingleVariableDeclaration newSingleVariableDeclaration = ast.newSingleVariableDeclaration();
                    newSingleVariableDeclaration.setName(ast.newSimpleName(typeArgument.getName().toLowerCase() + (i + 1)));
                    newSingleVariableDeclaration.setType(importRewrite.addImport(typeArgument, ast));
                    newMethodDeclaration.parameters().add(newSingleVariableDeclaration);
                    if (typeArgument.isTypeVariable()) {
                        TypeParameter newTypeParameter = ast.newTypeParameter();
                        newTypeParameter.setName(ast.newSimpleName(importRewrite.addImport(typeArgument)));
                        newMethodDeclaration.typeParameters().add(newTypeParameter);
                    }
                    ++i;
                }
                Block newBlock = AddMissingMethodDeclarationProposalOperation.getNewReturnBlock(ast, returnTypeBindingFunctionalInterface);
                newMethodDeclaration.setBody(newBlock);
                listRewrite.insertLast((ASTNode)newMethodDeclaration, null);
            }
        }

        private static void addIfMissing(MethodDeclaration methodDeclaration, TypeParameter newTypeParameter) {
            List typeParameters = methodDeclaration.typeParameters();
            for (TypeParameter typeParameter : typeParameters) {
                boolean equals = typeParameter.getName().getFullyQualifiedName().equals(newTypeParameter.getName().getFullyQualifiedName());
                if (!equals) continue;
                return;
            }
            typeParameters.add(newTypeParameter);
        }

        private static Block getNewReturnBlock(AST ast, ITypeBinding returnTypeBinding) {
            Block newBlock = ast.newBlock();
            if (!"void".equals(returnTypeBinding.getName())) {
                ReturnStatement newReturnStatement = ast.newReturnStatement();
                String bName = returnTypeBinding.getBinaryName();
                if ("Z".equals(bName)) {
                    newReturnStatement.setExpression((Expression)ast.newBooleanLiteral(false));
                } else if (returnTypeBinding.isPrimitive()) {
                    newReturnStatement.setExpression((Expression)ast.newNumberLiteral());
                } else if ("java.lang.String".equals(bName)) {
                    newReturnStatement.setExpression((Expression)ast.newStringLiteral());
                } else {
                    newReturnStatement.setExpression((Expression)ast.newNullLiteral());
                }
                newBlock.statements().add(newReturnStatement);
            }
            return newBlock;
        }
    }

    private static class ReturnType {
        public Type type;
        public ITypeBinding binding;

        private ReturnType() {
        }
    }
}

