/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class TypeFilter {
    public static final String TYPEFILTER_ENABLED = "org.eclipse.jdt.ui.typefilter.enabled";
    private StringMatcher[] fStringMatchers = null;

    public static TypeFilter getDefault() {
        return JavaLanguageServerPlugin.getInstance().getTypeFilter();
    }

    public static boolean isFiltered(String fullTypeName) {
        return TypeFilter.getDefault().filter(fullTypeName);
    }

    public static boolean isFiltered(char[] fullTypeName) {
        return TypeFilter.getDefault().filter(new String(fullTypeName));
    }

    public static boolean isFiltered(char[] packageName, char[] typeName) {
        return TypeFilter.getDefault().filter(JavaModelUtil.concatenateName((char[])packageName, (char[])typeName));
    }

    public static boolean isFiltered(IType type) {
        TypeFilter typeFilter = TypeFilter.getDefault();
        if (typeFilter.hasFilters()) {
            return typeFilter.filter(type.getFullyQualifiedName('.'));
        }
        return false;
    }

    public static boolean isFiltered(TypeNameMatch match) {
        boolean filteredByPattern = TypeFilter.getDefault().filter(match.getFullyQualifiedName());
        if (filteredByPattern) {
            return true;
        }
        int accessibility = match.getAccessibility();
        switch (accessibility) {
            case 1: {
                return "enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.forbiddenReferenceCheck"));
            }
            case 2: {
                return "enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.discouragedReferenceCheck"));
            }
        }
        return false;
    }

    public synchronized void removeFilterIfMatched(Collection<String> importedElements) {
        if (importedElements == null || importedElements.isEmpty()) {
            return;
        }
        StringMatcher[] matchers = this.getStringMatchers();
        this.fStringMatchers = (StringMatcher[])Arrays.stream(matchers).filter((? super T m) -> {
            for (String importedElement : importedElements) {
                if (!m.match(importedElement)) continue;
                return false;
            }
            return true;
        }).toArray(StringMatcher[]::new);
    }

    private synchronized StringMatcher[] getStringMatchers() {
        if (this.fStringMatchers == null) {
            String str = TypeFilter.getPreference(TYPEFILTER_ENABLED);
            StringTokenizer tok = new StringTokenizer(str, ";");
            int nTokens = tok.countTokens();
            this.fStringMatchers = new StringMatcher[nTokens];
            int i = 0;
            while (i < nTokens) {
                String curr = tok.nextToken();
                if (curr.length() > 0) {
                    this.fStringMatchers[i] = new StringMatcher(curr, false, false);
                }
                ++i;
            }
        }
        return this.fStringMatchers;
    }

    public boolean hasFilters() {
        return this.getStringMatchers().length > 0;
    }

    public boolean filter(String fullTypeName) {
        StringMatcher[] matchers = this.getStringMatchers();
        int i = 0;
        while (i < matchers.length) {
            StringMatcher curr = matchers[i];
            if (curr.match(fullTypeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getPreference(String key) {
        String val = InstanceScope.INSTANCE.getNode(JavaManipulation.getPreferenceNodeId()).get(key, null);
        if (val != null) {
            return val;
        }
        return DefaultScope.INSTANCE.getNode(JavaManipulation.getPreferenceNodeId()).get(key, null);
    }

    public void dispose() {
        this.fStringMatchers = null;
    }
}

