/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.internal.gradle.checksums;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.ls.core.internal.ExceptionFactory;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.internal.gradle.checksums.DownloadChecksumJob;
import org.eclipse.jdt.ls.internal.gradle.checksums.HashProvider;
import org.eclipse.jdt.ls.internal.gradle.checksums.ValidationResult;
import org.osgi.framework.Bundle;

public class WrapperValidator {
    public static final String GRADLE_CHECKSUMS = "/gradle/checksums/checksums.json";
    public static final String GRADLE_VERSIONS = "/gradle/checksums/versions.json";
    private static final int QUEUE_LENGTH = 20;
    private static final String WRAPPER_CHECKSUM_URL = "wrapperChecksumUrl";
    private static final String GRADLE_WRAPPER_JAR = "gradle/wrapper/gradle-wrapper.jar";
    private static Set<String> allowed = new HashSet<String>();
    private static Set<String> disallowed = new HashSet<String>();
    private static Set<String> wrapperChecksumUrls = new HashSet<String>();
    private static AtomicBoolean downloaded = new AtomicBoolean(false);
    private HashProvider hashProvider = new HashProvider();
    private int queueLength;

    public WrapperValidator(int queueLength) {
        this.queueLength = queueLength;
    }

    public WrapperValidator() {
        this(20);
    }

    public ValidationResult checkWrapper(String baseDir) throws CoreException {
        java.nio.file.Path wrapperJar;
        block23: {
            wrapperJar = Paths.get(baseDir, GRADLE_WRAPPER_JAR);
            if (!wrapperJar.toFile().exists()) {
                throw ExceptionFactory.newException(wrapperJar.toString() + " doesn't exist.");
            }
            if (!downloaded.get() || allowed.isEmpty()) {
                this.loadInternalChecksums();
                File versionFile = WrapperValidator.getVersionCacheFile();
                if (!versionFile.exists()) {
                    JobHelpers.waitForLoadingGradleVersionJob();
                }
                if (versionFile.exists()) {
                    try {
                        Throwable throwable = null;
                        Object var5_8 = null;
                        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(versionFile), StandardCharsets.UTF_8);){
                            String json = CharStreams.toString((Readable)reader);
                            Gson gson = new GsonBuilder().create();
                            TypeToken<List<Map<String, String>>> typeToken = new TypeToken<List<Map<String, String>>>(){};
                            List versions = (List)gson.fromJson(json, typeToken.getType());
                            ImmutableList urls = FluentIterable.from((Iterable)versions).filter((Predicate)new Predicate<Map<String, String>>(){

                                public boolean apply(Map<String, String> input) {
                                    return input.get(WrapperValidator.WRAPPER_CHECKSUM_URL) != null;
                                }
                            }).transform((Function)new Function<Map<String, String>, String>(){

                                public String apply(Map<String, String> input) {
                                    return input.get(WrapperValidator.WRAPPER_CHECKSUM_URL);
                                }
                            }).toList();
                            DownloadChecksumJob downloadJob = new DownloadChecksumJob();
                            int count = 0;
                            File cacheDir = WrapperValidator.getSha256CacheFile();
                            for (String wrapperChecksumUrl : urls) {
                                try {
                                    String fileName;
                                    if (wrapperChecksumUrls.contains(wrapperChecksumUrl) || (fileName = WrapperValidator.getFileName(wrapperChecksumUrl)) == null) continue;
                                    File sha256File = new File(cacheDir, fileName);
                                    if (!sha256File.exists() || sha256File.lastModified() < versionFile.lastModified()) {
                                        if (++count > this.queueLength) {
                                            downloadJob.schedule();
                                            downloadJob = new DownloadChecksumJob();
                                            count = 0;
                                        }
                                        downloadJob.add(wrapperChecksumUrl);
                                        continue;
                                    }
                                    String sha256 = WrapperValidator.read(sha256File);
                                    allowed.add(sha256);
                                }
                                catch (Exception e) {
                                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                                }
                            }
                            if (!downloadJob.isEmpty()) {
                                downloadJob.schedule();
                            }
                            JobHelpers.waitForJobs("WrapperValidatorJobs", (IProgressMonitor)new NullProgressMonitor());
                            downloaded.set(true);
                            break block23;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException | OperationCanceledException e) {
                        throw ExceptionFactory.newException(e);
                    }
                }
                this.updateGradleVersionsFile();
            }
        }
        try {
            String sha256 = this.hashProvider.getChecksum(wrapperJar.toFile());
            return new ValidationResult(wrapperJar.toString(), sha256, allowed.contains(sha256));
        }
        catch (IOException e) {
            throw ExceptionFactory.newException(e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadInternalChecksums() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jdt.ls.core");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(GRADLE_CHECKSUMS));
        if (url == null) return;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                InputStream inputStream = url.openStream();
                try {
                    block23: {
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                        try {
                            try (BufferedReader reader = new BufferedReader(inputStreamReader);){
                                JsonElement jsonElement;
                                JsonElement jsonElement2 = jsonElement = JsonParser.parseReader((Reader)reader);
                                if (jsonElement2 instanceof JsonArray) {
                                    void array;
                                    JsonArray jsonArray = (JsonArray)jsonElement2;
                                    JsonArray cfr_ignored_0 = (JsonArray)jsonElement2;
                                    for (JsonElement json : array) {
                                        if (!json.isJsonObject()) continue;
                                        JsonObject jsonObject = json.getAsJsonObject();
                                        String sha256 = jsonObject.get("sha256").getAsString();
                                        String wrapperChecksumUrl = jsonObject.get(WRAPPER_CHECKSUM_URL).getAsString();
                                        if (sha256 != null) {
                                            allowed.add(sha256);
                                        }
                                        if (wrapperChecksumUrl == null) continue;
                                        wrapperChecksumUrls.add(wrapperChecksumUrl);
                                    }
                                }
                            }
                            if (inputStreamReader == null) break block23;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inputStreamReader == null) throw throwable;
                            inputStreamReader.close();
                            throw throwable;
                        }
                        inputStreamReader.close();
                    }
                    if (inputStream == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateGradleVersionsFile() {
        File file = WrapperValidator.getVersionCacheFile();
        if (file.isFile()) {
            return;
        }
        file.getParentFile().mkdirs();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jdt.ls.core");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(GRADLE_VERSIONS));
        if (url == null) return;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                InputStream is = url.openStream();
                try {
                    block27: {
                        InputStreamReader isr = new InputStreamReader(is);
                        try {
                            block26: {
                                BufferedReader br = new BufferedReader(isr);
                                try {
                                    try (FileOutputStream os = new FileOutputStream(file.getAbsolutePath());){
                                        br.lines().forEach(l -> {
                                            try {
                                                os.write(l.getBytes(StandardCharsets.UTF_8));
                                                os.write("\n".getBytes(StandardCharsets.UTF_8));
                                            }
                                            catch (IOException e) {
                                                JavaLanguageServerPlugin.logException(e.getMessage(), e);
                                            }
                                        });
                                    }
                                    if (br == null) break block26;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (br == null) throw throwable;
                                    br.close();
                                    throw throwable;
                                }
                                br.close();
                            }
                            if (isr == null) break block27;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (isr == null) throw throwable;
                            isr.close();
                            throw throwable;
                        }
                        isr.close();
                    }
                    if (is == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
    }

    public static String getFileName(String url) {
        int index = url.lastIndexOf("/");
        if (index < 0 || url.length() < index + 1) {
            JavaLanguageServerPlugin.logInfo("Invalid wrapper URL " + url);
            return null;
        }
        return url.substring(index + 1);
    }

    private static String read(File file) {
        Optional<String> firstLine;
        try {
            firstLine = Files.lines(Paths.get(file.getAbsolutePath(), new String[0]), StandardCharsets.UTF_8).findFirst();
        }
        catch (IOException e) {
            JavaLanguageServerPlugin.logException(e);
            return null;
        }
        if (firstLine.isPresent()) {
            return firstLine.get();
        }
        return null;
    }

    private static File getVersionCacheFile() {
        String xdgCache = WrapperValidator.getXdgCache();
        return new File(xdgCache, "tooling/gradle/versions.json");
    }

    private static String getXdgCache() {
        Object xdgCache = System.getenv("XDG_CACHE_HOME");
        if (xdgCache == null) {
            xdgCache = System.getProperty("user.home") + "/.cache/";
        }
        return xdgCache;
    }

    public static File getSha256CacheFile() {
        File file;
        String checksumCache = System.getProperty("gradle.checksum.cacheDir");
        if (checksumCache == null || checksumCache.isEmpty()) {
            String xdgCache = WrapperValidator.getXdgCache();
            file = new File(xdgCache, "tooling/gradle/checksums");
        } else {
            file = new File(checksumCache);
        }
        file.mkdirs();
        return file;
    }

    public static void clear() {
        allowed.clear();
        disallowed.clear();
        wrapperChecksumUrls.clear();
    }

    public static void allow(Collection<String> c) {
        allowed.addAll(c);
    }

    public static void allow(String checksum) {
        allowed.add(checksum);
    }

    public static void disallow(Collection<String> c) {
        disallowed.addAll(c);
    }

    public static boolean contains(String checksum) {
        return disallowed.contains(checksum);
    }

    public static int size() {
        return allowed.size() + disallowed.size();
    }

    public static Set<String> getAllowed() {
        return Collections.unmodifiableSet(allowed);
    }

    public static Set<String> getDisallowed() {
        return Collections.unmodifiableSet(allowed);
    }

    /*
     * WARNING - void declaration
     */
    public static void putSha256(List<?> gradleWrapperList) {
        ArrayList<String> sha256Allowed = new ArrayList<String>();
        ArrayList<String> sha256Disallowed = new ArrayList<String>();
        for (Object object : gradleWrapperList) {
            void map;
            Object obj = object;
            if (!(obj instanceof Map)) continue;
            Map cfr_ignored_0 = (Map)obj;
            Map cfr_ignored_1 = (Map)obj;
            ChecksumWrapper sha256 = new ChecksumWrapper();
            sha256.allowed = true;
            map.forEach((k, v) -> {
                block10: {
                    void key;
                    Object object = k;
                    if (!(object instanceof String)) break block10;
                    String string = (String)object;
                    String cfr_ignored_0 = (String)object;
                    switch (key) {
                        case "sha256": {
                            void value;
                            Object object2 = v;
                            if (!(object2 instanceof String)) break;
                            String string2 = (String)object2;
                            String cfr_ignored_1 = (String)object2;
                            checksumWrapper.checksum = value;
                            break;
                        }
                        case "allowed": {
                            void bool;
                            Object object3 = v;
                            if (!(object3 instanceof Boolean)) break;
                            Boolean bl = (Boolean)object3;
                            Boolean cfr_ignored_2 = (Boolean)object3;
                            checksumWrapper.allowed = bool.booleanValue();
                            break;
                        }
                    }
                }
            });
            if (sha256.checksum == null) continue;
            if (sha256.allowed) {
                sha256Allowed.add(sha256.checksum);
                continue;
            }
            sha256Disallowed.add(sha256.checksum);
        }
        WrapperValidator.clear();
        if (sha256Allowed != null) {
            WrapperValidator.allow(sha256Allowed);
        }
        if (sha256Disallowed != null) {
            WrapperValidator.disallow(sha256Disallowed);
        }
    }

    private static class ChecksumWrapper {
        private String checksum;
        private boolean allowed;

        private ChecksumWrapper() {
        }
    }
}

