/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.gson.JsonObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.function.Predicate;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.handlers.DefaultLogFilter;
import org.eclipse.jdt.ls.core.internal.managers.TelemetryEvent;
import org.eclipse.lsp4j.MessageType;

public class LogHandler {
    public static Predicate<IStatus> defaultLogFilter = new DefaultLogFilter();
    private static final String JAVA_ERROR_LOG = "java.ls.error";
    private ILogListener logListener;
    private DateFormat dateFormat;
    private int logLevelMask;
    private JavaClientConnection connection;
    private Predicate<IStatus> filter;

    public LogHandler() {
        this(defaultLogFilter);
    }

    public LogHandler(Predicate<IStatus> filter) {
        this.filter = filter;
    }

    public void install(JavaClientConnection rcpConnection) {
        this.dateFormat = DateFormat.getDateTimeInstance(2, 2);
        this.logLevelMask = this.getLogLevelMask(System.getProperty("log.level", ""));
        this.connection = rcpConnection;
        this.logListener = new ILogListener(){

            public void logging(IStatus status, String bundleId) {
                LogHandler.this.processLogMessage(status);
            }
        };
        Platform.addLogListener((ILogListener)this.logListener);
    }

    public void uninstall() {
        Platform.removeLogListener((ILogListener)this.logListener);
    }

    /*
     * Exception decompiling
     */
    private int getLogLevelMask(String logLevel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl34 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl34 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processLogMessage(IStatus status) {
        if (this.filter != null && !this.filter.test(status) || !status.matches(this.logLevelMask)) {
            return;
        }
        String dateString = this.dateFormat.format(new Date());
        Object message = status.getMessage();
        if (status.getException() != null) {
            message = (String)message + "\n" + status.getException().getMessage();
            StringWriter sw = new StringWriter();
            status.getException().printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            message = (String)message + "\n" + exceptionAsString;
        }
        this.connection.logMessage(this.getMessageTypeFromSeverity(status.getSeverity()), dateString + " " + (String)message);
        if (status.getSeverity() == 4) {
            JsonObject properties = new JsonObject();
            properties.addProperty("message", this.redact(status.getMessage()));
            if (status.getException() != null) {
                properties.addProperty("exception", (String)message);
            }
            this.connection.telemetryEvent(new TelemetryEvent(JAVA_ERROR_LOG, properties));
        }
    }

    private String redact(String message) {
        if (message == null) {
            return null;
        }
        if (message.startsWith("Error occured while building workspace.")) {
            return "Error occured while building workspace.";
        }
        return message;
    }

    private MessageType getMessageTypeFromSeverity(int severity) {
        switch (severity) {
            case 4: {
                return MessageType.Error;
            }
            case 2: {
                return MessageType.Warning;
            }
            case 1: {
                return MessageType.Info;
            }
        }
        return MessageType.Log;
    }
}

