/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.IntroduceParameterRefactoring;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.corrections.InvertBooleanUtility;
import org.eclipse.jdt.ls.core.internal.corrections.RefactorProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.RefactoringCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.ChangeSignatureHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.ExtractInterfaceHandler;
import org.eclipse.jdt.ls.core.internal.handlers.FormatterHandler;
import org.eclipse.jdt.ls.core.internal.handlers.InferSelectionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.MoveHandler;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactorProposalUtility;
import org.eclipse.lsp4j.ChangeAnnotation;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;

public class GetRefactorEditHandler {
    public static final String RENAME_COMMAND = "java.action.rename";
    private static final String DEFAULT_POSITION_KEY = "name";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RefactorWorkspaceEdit getEditsForRefactor(GetRefactorEditParams params) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.context.getTextDocument().getUri());
        if (unit == null) {
            return null;
        }
        int start = DiagnosticsHelper.getStartOffset(unit, params.context.getRange());
        int end = DiagnosticsHelper.getEndOffset(unit, params.context.getRange());
        InnovationContext context = new InnovationContext(unit, start, end - start);
        CompilationUnit ast = CodeActionHandler.getASTRoot(unit);
        if (ast == null) {
            return null;
        }
        context.setASTRoot(ast);
        IProblemLocationCore[] locations = CodeActionHandler.getProblemLocationCores(unit, params.context.getContext().getDiagnostics());
        boolean problemsAtLocation = locations.length != 0;
        String positionKey = DEFAULT_POSITION_KEY;
        try {
            LinkedProposalPositionGroupCore.PositionInformation highlightPosition;
            LinkedCorrectionProposal proposal;
            block25: {
                block33: {
                    block32: {
                        block31: {
                            block30: {
                                InferSelectionHandler.SelectionInfo info;
                                Map<String, String> formatterOptions;
                                block29: {
                                    block28: {
                                        InferSelectionHandler.SelectionInfo selectionInfo;
                                        block27: {
                                            block26: {
                                                block24: {
                                                    InferSelectionHandler.SelectionInfo selectionInfo2;
                                                    formatterOptions = params.options == null ? null : FormatterHandler.getOptions(params.options, unit);
                                                    proposal = null;
                                                    if (!"extractVariable".equals(params.command) && !"extractVariableAllOccurrence".equals(params.command) && !"extractConstant".equals(params.command)) break block24;
                                                    InferSelectionHandler.SelectionInfo selectionInfo3 = selectionInfo2 = params.commandArguments != null && !params.commandArguments.isEmpty() ? JSONUtility.toModel(params.commandArguments.get(0), InferSelectionHandler.SelectionInfo.class) : null;
                                                    if (selectionInfo2 != null) {
                                                        context = new InnovationContext(unit, selectionInfo2.offset, selectionInfo2.length);
                                                    }
                                                    proposal = (LinkedCorrectionProposal)GetRefactorEditHandler.getExtractVariableProposal(params.context, context, problemsAtLocation, params.command, formatterOptions);
                                                    break block25;
                                                }
                                                if (!"assignVariable".equals(params.command)) break block26;
                                                proposal = (LinkedCorrectionProposal)GetRefactorEditHandler.getAssignVariableProposal(params, context, problemsAtLocation, params.command, formatterOptions, locations);
                                                break block25;
                                            }
                                            if (!"assignField".equals(params.command)) break block27;
                                            proposal = (LinkedCorrectionProposal)RefactorProposalUtility.getAssignFieldProposal(params.context, context, problemsAtLocation, formatterOptions, false, locations);
                                            break block25;
                                        }
                                        if (!"extractMethod".equals(params.command)) break block28;
                                        InferSelectionHandler.SelectionInfo selectionInfo4 = selectionInfo = params.commandArguments != null && !params.commandArguments.isEmpty() ? JSONUtility.toModel(params.commandArguments.get(0), InferSelectionHandler.SelectionInfo.class) : null;
                                        if (selectionInfo != null) {
                                            context = new InnovationContext(unit, selectionInfo.offset, selectionInfo.length);
                                        }
                                        proposal = (LinkedCorrectionProposal)GetRefactorEditHandler.getExtractMethodProposal(params.context, context, context.getCoveringNode(), problemsAtLocation, formatterOptions);
                                        break block25;
                                    }
                                    if (!"convertVariableToField".equals(params.command)) break block29;
                                    String string = params.commandArguments != null && !params.commandArguments.isEmpty() ? JSONUtility.toModel(params.commandArguments.get(0), String.class) : null;
                                    proposal = (LinkedCorrectionProposal)RefactorProposalUtility.getConvertVariableToFieldProposal(params.context, context, problemsAtLocation, formatterOptions, string, false);
                                    break block25;
                                }
                                if (!"extractField".equals(params.command)) break block30;
                                String string = params.commandArguments != null && !params.commandArguments.isEmpty() ? JSONUtility.toModel(params.commandArguments.get(0), String.class) : null;
                                InferSelectionHandler.SelectionInfo selectionInfo = info = params.commandArguments != null && params.commandArguments.size() > 1 ? JSONUtility.toModel(params.commandArguments.get(1), InferSelectionHandler.SelectionInfo.class) : null;
                                if (info != null) {
                                    context = new InnovationContext(unit, info.offset, info.length);
                                }
                                proposal = (LinkedCorrectionProposal)RefactorProposalUtility.getExtractFieldProposal(params.context, context, problemsAtLocation, formatterOptions, string, false);
                                break block25;
                            }
                            if (!"invertVariable".equals(params.command)) break block31;
                            proposal = (LinkedCorrectionProposal)InvertBooleanUtility.getInvertVariableProposal(params.context, context, context.getCoveringNode(), false);
                            break block25;
                        }
                        if (!"convertAnonymousClassToNestedCommand".equals(params.command)) break block32;
                        proposal = RefactorProcessor.getConvertAnonymousToNestedProposal(params.context, context, context.getCoveringNode(), false);
                        positionKey = "type_name";
                        break block25;
                    }
                    if (!"introduceParameter".equals(params.command)) break block33;
                    proposal = (LinkedCorrectionProposal)RefactorProposalUtility.getIntroduceParameterRefactoringProposals(params.context, context, context.getCoveringNode(), false, locations);
                    positionKey = null;
                    LinkedCorrectionProposal linkedCorrectionProposal = proposal;
                    if (linkedCorrectionProposal instanceof RefactoringCorrectionProposal) {
                        RefactoringCorrectionProposal refactoringCorrectionProposal = (RefactoringCorrectionProposal)linkedCorrectionProposal;
                        RefactoringCorrectionProposal cfr_ignored_0 = (RefactoringCorrectionProposal)linkedCorrectionProposal;
                        IntroduceParameterRefactoring refactoring = (IntroduceParameterRefactoring)refactoringCorrectionProposal.getRefactoring();
                        ParameterInfo parameterInfo = refactoring.getAddedParameterInfo();
                        if (parameterInfo != null) {
                            positionKey = parameterInfo.getNewName();
                        }
                    }
                    break block25;
                }
                if ("extractInterface".equals(params.command)) {
                    if (params.commandArguments != null && params.commandArguments.size() == 3) {
                        List<String> list = Arrays.asList(JSONUtility.toModel(params.commandArguments.get(0), String[].class));
                        String interfaceName = JSONUtility.toModel(params.commandArguments.get(1), String.class);
                        MoveHandler.PackageNode packageNode = JSONUtility.toLsp4jModel(params.commandArguments.get(2), MoveHandler.PackageNode.class);
                        if (list == null) return null;
                        if (interfaceName == null) return null;
                        if (packageNode == null) {
                            return null;
                        }
                        Refactoring refactoring = ExtractInterfaceHandler.getExtractInterfaceRefactoring(params.context, list, interfaceName, packageNode);
                        if (refactoring == null) {
                            return null;
                        }
                        Change change = refactoring.createChange((IProgressMonitor)new NullProgressMonitor());
                        if (change == null) {
                            return null;
                        }
                        WorkspaceEdit edit = ChangeUtil.convertToWorkspaceEdit(change);
                        return new RefactorWorkspaceEdit(edit, null);
                    }
                } else if ("changeSignature".equals(params.command) && params.commandArguments != null && params.commandArguments.size() == 8) {
                    String string = JSONUtility.toModel(params.commandArguments.get(0), String.class);
                    Boolean isDelegate = JSONUtility.toModel(params.commandArguments.get(1), Boolean.class);
                    String methodName = JSONUtility.toModel(params.commandArguments.get(2), String.class);
                    String modifier = JSONUtility.toModel(params.commandArguments.get(3), String.class);
                    String returnType = JSONUtility.toModel(params.commandArguments.get(4), String.class);
                    List<ChangeSignatureHandler.MethodParameter> parameters = Arrays.asList(JSONUtility.toModel(params.commandArguments.get(5), ChangeSignatureHandler.MethodParameter[].class));
                    List<ChangeSignatureHandler.MethodException> exceptions = Arrays.asList(JSONUtility.toModel(params.commandArguments.get(6), ChangeSignatureHandler.MethodException[].class));
                    Boolean preview = JSONUtility.toModel(params.commandArguments.get(7), Boolean.class);
                    if (string == null) {
                        return null;
                    }
                    IJavaElement element = JavaCore.create((String)string);
                    IJavaElement iJavaElement = element;
                    if (iJavaElement instanceof IMethod) {
                        WorkspaceEdit edit;
                        void method;
                        IMethod iMethod = (IMethod)iJavaElement;
                        IMethod cfr_ignored_1 = (IMethod)iJavaElement;
                        Refactoring refactoring = ChangeSignatureHandler.getChangeSignatureRefactoring(params.context, (IMethod)method, isDelegate, methodName, modifier, returnType, parameters, exceptions);
                        if (refactoring == null) {
                            return null;
                        }
                        Change change = refactoring.createChange((IProgressMonitor)new NullProgressMonitor());
                        if (change == null) {
                            return null;
                        }
                        if (preview.booleanValue() && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isChangeAnnotationSupport()) {
                            edit = ChangeUtil.convertToWorkspaceEdit(change, ChangeSignatureHandler.CHANGE_SIGNATURE_ANNOTATION_ID);
                            HashMap<String, ChangeAnnotation> annotations = new HashMap<String, ChangeAnnotation>();
                            ChangeAnnotation annotation = new ChangeAnnotation("");
                            annotation.setNeedsConfirmation(Boolean.valueOf(true));
                            annotations.put(ChangeSignatureHandler.CHANGE_SIGNATURE_ANNOTATION_ID, annotation);
                            edit.setChangeAnnotations(annotations);
                            return new RefactorWorkspaceEdit(edit, null);
                        }
                        edit = ChangeUtil.convertToWorkspaceEdit(change);
                        return new RefactorWorkspaceEdit(edit, null);
                    }
                }
            }
            if (proposal == null) {
                return null;
            }
            Change change = proposal.getChange();
            WorkspaceEdit edit = ChangeUtil.convertToWorkspaceEdit(change);
            LinkedProposalModelCore linkedProposalModel = proposal.getLinkedProposalModel();
            Command additionalCommand = null;
            if (linkedProposalModel == null) return new RefactorWorkspaceEdit(edit, additionalCommand);
            LinkedProposalPositionGroupCore linkedPositionGroup = linkedProposalModel.getPositionGroup(positionKey, false);
            if (linkedPositionGroup == null) {
                Iterator iter = linkedProposalModel.getPositionGroupCoreIterator();
                while (iter.hasNext()) {
                    LinkedProposalPositionGroupCore lppgc = (LinkedProposalPositionGroupCore)iter.next();
                    if (!lppgc.getGroupId().startsWith(positionKey)) continue;
                    linkedPositionGroup = lppgc;
                    break;
                }
            }
            if ((highlightPosition = GetRefactorEditHandler.getFirstTrackedNodePositionBySequenceRank(linkedPositionGroup)) == null) return new RefactorWorkspaceEdit(edit, additionalCommand);
            int offset = highlightPosition.getOffset();
            int length = highlightPosition.getLength();
            RenamePosition renamePosition = new RenamePosition(JDTUtils.toURI(unit), offset, length);
            additionalCommand = new Command("Rename", RENAME_COMMAND, Arrays.asList(renamePosition));
            return new RefactorWorkspaceEdit(edit, additionalCommand);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static LinkedProposalPositionGroupCore.PositionInformation getFirstTrackedNodePositionBySequenceRank(LinkedProposalPositionGroupCore positionGroup) {
        if (positionGroup == null) {
            return null;
        }
        LinkedProposalPositionGroupCore.PositionInformation[] positions = positionGroup.getPositions();
        if (positions == null || positions.length == 0) {
            return null;
        }
        LinkedProposalPositionGroupCore.PositionInformation targetPosition = positions[0];
        int i = 1;
        while (i < positions.length) {
            if (positions[i].getSequenceRank() < targetPosition.getSequenceRank()) {
                targetPosition = positions[i];
            }
            ++i;
        }
        return targetPosition;
    }

    private static CUCorrectionProposal getExtractVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, String refactorType, Map formatterOptions) throws CoreException {
        if ("extractVariableAllOccurrence".equals(refactorType)) {
            return RefactorProposalUtility.getExtractVariableAllOccurrenceProposal(params, context, problemsAtLocation, formatterOptions, false);
        }
        if ("extractVariable".equals(refactorType)) {
            return RefactorProposalUtility.getExtractVariableProposal(params, context, problemsAtLocation, formatterOptions, false);
        }
        if ("extractConstant".equals(refactorType)) {
            return RefactorProposalUtility.getExtractConstantProposal(params, context, problemsAtLocation, formatterOptions, false);
        }
        return null;
    }

    private static CUCorrectionProposal getAssignVariableProposal(GetRefactorEditParams params, IInvocationContext context, boolean problemsAtLocation, String refactorType, Map formatterOptions, IProblemLocationCore[] locations) throws CoreException {
        if ("assignVariable".equals(refactorType)) {
            return RefactorProposalUtility.getAssignVariableProposal(params.context, context, problemsAtLocation, formatterOptions, false, locations);
        }
        if ("assignField".equals(refactorType)) {
            return RefactorProposalUtility.getAssignFieldProposal(params.context, context, problemsAtLocation, formatterOptions, false, locations);
        }
        return null;
    }

    private static CUCorrectionProposal getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Map formatterOptions) throws CoreException {
        return RefactorProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, formatterOptions, false);
    }

    public static class GetRefactorEditParams {
        public String command;
        public List<Object> commandArguments;
        public CodeActionParams context;
        public FormattingOptions options;

        public GetRefactorEditParams(String command, CodeActionParams context) {
            this(command, null, context);
        }

        public GetRefactorEditParams(String command, List<Object> commandArguments, CodeActionParams context) {
            this(command, commandArguments, context, null);
        }

        public GetRefactorEditParams(String command, List<Object> commandArguments, CodeActionParams context, FormattingOptions options) {
            this.command = command;
            this.commandArguments = commandArguments;
            this.context = context;
            this.options = options;
        }
    }

    public static class RefactorWorkspaceEdit {
        public WorkspaceEdit edit;
        public Command command;
        public String errorMessage;

        public RefactorWorkspaceEdit(WorkspaceEdit edit) {
            this.edit = edit;
        }

        public RefactorWorkspaceEdit(WorkspaceEdit edit, Command command) {
            this.edit = edit;
            this.command = command;
        }

        public RefactorWorkspaceEdit(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    public static class RenamePosition {
        public String uri;
        public int offset;
        public int length;

        public RenamePosition(String uri, int offset, int length) {
            this.uri = uri;
            this.offset = offset;
            this.length = length;
        }
    }
}

