/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.BodyDeclarationRewrite;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.ls.core.internal.corrections.ASTResolving;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.JavadocTagsSubProcessor;

public class NewVariableCorrectionProposal
extends ASTRewriteCorrectionProposal {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    public static final int PARAM = 3;
    public static final int CONST_FIELD = 4;
    public static final int ENUM_CONST = 5;
    private final int fVariableKind;
    private final SimpleName fOriginalNode;
    private final ITypeBinding fSenderBinding;

    public NewVariableCorrectionProposal(String label, ICompilationUnit cu, int variableKind, SimpleName node, ITypeBinding senderBinding, int relevance) {
        super(label, "quickfix", cu, (ASTRewrite)null, relevance);
        if (senderBinding == null) {
            Assert.isTrue((variableKind == 3 || variableKind == 1 ? 1 : 0) != 0);
        } else {
            Assert.isTrue((boolean)Bindings.isDeclarationBinding((IBinding)senderBinding));
        }
        this.fVariableKind = variableKind;
        this.fOriginalNode = node;
        this.fSenderBinding = senderBinding;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit cu = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.findParentCompilationUnit((ASTNode)this.fOriginalNode);
        switch (this.fVariableKind) {
            case 3: {
                return this.doAddParam(cu);
            }
            case 2: 
            case 4: {
                return this.doAddField(cu);
            }
            case 1: {
                return this.doAddLocal(cu);
            }
            case 5: {
                return this.doAddEnumConst(cu);
            }
        }
        throw new IllegalArgumentException("Unsupported variable kind: " + this.fVariableKind);
    }

    /*
     * WARNING - void declaration
     */
    private ASTRewrite doAddParam(CompilationUnit cu) {
        AST ast = cu.getAST();
        SimpleName node = this.fOriginalNode;
        BodyDeclaration decl = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.findParentBodyDeclaration((ASTNode)node);
        BodyDeclaration bodyDeclaration = decl;
        if (bodyDeclaration instanceof MethodDeclaration) {
            void methodDeclaration;
            MethodDeclaration methodDeclaration2 = (MethodDeclaration)bodyDeclaration;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)bodyDeclaration;
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ImportRewrite imports = this.createImportRewrite((CompilationUnit)decl.getRoot());
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)decl, imports);
            SingleVariableDeclaration newDecl = ast.newSingleVariableDeclaration();
            newDecl.setType(this.evaluateVariableType(ast, imports, (ImportRewrite.ImportRewriteContext)importRewriteContext, (IBinding)methodDeclaration.resolveBinding(), ImportRewrite.TypeLocation.PARAMETER));
            newDecl.setName(ast.newSimpleName(node.getIdentifier()));
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)decl, MethodDeclaration.PARAMETERS_PROPERTY);
            listRewriter.insertLast((ASTNode)newDecl, null);
            Javadoc javadoc = methodDeclaration.getJavadoc();
            if (javadoc != null) {
                HashSet<String> leadingNames = new HashSet<String>();
                for (SingleVariableDeclaration curr : methodDeclaration.parameters()) {
                    leadingNames.add(curr.getName().getIdentifier());
                }
                SimpleName newTagRef = ast.newSimpleName(node.getIdentifier());
                TagElement newTagElement = ast.newTagElement();
                newTagElement.setTagName("@param");
                newTagElement.fragments().add(newTagRef);
                TextElement commentStart = ast.newTextElement();
                newTagElement.fragments().add(commentStart);
                ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTagElement, leadingNames);
            }
            return rewrite;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isAssigned(Statement statement, SimpleName name) {
        Statement statement2 = statement;
        if (statement2 instanceof ExpressionStatement) {
            void exstat;
            ExpressionStatement expressionStatement = (ExpressionStatement)statement2;
            ExpressionStatement cfr_ignored_0 = (ExpressionStatement)statement2;
            Expression expression = exstat.getExpression();
            if (expression instanceof Assignment) {
                void assignment;
                Assignment assignment2 = (Assignment)expression;
                Assignment cfr_ignored_1 = (Assignment)expression;
                return assignment.getLeftHandSide() == name;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isForStatementInit(Statement statement, SimpleName name) {
        Statement statement2 = statement;
        if (statement2 instanceof ForStatement) {
            Object e;
            void forStatement;
            ForStatement forStatement2 = (ForStatement)statement2;
            ForStatement cfr_ignored_0 = (ForStatement)statement2;
            List list = forStatement.initializers();
            if (list.size() == 1 && (e = list.get(0)) instanceof Assignment) {
                void assignment;
                Assignment assignment2 = (Assignment)e;
                Assignment cfr_ignored_1 = (Assignment)e;
                return assignment.getLeftHandSide() == name;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isEnhancedForStatementVariable(Statement statement, SimpleName name) {
        Statement statement2 = statement;
        if (statement2 instanceof EnhancedForStatement) {
            void forStatement;
            EnhancedForStatement enhancedForStatement = (EnhancedForStatement)statement2;
            EnhancedForStatement cfr_ignored_0 = (EnhancedForStatement)statement2;
            SingleVariableDeclaration param = forStatement.getParameter();
            return param.getType() == name.getParent();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private ASTRewrite doAddLocal(CompilationUnit cu) {
        ASTNode aSTNode;
        Block body;
        AST ast = cu.getAST();
        BodyDeclaration decl = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.findParentBodyDeclaration((ASTNode)this.fOriginalNode);
        IMethodBinding targetContext = null;
        BodyDeclaration bodyDeclaration = decl;
        if (bodyDeclaration instanceof MethodDeclaration) {
            void methodDecl;
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)bodyDeclaration;
            body = methodDecl.getBody();
            targetContext = methodDecl.resolveBinding();
        } else {
            void initializer;
            BodyDeclaration bodyDeclaration2 = decl;
            if (!(bodyDeclaration2 instanceof Initializer)) {
                return null;
            }
            Initializer initializer2 = (Initializer)bodyDeclaration2;
            Initializer cfr_ignored_1 = (Initializer)bodyDeclaration2;
            body = initializer.getBody();
            targetContext = Bindings.getBindingOfParentType((ASTNode)decl);
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite imports = this.createImportRewrite((CompilationUnit)decl.getRoot());
        SimpleName[] names = this.getAllReferences(body);
        ASTNode dominant = this.getDominantNode(names);
        Statement dominantStatement = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.findParentStatement((ASTNode)dominant);
        if (ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)dominantStatement.getLocationInParent())) {
            dominantStatement = (Statement)dominantStatement.getParent();
        }
        SimpleName node = names[0];
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)node, imports);
        if (this.isAssigned(dominantStatement, node)) {
            Assignment assignment = (Assignment)node.getParent();
            VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
            VariableDeclarationExpression newDecl = ast.newVariableDeclarationExpression(newDeclFrag);
            newDecl.setType(this.evaluateVariableType(ast, imports, (ImportRewrite.ImportRewriteContext)importRewriteContext, (IBinding)targetContext, ImportRewrite.TypeLocation.LOCAL_VARIABLE));
            Expression placeholder = (Expression)rewrite.createCopyTarget((ASTNode)assignment.getRightHandSide());
            newDeclFrag.setInitializer(placeholder);
            newDeclFrag.setName(ast.newSimpleName(node.getIdentifier()));
            rewrite.replace((ASTNode)assignment, (ASTNode)newDecl, null);
            return rewrite;
        }
        if (dominant != dominantStatement && this.isForStatementInit(dominantStatement, node)) {
            Assignment assignment = (Assignment)node.getParent();
            VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
            VariableDeclarationExpression expression = ast.newVariableDeclarationExpression(frag);
            frag.setName(ast.newSimpleName(node.getIdentifier()));
            Expression placeholder = (Expression)rewrite.createCopyTarget((ASTNode)assignment.getRightHandSide());
            frag.setInitializer(placeholder);
            expression.setType(this.evaluateVariableType(ast, imports, (ImportRewrite.ImportRewriteContext)importRewriteContext, (IBinding)targetContext, ImportRewrite.TypeLocation.LOCAL_VARIABLE));
            rewrite.replace((ASTNode)assignment, (ASTNode)expression, null);
            return rewrite;
        }
        if (dominant != dominantStatement && this.isEnhancedForStatementVariable(dominantStatement, node)) {
            void var25_39;
            EnhancedForStatement enhancedForStatement = (EnhancedForStatement)dominantStatement;
            SingleVariableDeclaration parameter = enhancedForStatement.getParameter();
            Expression expression = enhancedForStatement.getExpression();
            SimpleName newName = (SimpleName)rewrite.createMoveTarget((ASTNode)node);
            rewrite.set((ASTNode)parameter, (StructuralPropertyDescriptor)SingleVariableDeclaration.NAME_PROPERTY, (Object)newName, null);
            ITypeBinding elementBinding = null;
            ITypeBinding typeBinding = expression.resolveTypeBinding();
            if (typeBinding != null) {
                if (typeBinding.isArray()) {
                    elementBinding = typeBinding.getElementType();
                } else {
                    ITypeBinding[] typeArguments;
                    ITypeBinding iTypeBinding = Bindings.findTypeInHierarchy((ITypeBinding)typeBinding, (String)"java.lang.Iterable");
                    if (iTypeBinding != null && (typeArguments = iTypeBinding.getTypeArguments()).length == 1) {
                        elementBinding = typeArguments[0];
                        elementBinding = Bindings.normalizeForDeclarationUse((ITypeBinding)elementBinding, (AST)ast);
                    }
                }
            }
            if (elementBinding != null) {
                Type type = imports.addImport(elementBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.LOCAL_VARIABLE);
            } else {
                SimpleType simpleType = ast.newSimpleType((Name)ast.newSimpleName("Object"));
            }
            rewrite.set((ASTNode)parameter, (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY, (Object)var25_39, null);
            return rewrite;
        }
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        VariableDeclarationStatement newDecl = ast.newVariableDeclarationStatement(newDeclFrag);
        newDeclFrag.setName(ast.newSimpleName(node.getIdentifier()));
        newDecl.setType(this.evaluateVariableType(ast, imports, (ImportRewrite.ImportRewriteContext)importRewriteContext, (IBinding)targetContext, ImportRewrite.TypeLocation.LOCAL_VARIABLE));
        Statement statement = dominantStatement;
        List list = ASTNodes.getContainingList((ASTNode)statement);
        while (list == null && (aSTNode = statement.getParent()) instanceof Statement) {
            void parentStatement;
            Statement cfr_ignored_2 = (Statement)aSTNode;
            Statement cfr_ignored_3 = (Statement)aSTNode;
            statement = parentStatement;
            list = ASTNodes.getContainingList((ASTNode)statement);
        }
        if (list == null) {
            return rewrite;
        }
        ASTNode parent = statement.getParent();
        StructuralPropertyDescriptor childProperty = statement.getLocationInParent();
        if (childProperty.isChildListProperty()) {
            rewrite.getListRewrite(parent, (ChildListPropertyDescriptor)childProperty).insertBefore((ASTNode)newDecl, (ASTNode)statement, null);
            return rewrite;
        }
        return null;
    }

    private SimpleName[] getAllReferences(Block body) {
        SimpleName[] names = LinkedNodeFinder.findByProblems((ASTNode)body, (SimpleName)this.fOriginalNode);
        if (names == null) {
            return new SimpleName[]{this.fOriginalNode};
        }
        if (names.length > 1) {
            Arrays.sort(names, new Comparator<SimpleName>(){

                @Override
                public int compare(SimpleName s1, SimpleName s2) {
                    return s1.getStartPosition() - s2.getStartPosition();
                }
            });
        }
        return names;
    }

    private ASTNode getDominantNode(SimpleName[] names) {
        SimpleName dominator = names[0];
        int i = 1;
        while (i < names.length) {
            SimpleName curr = names[i];
            if (curr != dominator) {
                ASTNode parent = this.getCommonParent((ASTNode)curr, (ASTNode)dominator);
                if (curr.getStartPosition() < dominator.getStartPosition()) {
                    dominator = curr;
                }
                while (dominator.getParent() != parent) {
                    dominator = dominator.getParent();
                }
            }
            ++i;
        }
        int parentKind = dominator.getParent().getNodeType();
        if (parentKind != 8 && parentKind != 24) {
            return dominator.getParent();
        }
        return dominator;
    }

    private ASTNode getCommonParent(ASTNode node1, ASTNode node2) {
        ASTNode parent = node1.getParent();
        while (parent != null && !ASTNodes.isParent((ASTNode)node2, (ASTNode)parent)) {
            parent = parent.getParent();
        }
        return parent;
    }

    private ASTRewrite doAddField(CompilationUnit astRoot) {
        SimpleName node = this.fOriginalNode;
        boolean isInDifferentCU = false;
        ASTNode newTypeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        if (newTypeDecl == null) {
            astRoot = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
            isInDifferentCU = true;
        }
        ImportRewrite imports = this.createImportRewrite(astRoot);
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.findParentBodyDeclaration((ASTNode)node), imports);
        if (newTypeDecl != null) {
            AST ast = newTypeDecl.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
            fragment.setName(ast.newSimpleName(node.getIdentifier()));
            Type type = this.evaluateVariableType(ast, imports, (ImportRewrite.ImportRewriteContext)importRewriteContext, (IBinding)this.fSenderBinding, ImportRewrite.TypeLocation.FIELD);
            FieldDeclaration newDecl = ast.newFieldDeclaration(fragment);
            newDecl.setType(type);
            newDecl.modifiers().addAll(ASTNodeFactory.newModifiers((AST)ast, (int)this.evaluateFieldModifiers(newTypeDecl)));
            if (this.fSenderBinding.isInterface() || this.fVariableKind == 4) {
                fragment.setInitializer(ASTNodeFactory.newDefaultExpression((AST)ast, (Type)type, (int)0));
            }
            ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty((ASTNode)newTypeDecl);
            List decls = ASTNodes.getChildListProperty((ASTNode)newTypeDecl, (ChildListPropertyDescriptor)property);
            int maxOffset = isInDifferentCU ? -1 : node.getStartPosition();
            int insertIndex = this.findFieldInsertIndex(decls, newDecl, maxOffset);
            ListRewrite listRewriter = rewrite.getListRewrite(newTypeDecl, property);
            listRewriter.insertAt((ASTNode)newDecl, insertIndex, null);
            return rewrite;
        }
        return null;
    }

    private int findFieldInsertIndex(List<BodyDeclaration> decls, FieldDeclaration newDecl, int maxOffset) {
        if (maxOffset != -1) {
            int i = decls.size() - 1;
            while (i >= 0) {
                BodyDeclaration curr = decls.get(i);
                if (maxOffset > curr.getStartPosition() + curr.getLength()) {
                    return BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)newDecl, decls.subList(0, i + 1));
                }
                --i;
            }
            return 0;
        }
        return BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)newDecl, decls);
    }

    /*
     * WARNING - void declaration
     */
    private Type evaluateVariableType(AST ast, ImportRewrite imports, ImportRewrite.ImportRewriteContext importRewriteContext, IBinding targetContext, ImportRewrite.TypeLocation location) {
        ITypeBinding binding;
        ASTNode aSTNode = this.fOriginalNode.getParent();
        if (aSTNode instanceof MethodInvocation) {
            ITypeBinding[] bindings;
            void parent;
            MethodInvocation methodInvocation = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            if (parent.getExpression() == this.fOriginalNode && (bindings = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.getQualifierGuess((ASTNode)this.fOriginalNode.getRoot(), (String)parent.getName().getIdentifier(), (List)parent.arguments(), (IBinding)targetContext)).length > 0) {
                return imports.addImport(bindings[0], ast, importRewriteContext, location);
            }
        }
        if ((binding = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.guessBindingForReference((ASTNode)this.fOriginalNode)) != null) {
            if (binding.isWildcardType() && (binding = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.normalizeWildcardType((ITypeBinding)binding, (boolean)this.isVariableAssigned(), (AST)ast)) == null) {
                binding = ast.resolveWellKnownType("java.lang.Object");
            }
            return imports.addImport(binding, ast, importRewriteContext, location);
        }
        Type type = ASTResolving.guessTypeForReference(ast, (ASTNode)this.fOriginalNode);
        if (type != null) {
            return type;
        }
        if (this.fVariableKind == 4) {
            return ast.newSimpleType((Name)ast.newSimpleName("String"));
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    /*
     * WARNING - void declaration
     */
    private boolean isVariableAssigned() {
        ASTNode parent = this.fOriginalNode.getParent();
        ASTNode aSTNode = parent;
        if (aSTNode instanceof Assignment) {
            void assignment;
            Assignment assignment2 = (Assignment)aSTNode;
            Assignment cfr_ignored_0 = (Assignment)aSTNode;
            if (this.fOriginalNode == assignment.getLeftHandSide()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private int evaluateFieldModifiers(ASTNode newTypeDecl) {
        if (this.fSenderBinding.isAnnotation()) {
            return 0;
        }
        if (this.fSenderBinding.isInterface()) {
            FieldDeclaration[] fieldDecls = ((TypeDeclaration)newTypeDecl).getFields();
            if (fieldDecls.length > 0) {
                return fieldDecls[0].getModifiers();
            }
            return 0;
        }
        int modifiers = 0;
        if (this.fVariableKind == 4) {
            modifiers |= 0x18;
        } else {
            ASTNode parent = this.fOriginalNode.getParent();
            ASTNode aSTNode = parent;
            if (aSTNode instanceof QualifiedName) {
                void qualifiedName;
                QualifiedName qualifiedName2 = (QualifiedName)aSTNode;
                QualifiedName cfr_ignored_0 = (QualifiedName)aSTNode;
                IBinding qualifierBinding = qualifiedName.getQualifier().resolveBinding();
                if (qualifierBinding instanceof ITypeBinding) {
                    modifiers |= 8;
                }
            } else if (org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.isInStaticContext((ASTNode)this.fOriginalNode)) {
                modifiers |= 8;
            }
        }
        ASTNode node = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.findParentType((ASTNode)this.fOriginalNode, (boolean)true);
        modifiers = newTypeDecl.equals((Object)node) ? (modifiers |= 2) : (node instanceof AnonymousClassDeclaration ? (modifiers |= 4) : (modifiers |= 1));
        return modifiers;
    }

    private ASTRewrite doAddEnumConst(CompilationUnit astRoot) {
        SimpleName node = this.fOriginalNode;
        ASTNode newTypeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        if (newTypeDecl == null) {
            astRoot = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        if (newTypeDecl != null) {
            AST ast = newTypeDecl.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            EnumConstantDeclaration constDecl = ast.newEnumConstantDeclaration();
            constDecl.setName(ast.newSimpleName(node.getIdentifier()));
            ListRewrite listRewriter = rewrite.getListRewrite(newTypeDecl, EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
            listRewriter.insertLast((ASTNode)constDecl, null);
            return rewrite;
        }
        return null;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }
}

