/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;

public class InnovationContext
implements IInvocationContext {
    private final ICompilationUnit fCompilationUnit;
    private CompilationUnit fASTRoot;
    private NodeFinder fNodeFinder;
    private int fSelectionLength;
    private int fSelectionOffset;

    public InnovationContext(ICompilationUnit compilationUnit, int selectionOffset, int selectionLength) {
        this.fCompilationUnit = compilationUnit;
        this.fSelectionLength = selectionLength;
        this.fSelectionOffset = selectionOffset;
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    @Override
    public int getSelectionLength() {
        return this.fSelectionLength;
    }

    @Override
    public int getSelectionOffset() {
        return this.fSelectionOffset;
    }

    @Override
    public CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.fCompilationUnit, null);
        }
        return this.fASTRoot;
    }

    public void setASTRoot(CompilationUnit root) {
        this.fASTRoot = root;
    }

    @Override
    public ASTNode getCoveringNode() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder((ASTNode)this.getASTRoot(), this.fSelectionOffset, this.fSelectionLength);
        }
        return this.fNodeFinder.getCoveringNode();
    }

    @Override
    public ASTNode getCoveredNode() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder((ASTNode)this.getASTRoot(), this.fSelectionOffset, this.fSelectionLength);
        }
        return this.fNodeFinder.getCoveredNode();
    }
}

