/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.changes;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

abstract class AbstractDeleteChange
extends ResourceChange {
    AbstractDeleteChange() {
    }

    protected abstract Change doDelete(IProgressMonitor var1) throws CoreException;

    public final Change perform(IProgressMonitor pm) throws CoreException {
        try {
            Change undo;
            Change change = undo = this.doDelete(pm);
            return change;
        }
        finally {
            pm.done();
        }
    }

    protected static void saveFileIfNeeded(IFile file, IProgressMonitor pm) throws CoreException {
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (buffer != null && buffer.isDirty() && buffer.isStateValidated() && buffer.isSynchronized()) {
            pm.beginTask("", 2);
            buffer.commit((IProgressMonitor)new SubProgressMonitor(pm, 1), false);
            file.refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        pm.done();
    }
}

