/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalDescriptionProvider;
import org.eclipse.jdt.ls.core.internal.contentassist.GetterSetterCompletionProposal;
import org.eclipse.jdt.ls.core.internal.contentassist.SortTextHelper;
import org.eclipse.jdt.ls.core.internal.contentassist.TypeFilter;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponse;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemLabelDetails;

public final class CompletionProposalRequestor
extends CompletionRequestor {
    private static final Logger logger = Logger.getLogger("java-debug");
    private List<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
    private final ITypeRoot typeRoot;
    private CompletionProposalDescriptionProvider descriptionProvider;
    private CompletionResponse response;
    private boolean isTestCodeExcluded;
    private CompletionContext context;
    public static final Set<CompletionItemKind> SUPPORTED_KINDS = ImmutableSet.of((Object)CompletionItemKind.Constructor, (Object)CompletionItemKind.Class, (Object)CompletionItemKind.Module, (Object)CompletionItemKind.Field, (Object)CompletionItemKind.Keyword, (Object)CompletionItemKind.Reference, (Object[])new CompletionItemKind[]{CompletionItemKind.Variable, CompletionItemKind.Function, CompletionItemKind.Text});

    public CompletionProposalRequestor(ITypeRoot typeRoot, int offset) {
        this.typeRoot = typeRoot;
        this.response = new CompletionResponse();
        this.response.setOffset(offset);
        this.isTestCodeExcluded = typeRoot instanceof IClassFile ? true : !this.isTestSource(typeRoot.getJavaProject(), typeRoot);
        this.setRequireExtendedContext(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTestSource(IJavaProject project, ITypeRoot cu) {
        if (project == null) {
            return true;
        }
        try {
            IClasspathEntry[] resolvedClasspath = project.getResolvedClasspath(true);
            IPath resourcePath = cu.getResource().getFullPath();
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 3 && e.isTest() && e.getPath().isPrefixOf(resourcePath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            logger.log(Level.WARNING, String.format("Failed to judge the cu scope: %s", e.toString()), e);
        }
        return false;
    }

    public void accept(CompletionProposal proposal) {
        if (this.isFiltered(proposal)) {
            return;
        }
        if (!this.isIgnored(proposal.getKind())) {
            if (proposal.getKind() == 11) {
                this.acceptPotentialMethodDeclaration(proposal);
            } else {
                if (proposal.getKind() == 8 && this.typeRoot.getParent() != null && String.valueOf(proposal.getCompletion()).equals(this.typeRoot.getParent().getElementName())) {
                    proposal.setRelevance(proposal.getRelevance() + 1);
                }
                this.proposals.add(proposal);
            }
        }
    }

    public List<CompletionItem> getCompletionItems() {
        this.response.setProposals(this.proposals);
        CompletionResponses.store((CompletionResponse)this.response);
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>(this.proposals.size());
        int i = 0;
        while (i < this.proposals.size()) {
            completionItems.add(this.toCompletionItem(this.proposals.get(i), i));
            ++i;
        }
        return completionItems;
    }

    public CompletionItem toCompletionItem(CompletionProposal proposal, int index) {
        CompletionItem $ = new CompletionItem();
        $.setKind(this.mapKind(proposal.getKind(), proposal.getFlags()));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("rid", String.valueOf(this.response.getId()));
        data.put("pid", String.valueOf(index));
        $.setData(data);
        this.descriptionProvider.updateDescription(proposal, $);
        $.setInsertText(String.valueOf(proposal.getCompletion()));
        this.adjustCompleteItem($);
        $.setSortText(SortTextHelper.computeSortText((CompletionProposal)proposal));
        return $;
    }

    private void adjustCompleteItem(CompletionItem item) {
        CompletionItemKind itemKind = item.getKind();
        if (itemKind == CompletionItemKind.Class || itemKind == CompletionItemKind.Interface || itemKind == CompletionItemKind.Enum) {
            CompletionItemLabelDetails labelDetails = item.getLabelDetails();
            if (labelDetails != null && StringUtils.isNotBlank((CharSequence)labelDetails.getDescription())) {
                item.setLabel(String.valueOf(item.getLabel()) + " - " + labelDetails.getDescription());
            }
        } else if (itemKind == CompletionItemKind.Function) {
            String text;
            CompletionItemLabelDetails labelDetails = item.getLabelDetails();
            if (labelDetails != null && StringUtils.isNotBlank((CharSequence)labelDetails.getDetail())) {
                item.setLabel(String.valueOf(item.getLabel()) + labelDetails.getDetail());
            }
            if (labelDetails != null && StringUtils.isNotBlank((CharSequence)labelDetails.getDescription())) {
                item.setLabel(String.valueOf(item.getLabel()) + " : " + labelDetails.getDescription());
            }
            if (StringUtils.isNotBlank((CharSequence)(text = item.getInsertText())) && !text.endsWith(")")) {
                item.setInsertText(String.valueOf(text) + "()");
            }
        }
    }

    public void acceptContext(CompletionContext context) {
        super.acceptContext(context);
        this.context = context;
        this.response.setContext(context);
        this.descriptionProvider = new CompletionProposalDescriptionProvider(context);
    }

    private CompletionItemKind mapKind(int kind, int flags) {
        switch (kind) {
            case 26: 
            case 27: {
                return CompletionItemKind.Constructor;
            }
            case 1: 
            case 9: {
                if (Flags.isInterface((int)flags)) {
                    return CompletionItemKind.Interface;
                }
                if (Flags.isEnum((int)flags)) {
                    return CompletionItemKind.Enum;
                }
                return CompletionItemKind.Class;
            }
            case 8: 
            case 12: 
            case 21: 
            case 22: 
            case 23: {
                return CompletionItemKind.Module;
            }
            case 2: 
            case 25: {
                if (Flags.isStatic((int)flags) && Flags.isFinal((int)flags)) {
                    return CompletionItemKind.Constant;
                }
                return CompletionItemKind.Field;
            }
            case 3: {
                return CompletionItemKind.Keyword;
            }
            case 4: {
                return CompletionItemKind.Reference;
            }
            case 5: 
            case 10: {
                return CompletionItemKind.Variable;
            }
            case 6: 
            case 7: 
            case 11: 
            case 24: {
                return CompletionItemKind.Function;
            }
        }
        return CompletionItemKind.Text;
    }

    public void setIgnored(int completionProposalKind, boolean ignore) {
        super.setIgnored(completionProposalKind, ignore);
        if (completionProposalKind == 7 && !ignore) {
            this.setRequireExtendedContext(true);
        }
    }

    private void acceptPotentialMethodDeclaration(CompletionProposal proposal) {
        try {
            IJavaElement enclosingElement = null;
            if (this.response.getContext().isExtended()) {
                enclosingElement = this.response.getContext().getEnclosingElement();
            } else if (this.typeRoot != null) {
                enclosingElement = this.typeRoot.getElementAt(proposal.getCompletionLocation() + 1);
            }
            if (enclosingElement == null) {
                return;
            }
            IType type = (IType)enclosingElement.getAncestor(7);
            if (type != null) {
                String prefix = String.valueOf(proposal.getName());
                int completionStart = proposal.getReplaceStart();
                int completionEnd = proposal.getReplaceEnd();
                int relevance = proposal.getRelevance() + 6;
                GetterSetterCompletionProposal.evaluateProposals((IType)type, (String)prefix, (int)completionStart, (int)(completionEnd - completionStart), (int)relevance, this.proposals);
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException((String)"Accept potential method declaration failed for completion ", (Throwable)e);
        }
    }

    public boolean isTestCodeExcluded() {
        return this.isTestCodeExcluded;
    }

    public CompletionContext getContext() {
        return this.context;
    }

    private boolean isFiltered(CompletionProposal proposal) {
        if (this.isIgnored(proposal.getKind())) {
            return true;
        }
        try {
            switch (proposal.getKind()) {
                case 9: 
                case 16: 
                case 26: 
                case 27: {
                    char[] declaringType = this.getDeclaringType(proposal);
                    return declaringType != null && TypeFilter.isFiltered((char[])declaringType);
                }
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private final char[] getDeclaringType(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                char[] declaration = proposal.getDeclarationSignature();
                if (declaration == null) {
                    return "java.lang.Object".toCharArray();
                }
                return Signature.toCharArray((char[])declaration);
            }
            case 8: 
            case 28: 
            case 29: {
                return proposal.getDeclarationSignature();
            }
            case 9: 
            case 16: {
                return Signature.toCharArray((char[])proposal.getSignature());
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 18: 
            case 19: 
            case 20: {
                return null;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }
}

