"use strict";
// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallHierarchyTreeWidget = exports.DEFINITION_ICON_CLASS = exports.DEFINITION_NODE_CLASS = exports.HIERARCHY_TREE_CLASS = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const browser_1 = require("@theia/core/lib/browser");
const label_provider_1 = require("@theia/core/lib/browser/label-provider");
const callhierarchy_tree_1 = require("./callhierarchy-tree");
const callhierarchy_tree_model_1 = require("./callhierarchy-tree-model");
const callhierarchy_1 = require("../callhierarchy");
const callhierarchy_contribution_1 = require("../callhierarchy-contribution");
const uri_1 = require("@theia/core/lib/common/uri");
const vscode_languageserver_protocol_1 = require("@theia/core/shared/vscode-languageserver-protocol");
const browser_2 = require("@theia/editor/lib/browser");
const React = require("@theia/core/shared/react");
exports.HIERARCHY_TREE_CLASS = 'theia-CallHierarchyTree';
exports.DEFINITION_NODE_CLASS = 'theia-CallHierarchyTreeNode';
exports.DEFINITION_ICON_CLASS = 'theia-CallHierarchyTreeNodeIcon';
let CallHierarchyTreeWidget = class CallHierarchyTreeWidget extends browser_1.TreeWidget {
    constructor(props, model, contextMenuRenderer, labelProvider, editorManager) {
        super(props, model, contextMenuRenderer);
        this.props = props;
        this.model = model;
        this.labelProvider = labelProvider;
        this.editorManager = editorManager;
        this.id = callhierarchy_1.CALLHIERARCHY_ID;
        this.title.label = callhierarchy_contribution_1.CALL_HIERARCHY_LABEL;
        this.title.caption = callhierarchy_contribution_1.CALL_HIERARCHY_LABEL;
        this.title.iconClass = (0, browser_1.codicon)('references');
        this.title.closable = true;
        this.addClass(exports.HIERARCHY_TREE_CLASS);
        this.toDispose.push(this.model.onSelectionChanged(selection => {
            const node = selection[0];
            if (node) {
                this.openEditor(node, true);
            }
        }));
        this.toDispose.push(this.model.onOpenNode((node) => {
            this.openEditor(node, false);
        }));
        this.toDispose.push(this.labelProvider.onDidChange(() => this.update()));
    }
    initializeModel(selection, languageId) {
        this.model.initializeCallHierarchy(languageId, selection ? selection.uri : undefined, selection ? selection.range.start : undefined);
    }
    createNodeClassNames(node, props) {
        const classNames = super.createNodeClassNames(node, props);
        if (callhierarchy_tree_1.DefinitionNode.is(node)) {
            classNames.push(exports.DEFINITION_NODE_CLASS);
        }
        return classNames;
    }
    createNodeAttributes(node, props) {
        const elementAttrs = super.createNodeAttributes(node, props);
        return Object.assign({}, elementAttrs);
    }
    renderTree(model) {
        return super.renderTree(model)
            || React.createElement("div", { className: 'theia-widget-noInfo' }, "No callers have been detected.");
    }
    renderCaption(node, props) {
        if (callhierarchy_tree_1.DefinitionNode.is(node)) {
            return this.decorateDefinitionCaption(node.definition);
        }
        if (callhierarchy_tree_1.CallerNode.is(node)) {
            return this.decorateCallerCaption(node.caller);
        }
        return 'caption';
    }
    decorateDefinitionCaption(definition) {
        var _a;
        const containerName = definition.containerName;
        const symbol = definition.symbolName;
        const location = this.labelProvider.getName(new uri_1.default(definition.location.uri));
        const container = (containerName) ? containerName + ' — ' + location : location;
        const isDeprecated = (_a = definition.tags) === null || _a === void 0 ? void 0 : _a.includes(vscode_languageserver_protocol_1.SymbolTag.Deprecated);
        const classNames = ['definitionNode'];
        if (isDeprecated) {
            classNames.push('deprecatedDefinition');
        }
        return React.createElement("div", { className: classNames.join(' ') },
            React.createElement("div", { className: 'symbol-icon ' + this.toIconClass(definition.symbolKind) }),
            React.createElement("div", { className: 'definitionNode-content' },
                React.createElement("span", { className: 'symbol' }, symbol),
                React.createElement("span", { className: 'container' }, container)));
    }
    decorateCallerCaption(caller) {
        var _a;
        const definition = caller.callerDefinition;
        const containerName = definition.containerName;
        const symbol = definition.symbolName;
        const referenceCount = caller.references.length;
        const location = this.labelProvider.getName(new uri_1.default(definition.location.uri));
        const container = (containerName) ? containerName + ' — ' + location : location;
        const isDeprecated = (_a = definition.tags) === null || _a === void 0 ? void 0 : _a.includes(vscode_languageserver_protocol_1.SymbolTag.Deprecated);
        const classNames = ['definitionNode'];
        if (isDeprecated) {
            classNames.push('deprecatedDefinition');
        }
        return React.createElement("div", { className: classNames.join(' ') },
            React.createElement("div", { className: 'symbol-icon ' + this.toIconClass(definition.symbolKind) }),
            React.createElement("div", { className: 'definitionNode-content' },
                React.createElement("span", { className: 'symbol' }, symbol),
                React.createElement("span", { className: 'referenceCount' }, (referenceCount > 1) ? `[${referenceCount}]` : ''),
                React.createElement("span", { className: 'container' }, container)));
    }
    // tslint:disable-next-line:typedef
    toIconClass(symbolKind) {
        switch (symbolKind) {
            case vscode_languageserver_protocol_1.SymbolKind.File: return 'file';
            case vscode_languageserver_protocol_1.SymbolKind.Module: return 'module';
            case vscode_languageserver_protocol_1.SymbolKind.Namespace: return 'namespace';
            case vscode_languageserver_protocol_1.SymbolKind.Package: return 'package';
            case vscode_languageserver_protocol_1.SymbolKind.Class: return 'class';
            case vscode_languageserver_protocol_1.SymbolKind.Method: return 'method';
            case vscode_languageserver_protocol_1.SymbolKind.Property: return 'property';
            case vscode_languageserver_protocol_1.SymbolKind.Field: return 'field';
            case vscode_languageserver_protocol_1.SymbolKind.Constructor: return 'constructor';
            case vscode_languageserver_protocol_1.SymbolKind.Enum: return 'enum';
            case vscode_languageserver_protocol_1.SymbolKind.Interface: return 'interface';
            case vscode_languageserver_protocol_1.SymbolKind.Function: return 'function';
            case vscode_languageserver_protocol_1.SymbolKind.Variable: return 'variable';
            case vscode_languageserver_protocol_1.SymbolKind.Constant: return 'constant';
            case vscode_languageserver_protocol_1.SymbolKind.String: return 'string';
            case vscode_languageserver_protocol_1.SymbolKind.Number: return 'number';
            case vscode_languageserver_protocol_1.SymbolKind.Boolean: return 'boolean';
            case vscode_languageserver_protocol_1.SymbolKind.Array: return 'array';
            default: return 'unknown';
        }
    }
    openEditor(node, keepFocus) {
        if (callhierarchy_tree_1.DefinitionNode.is(node)) {
            const def = node.definition;
            this.doOpenEditor(node.definition.location.uri, def.selectionRange ? def.selectionRange : def.location.range, keepFocus);
        }
        if (callhierarchy_tree_1.CallerNode.is(node)) {
            this.doOpenEditor(node.caller.callerDefinition.location.uri, node.caller.references[0], keepFocus);
        }
    }
    doOpenEditor(uri, range, keepFocus) {
        this.editorManager.open(new uri_1.default(uri), {
            mode: keepFocus ? 'reveal' : 'activate',
            selection: range
        }).then(editorWidget => {
            if (editorWidget.parent instanceof browser_1.DockPanel) {
                editorWidget.parent.selectWidget(editorWidget);
            }
        });
    }
    storeState() {
        const callHierarchyService = this.model.getTree().callHierarchyService;
        if (this.model.root && callHierarchyService) {
            return {
                root: this.deflateForStorage(this.model.root),
                languageId: this.model.languageId,
            };
        }
        else {
            return {};
        }
    }
    restoreState(oldState) {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        if (oldState.root && oldState.languageId) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const root = this.inflateFromStorage(oldState.root);
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            this.model.initializeCallHierarchy(oldState.languageId, root.definition.location.uri, root.definition.location.range.start);
        }
    }
};
CallHierarchyTreeWidget = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(browser_1.TreeProps)),
    __param(1, (0, inversify_1.inject)(callhierarchy_tree_model_1.CallHierarchyTreeModel)),
    __param(2, (0, inversify_1.inject)(browser_1.ContextMenuRenderer)),
    __param(3, (0, inversify_1.inject)(label_provider_1.LabelProvider)),
    __param(4, (0, inversify_1.inject)(browser_2.EditorManager)),
    __metadata("design:paramtypes", [Object, callhierarchy_tree_model_1.CallHierarchyTreeModel,
        browser_1.ContextMenuRenderer,
        label_provider_1.LabelProvider,
        browser_2.EditorManager])
], CallHierarchyTreeWidget);
exports.CallHierarchyTreeWidget = CallHierarchyTreeWidget;
//# sourceMappingURL=callhierarchy-tree-widget.js.map