/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.collect.LinkedHashMultimap;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.plugin.ExtensionRealmCache;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.plugin.PluginRealmCache;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectRealmCache;
import org.apache.maven.project.artifact.MavenMetadataCache;
import org.apache.maven.repository.DelegatingLocalArtifactRepository;
import org.apache.maven.repository.LocalArtifactRepository;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.ILocalRepositoryListener;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.ExtensionReader;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.URLConnectionCaches;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingResult;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.MarkerUtils;
import org.eclipse.m2e.core.internal.project.DependencyResolutionContext;
import org.eclipse.m2e.core.internal.project.IManagedCache;
import org.eclipse.m2e.core.internal.project.ResolverConfigurationIO;
import org.eclipse.m2e.core.internal.project.registry.AbstractMavenDependencyResolver;
import org.eclipse.m2e.core.internal.project.registry.Capability;
import org.eclipse.m2e.core.internal.project.registry.DefaultMavenDependencyResolver;
import org.eclipse.m2e.core.internal.project.registry.EclipseWorkspaceArtifactRepository;
import org.eclipse.m2e.core.internal.project.registry.ILifecycleMapping2;
import org.eclipse.m2e.core.internal.project.registry.IProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.MavenCapability;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.MavenRequiredCapability;
import org.eclipse.m2e.core.internal.project.registry.MutableProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryReader;
import org.eclipse.m2e.core.internal.project.registry.RequiredCapability;
import org.eclipse.m2e.core.internal.project.registry.StaleMutableProjectRegistryException;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectRegistryManager {
    static final Logger log = LoggerFactory.getLogger(ProjectRegistryManager.class);
    static final String ARTIFACT_TYPE_POM = "pom";
    static final String ARTIFACT_TYPE_JAR = "jar";
    public static final String ARTIFACT_TYPE_JAVA_SOURCE = "java-source";
    public static final String ARTIFACT_TYPE_JAVADOC = "javadoc";
    public static final String LIFECYCLE_DEFAULT = "deploy";
    public static final String LIFECYCLE_CLEAN = "clean";
    public static final String LIFECYCLE_SITE = "site";
    public static final List<? extends IPath> METADATA_PATH = Arrays.asList(new Path("pom.xml"), new Path(".settings/org.eclipse.m2e.core.prefs"));
    private static final String CTX_MAVENPROJECTS = String.valueOf(ProjectRegistryManager.class.getName()) + "/mavenProjects";
    private final ProjectRegistry projectRegistry;
    final MavenImpl maven;
    final IMavenMarkerManager markerManager;
    private final ProjectRegistryReader stateReader;
    private final Set<IMavenProjectChangedListener> projectChangeListeners = new LinkedHashSet<IMavenProjectChangedListener>();
    private volatile Thread syncRefreshThread;
    private final Map<MavenProjectFacade, MavenProject> legacyMavenProjects = new IdentityHashMap<MavenProjectFacade, MavenProject>();
    private final Cache<MavenProjectFacade, MavenProject> mavenProjectCache;
    Consumer<Map<MavenProjectFacade, MavenProject>> addContextProjectListener;

    public ProjectRegistryManager(MavenImpl maven, File stateLocationDir, boolean readState, IMavenMarkerManager mavenMarkerManager) {
        this.markerManager = mavenMarkerManager;
        this.maven = maven;
        this.stateReader = new ProjectRegistryReader(stateLocationDir);
        ProjectRegistry state = readState && this.stateReader != null ? this.stateReader.readWorkspaceState(this) : null;
        this.projectRegistry = state != null && state.isValid() ? state : new ProjectRegistry();
        this.mavenProjectCache = this.createProjectCache();
    }

    public MavenProjectFacade create(IProject project, IProgressMonitor monitor) {
        return this.create(this.getPom(project), false, monitor);
    }

    public MavenProjectFacade create(IFile pom, boolean load, IProgressMonitor monitor) {
        if (pom == null) {
            return null;
        }
        MavenProjectFacade projectFacade = this.projectRegistry.getProjectFacade(pom);
        if (projectFacade == null && load) {
            ResolverConfiguration configuration = ResolverConfigurationIO.readResolverConfiguration(pom.getProject());
            MavenExecutionResult executionResult = this.readProjectsWithDependencies(this.projectRegistry, Collections.singletonList(pom), configuration, monitor).values().iterator().next();
            MavenProject mavenProject = executionResult.getProject();
            if (mavenProject != null && mavenProject.getArtifact() != null) {
                projectFacade = new MavenProjectFacade(this, pom, mavenProject, configuration);
            } else {
                List exceptions = executionResult.getExceptions();
                if (exceptions != null) {
                    for (Throwable ex : exceptions) {
                        String msg = "Failed to read Maven project: " + ex.getMessage();
                        log.error(msg, ex);
                    }
                }
            }
        }
        return projectFacade;
    }

    IFile getPom(IProject project) {
        if (project == null || !project.isAccessible()) {
            return null;
        }
        return project.getFile("pom.xml");
    }

    public Set<IFile> remove(MutableProjectRegistry state, Set<IFile> poms, boolean force) {
        LinkedHashSet<IFile> pomSet = new LinkedHashSet<IFile>();
        for (IFile pom : poms) {
            MavenProjectFacade facade = state.getProjectFacade(pom);
            if (!force && facade != null && !facade.isStale()) continue;
            pomSet.addAll(this.remove(state, pom));
        }
        return pomSet;
    }

    public Set<IFile> remove(MutableProjectRegistry state, IFile pom) {
        MavenProjectFacade facade = state.getProjectFacade(pom);
        ArtifactKey mavenProject = facade != null ? facade.getArtifactKey() : null;
        this.flushCaches(state, pom, facade, false);
        if (mavenProject == null) {
            state.removeProject(pom, null);
            return Collections.emptySet();
        }
        LinkedHashSet<IFile> pomSet = new LinkedHashSet<IFile>();
        pomSet.addAll(state.getDependents(MavenCapability.createMavenArtifact(mavenProject), false));
        pomSet.addAll(state.getDependents(MavenCapability.createMavenParent(mavenProject), false));
        state.removeProject(pom, mavenProject);
        pomSet.addAll(this.refreshWorkspaceModules(state, pom, mavenProject));
        pomSet.remove(pom);
        return pomSet;
    }

    public void refresh(MavenUpdateRequest request, IProgressMonitor monitor) throws CoreException {
        this.getMaven().execute(request.isOffline(), request.isForceDependencyUpdate(), (context, pm) -> {
            this.refresh(request.getPomFiles(), monitor);
            return null;
        }, monitor);
    }

    private boolean isForceDependencyUpdate() throws CoreException {
        MavenExecutionContext context = this.maven.getExecutionContext();
        return context != null && context.getExecutionRequest().isUpdateSnapshots();
    }

    public void refresh(Collection<IFile> pomFiles, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProjectRegistryManager_task_refreshing, (int)100);
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        Job.getJobManager().beginRule((ISchedulingRule)rule, (IProgressMonitor)progress);
        try {
            this.syncRefreshThread = Thread.currentThread();
            try (MutableProjectRegistry newState = this.newMutableProjectRegistry();){
                this.refresh(newState, pomFiles, (IProgressMonitor)progress.newChild(95));
                this.applyMutableProjectRegistry(newState, (IProgressMonitor)progress.newChild(5));
            }
        }
        finally {
            this.syncRefreshThread = null;
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
    }

    void refresh(MutableProjectRegistry newState, Collection<IFile> pomFiles, IProgressMonitor monitor) throws CoreException {
        log.debug("Refreshing: {}", pomFiles);
        URLConnectionCaches.assertDisabled();
        DependencyResolutionContext context = new DependencyResolutionContext(pomFiles);
        HashSet installedArtifacts = new HashSet();
        ILocalRepositoryListener listener = (repositoryBasedir, baseArtifact, artifact, artifactFile) -> {
            if (artifactFile == null) {
                return;
            }
            LinkedHashSet<IFile> refresh = new LinkedHashSet<IFile>();
            if (installedArtifacts.add(artifact)) {
                refresh.addAll(newState.getVersionedDependents(MavenCapability.createMavenParent(artifact), true));
                refresh.addAll(newState.getVersionedDependents(MavenCapability.createMavenArtifact(artifact), true));
                refresh.addAll(newState.getVersionedDependents(MavenCapability.createMavenArtifactImport(artifact), true));
            }
            if (installedArtifacts.add(baseArtifact)) {
                refresh.addAll(newState.getVersionedDependents(MavenCapability.createMavenParent(baseArtifact), true));
                refresh.addAll(newState.getVersionedDependents(MavenCapability.createMavenArtifact(baseArtifact), true));
                refresh.addAll(newState.getVersionedDependents(MavenCapability.createMavenArtifactImport(baseArtifact), true));
            }
            if (!refresh.isEmpty()) {
                log.debug("Automatic refresh. artifact={}/{}. projects={}", new Object[]{baseArtifact, artifact, refresh});
                context.forcePomFiles(refresh);
            }
        };
        this.maven.addLocalRepositoryListener(listener);
        try {
            this.refresh(newState, context, monitor);
        }
        finally {
            this.maven.removeLocalRepositoryListener(listener);
        }
        log.debug("Refreshed: {}", pomFiles);
    }

    private void refresh(MutableProjectRegistry newState, DependencyResolutionContext context, IProgressMonitor monitor) throws CoreException {
        HashSet<IFile> allProcessedPoms = new HashSet<IFile>();
        HashSet<IFile> allNewFacades = new HashSet<IFile>();
        HashMap<IFile, Set<Capability>> originalCapabilities = new HashMap<IFile, Set<Capability>>();
        HashMap<IFile, Set<RequiredCapability>> originalRequirements = new HashMap<IFile, Set<RequiredCapability>>();
        while (!context.isEmpty()) {
            ArrayList<IFile> toReadPomFiles = new ArrayList<IFile>();
            while (!context.isEmpty()) {
                MavenCapability mavenArtifactImportCapability;
                Object mavenParentCapability;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (newState.isStale() || this.syncRefreshThread != null && this.syncRefreshThread != Thread.currentThread()) {
                    throw new StaleMutableProjectRegistryException();
                }
                IFile pom2 = context.pop();
                if (allNewFacades.contains(pom2)) continue;
                allProcessedPoms.add(pom2);
                monitor.subTask(NLS.bind((String)Messages.ProjectRegistryManager_task_project, (Object)pom2.getProject().getName()));
                MavenProjectFacade oldFacade = newState.getProjectFacade(pom2);
                context.forcePomFiles(this.flushCaches(newState, pom2, oldFacade, this.isForceDependencyUpdate()));
                if (oldFacade != null) {
                    this.putMavenProject(oldFacade, null);
                }
                if (pom2.isAccessible() && pom2.getProject().hasNature("org.eclipse.m2e.core.maven2Nature")) {
                    toReadPomFiles.add(pom2);
                    if (oldFacade == null) continue;
                    mavenParentCapability = MavenCapability.createMavenParent(oldFacade.getArtifactKey());
                    context.forcePomFiles(newState.getVersionedDependents((Capability)mavenParentCapability, true));
                    mavenArtifactImportCapability = MavenCapability.createMavenArtifactImport(oldFacade.getArtifactKey());
                    context.forcePomFiles(newState.getVersionedDependents(mavenArtifactImportCapability, true));
                    continue;
                }
                newState.setProject(pom2, null);
                if (oldFacade == null) continue;
                mavenParentCapability = MavenCapability.createMavenParent(oldFacade.getArtifactKey());
                context.forcePomFiles(newState.getDependents((Capability)mavenParentCapability, true));
                mavenArtifactImportCapability = MavenCapability.createMavenArtifactImport(oldFacade.getArtifactKey());
                context.forcePomFiles(newState.getVersionedDependents(mavenArtifactImportCapability, true));
            }
            Map<IFile, MavenProjectFacade> newFacades = this.readMavenProjectFacades(toReadPomFiles, newState, monitor);
            for (Map.Entry<IFile, MavenProjectFacade> entry : newFacades.entrySet()) {
                IFile pom3 = entry.getKey();
                MavenProjectFacade newFacade = entry.getValue();
                newState.setProject(pom3, newFacade);
                if (newFacade == null) continue;
                MavenCapability mavenParentCapability = MavenCapability.createMavenParent(newFacade.getArtifactKey());
                context.forcePomFiles(newState.getVersionedDependents(mavenParentCapability, true));
                MavenCapability mavenArtifactImportCapability = MavenCapability.createMavenArtifactImport(newFacade.getArtifactKey());
                context.forcePomFiles(newState.getVersionedDependents(mavenArtifactImportCapability, true));
                LinkedHashSet<Capability> capabilities = new LinkedHashSet<Capability>();
                capabilities.add(mavenParentCapability);
                capabilities.add(MavenCapability.createMavenArtifact(newFacade.getArtifactKey()));
                Set<Capability> oldCapabilities = newState.setCapabilities(pom3, capabilities);
                if (!originalCapabilities.containsKey(pom3)) {
                    originalCapabilities.put(pom3, oldCapabilities);
                }
                MavenProject mavenProject = this.getMavenProject(newFacade);
                LinkedHashSet<RequiredCapability> requirements = new LinkedHashSet<RequiredCapability>();
                DefaultMavenDependencyResolver.addProjectStructureRequirements(requirements, mavenProject);
                Set<RequiredCapability> oldRequirements = newState.setRequirements(pom3, requirements);
                if (originalRequirements.containsKey(pom3)) continue;
                originalRequirements.put(pom3, oldRequirements);
            }
            allNewFacades.addAll(newFacades.keySet());
            ArrayList<IFile> erroneousPoms = new ArrayList<IFile>(toReadPomFiles);
            erroneousPoms.removeAll(newFacades.keySet());
            erroneousPoms.forEach(pom -> newState.setProject((IFile)pom, null));
            if (newFacades.isEmpty()) continue;
            context.forcePomFiles(new HashSet<IFile>(erroneousPoms));
        }
        context.forcePomFiles(allProcessedPoms);
        while (!context.isEmpty()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (newState.isStale() || this.syncRefreshThread != null && this.syncRefreshThread != Thread.currentThread()) {
                throw new StaleMutableProjectRegistryException();
            }
            IFile pom4 = context.pop();
            MavenProjectFacade newFacade = null;
            if (pom4.isAccessible() && pom4.getProject().hasNature("org.eclipse.m2e.core.maven2Nature")) {
                newFacade = newState.getProjectFacade(pom4);
            }
            if (newFacade != null) {
                MavenProject mavenProject = this.getMavenProject(newFacade);
                if (!allProcessedPoms.contains(newFacade.getPom())) {
                    newFacade = this.readMavenProjectFacades(Collections.singletonList(pom4), newState, monitor).get(pom4);
                } else {
                    this.putMavenProject(newFacade, null);
                    newFacade = new MavenProjectFacade(newFacade);
                    this.putMavenProject(newFacade, mavenProject);
                }
            }
            if (newFacade != null) {
                MavenProjectFacade _newFacade = newFacade;
                ResolverConfiguration resolverConfiguration = _newFacade.getResolverConfiguration();
                this.createExecutionContext(newState, pom4, resolverConfiguration).execute(this.getMavenProject(newFacade), (executionContext, pm) -> {
                    this.refreshPhase2(newState, context, originalCapabilities, originalRequirements, pom4, _newFacade, pm);
                    return null;
                }, monitor);
            } else {
                this.refreshPhase2(newState, context, originalCapabilities, originalRequirements, pom4, newFacade, monitor);
            }
            monitor.worked(1);
        }
    }

    void refreshPhase2(MutableProjectRegistry newState, DependencyResolutionContext context, Map<IFile, Set<Capability>> originalCapabilities, Map<IFile, Set<RequiredCapability>> originalRequirements, IFile pom, MavenProjectFacade newFacade, IProgressMonitor monitor) throws CoreException {
        AbstractMavenDependencyResolver resolver22;
        Serializable mavenParentCapability;
        LinkedHashSet<Capability> capabilities = null;
        HashSet requirements = null;
        if (newFacade != null) {
            monitor.subTask(NLS.bind((String)Messages.ProjectRegistryManager_task_project, (Object)newFacade.getProject().getName()));
            this.setupLifecycleMapping(newState, monitor, newFacade);
            capabilities = new LinkedHashSet<Capability>();
            requirements = new LinkedHashSet<RequiredCapability>();
            mavenParentCapability = MavenCapability.createMavenParent(newFacade.getArtifactKey());
            capabilities.add(MavenCapability.createMavenArtifact(newFacade.getArtifactKey()));
            capabilities.add((Capability)mavenParentCapability);
            DefaultMavenDependencyResolver.addProjectStructureRequirements(requirements, this.getMavenProject(newFacade));
            resolver22 = this.getMavenDependencyResolver(newFacade, monitor);
            resolver22.setContextProjectRegistry(newState);
            try {
                resolver22.resolveProjectDependencies(newFacade, capabilities, requirements, monitor);
            }
            finally {
                resolver22.setContextProjectRegistry(null);
            }
            newState.setProject(pom, newFacade);
            newFacade.setMavenProjectArtifacts(this.getMavenProject(newFacade));
        } else if (pom.isAccessible() && pom.getProject().hasNature("org.eclipse.m2e.core.maven2Nature")) {
            try {
                mavenParentCapability = null;
                resolver22 = null;
                try (InputStream is = pom.getContents();){
                    Parent parent;
                    Model model = this.getMaven().readModel(is);
                    if (model != null && model.getParent() != null && (parent = model.getParent()).getGroupId() != null && parent.getArtifactId() != null && parent.getVersion() != null) {
                        ArtifactKey parentKey = new ArtifactKey(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), null);
                        requirements = new HashSet();
                        requirements.add((RequiredCapability)MavenRequiredCapability.createMavenParent(parentKey));
                    }
                }
                catch (Throwable resolver22) {
                    if (mavenParentCapability == null) {
                        mavenParentCapability = resolver22;
                    } else if (mavenParentCapability != resolver22) {
                        mavenParentCapability.addSuppressed(resolver22);
                    }
                    throw mavenParentCapability;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        Set<Capability> oldCapabilities = newState.setCapabilities(pom, capabilities);
        if (originalCapabilities.containsKey(pom)) {
            oldCapabilities = originalCapabilities.get(pom);
        }
        Set<Capability> changedCapabilities = ProjectRegistryManager.diff(oldCapabilities, capabilities);
        boolean versionedCapabilitiesOnly = true;
        for (Capability capability : changedCapabilities) {
            if (!"maven-artifact".equals(capability.getVersionlessKey().getNamespace())) continue;
            versionedCapabilitiesOnly = false;
            break;
        }
        for (Capability capability : changedCapabilities) {
            context.forcePomFiles(versionedCapabilitiesOnly ? newState.getVersionedDependents(capability, true) : newState.getDependents(capability, true));
        }
        Set<RequiredCapability> oldRequirements = newState.setRequirements(pom, requirements);
        if (originalRequirements.containsKey(pom)) {
            oldRequirements = originalRequirements.get(pom);
        }
        if (oldCapabilities != null && ProjectRegistryManager.hasDiff(oldRequirements, requirements)) {
            for (Capability capability : oldCapabilities) {
                context.forcePomFiles(newState.getVersionedDependents(capability, true));
            }
        }
    }

    private void setupLifecycleMapping(MutableProjectRegistry newState, IProgressMonitor monitor, MavenProjectFacade newFacade) throws CoreException {
        LifecycleMappingResult mappingResult = LifecycleMappingFactory.calculateLifecycleMapping(this.getMavenProject(newFacade), newFacade.getMojoExecutions(), newFacade.getResolverConfiguration().getLifecycleMappingId(), monitor);
        newFacade.setLifecycleMappingId(mappingResult.getLifecycleMappingId());
        Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping = mappingResult.getMojoExecutionMapping();
        if (mojoExecutionMapping != null) {
            this.detachMappingSources(mojoExecutionMapping);
        }
        newFacade.setMojoExecutionMapping(mojoExecutionMapping);
        newFacade.setSessionProperty(MavenProjectFacade.PROP_LIFECYCLE_MAPPING, mappingResult.getLifecycleMapping());
        LifecycleMappingFactory.setProjectConfigurators(newFacade, mappingResult);
        this.markerManager.deleteMarkers((IResource)newFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.lifecycleMapping");
        if (mappingResult.hasProblems()) {
            this.markerManager.addErrorMarkers((IResource)newFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.lifecycleMapping", mappingResult.getProblems());
        }
    }

    private void detachMappingSources(Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mapping) {
        for (List<IPluginExecutionMetadata> executions : mapping.values()) {
            if (executions == null) continue;
            ListIterator<IPluginExecutionMetadata> iterator = executions.listIterator();
            while (iterator.hasNext()) {
                PluginExecutionMetadata execution = (PluginExecutionMetadata)iterator.next();
                execution = execution.clone();
                execution.setSource(null);
                iterator.set(execution);
            }
        }
    }

    static <T> Set<T> diff(Set<T> a, Set<T> b) {
        if (a == null || a.isEmpty()) {
            if (b == null || b.isEmpty()) {
                return Collections.emptySet();
            }
            return b;
        }
        if (b == null || b.isEmpty()) {
            return a;
        }
        HashSet<T> result = new HashSet<T>();
        HashSet<T> t = new HashSet<T>(a);
        t.removeAll(b);
        result.addAll(t);
        t = new HashSet<T>(b);
        t.removeAll(a);
        result.addAll(t);
        return result;
    }

    static <T> boolean hasDiff(Set<T> a, Set<T> b) {
        if (a == null || a.isEmpty()) {
            return b != null && !b.isEmpty();
        }
        if (b == null || b.isEmpty()) {
            return true;
        }
        if (a.size() != b.size()) {
            return true;
        }
        Iterator<T> oldIter = a.iterator();
        Iterator<T> iter = b.iterator();
        while (oldIter.hasNext()) {
            T requirement;
            T oldRequirement = oldIter.next();
            if (oldRequirement.equals(requirement = iter.next())) continue;
            return true;
        }
        return false;
    }

    private AbstractMavenDependencyResolver getMavenDependencyResolver(MavenProjectFacade newFacade, IProgressMonitor monitor) {
        ILifecycleMapping lifecycleMapping = LifecycleMappingFactory.getLifecycleMapping(newFacade);
        if (lifecycleMapping instanceof ILifecycleMapping2) {
            AbstractMavenDependencyResolver resolver = ((ILifecycleMapping2)lifecycleMapping).getDependencyResolver(monitor);
            resolver.setManager(this);
            return resolver;
        }
        return new DefaultMavenDependencyResolver(this, this.markerManager);
    }

    private Map<IFile, MavenProjectFacade> readMavenProjectFacades(Collection<IFile> poms, MutableProjectRegistry state, IProgressMonitor monitor) throws CoreException {
        for (IFile pom : poms) {
            this.markerManager.deleteMarkers((IResource)pom, "org.eclipse.m2e.core.maven2Problem.pomloading");
        }
        HashMap<IFile, ResolverConfiguration> resolverConfigurations = new HashMap<IFile, ResolverConfiguration>(poms.size(), 1.0f);
        LinkedHashMultimap groupsToImport = LinkedHashMultimap.create();
        for (IFile pom : poms) {
            if (monitor.isCanceled()) {
                return null;
            }
            ResolverConfiguration resolverConfiguration = ResolverConfigurationIO.readResolverConfiguration(pom.getProject());
            resolverConfigurations.put(pom, resolverConfiguration);
            groupsToImport.put((Object)resolverConfiguration, (Object)pom);
        }
        HashMap<IFile, MavenProjectFacade> result = new HashMap<IFile, MavenProjectFacade>(poms.size(), 1.0f);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)poms.size());
        for (Map.Entry entry : groupsToImport.asMap().entrySet()) {
            ResolverConfiguration resolverConfiguration = (ResolverConfiguration)entry.getKey();
            Collection pomFiles = (Collection)entry.getValue();
            result.putAll(this.execute(state, poms.size() == 1 ? (IFile)pomFiles.iterator().next() : null, resolverConfiguration, (executionContext, pm) -> {
                Map<File, MavenExecutionResult> mavenResults = this.getMaven().readMavenProjects(pomFiles.stream().filter(IResource::isAccessible).map(ProjectRegistryManager::toJavaIoFile).collect(Collectors.toList()), executionContext.newProjectBuildingRequest());
                HashMap<IFile, MavenProjectFacade> facades = new HashMap<IFile, MavenProjectFacade>(mavenResults.size(), 1.0f);
                for (IFile pom : pomFiles) {
                    if (!pom.isAccessible()) continue;
                    MavenExecutionResult mavenResult = mavenResults.get(ProjectRegistryManager.toJavaIoFile(pom));
                    MavenProject mavenProject = mavenResult.getProject();
                    MarkerUtils.addEditorHintMarkers(this.markerManager, pom, mavenProject, "org.eclipse.m2e.core.maven2Problem.pomloading");
                    this.markerManager.addMarkers((IResource)pom, "org.eclipse.m2e.core.maven2Problem.pomloading", mavenResult);
                    if (mavenProject == null || mavenProject.getArtifact() == null) continue;
                    MavenProjectFacade mavenProjectFacade = new MavenProjectFacade(this, pom, mavenProject, resolverConfiguration);
                    this.putMavenProject(mavenProjectFacade, mavenProject);
                    facades.put(pom, mavenProjectFacade);
                }
                return facades;
            }, (IProgressMonitor)subMonitor.split(pomFiles.size())));
        }
        return result;
    }

    Map<String, List<MojoExecution>> calculateExecutionPlans(IFile pom, MavenProject mavenProject, IProgressMonitor monitor) {
        LinkedHashMap<String, List<MojoExecution>> executionPlans = new LinkedHashMap<String, List<MojoExecution>>();
        executionPlans.put(LIFECYCLE_CLEAN, this.calculateExecutionPlan(pom, mavenProject, LIFECYCLE_CLEAN, monitor));
        executionPlans.put(LIFECYCLE_DEFAULT, this.calculateExecutionPlan(pom, mavenProject, LIFECYCLE_DEFAULT, monitor));
        executionPlans.put(LIFECYCLE_SITE, this.calculateExecutionPlan(pom, mavenProject, LIFECYCLE_SITE, monitor));
        return executionPlans;
    }

    private List<MojoExecution> calculateExecutionPlan(IFile pom, MavenProject mavenProject, String lifecycle, IProgressMonitor monitor) {
        List<MojoExecution> mojoExecutions = null;
        try {
            MavenExecutionPlan executionPlan = this.maven.calculateExecutionPlan(mavenProject, Arrays.asList(lifecycle), false, monitor);
            return executionPlan.getMojoExecutions();
        }
        catch (CoreException e) {
            this.markerManager.addErrorMarkers((IResource)pom, "org.eclipse.m2e.core.maven2Problem.pomloading", (Exception)((Object)e));
            return mojoExecutions;
        }
    }

    public IFile getModulePom(IFile pom, String moduleName) {
        return pom.getParent().getFile(new Path(moduleName).append("pom.xml"));
    }

    private Set<IFile> refreshWorkspaceModules(MutableProjectRegistry state, IFile pom, ArtifactKey mavenProject) {
        if (mavenProject == null) {
            return Collections.emptySet();
        }
        return state.removeWorkspaceModules(pom, mavenProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMavenProjectChangedListener(IMavenProjectChangedListener listener) {
        Set<IMavenProjectChangedListener> set = this.projectChangeListeners;
        synchronized (set) {
            this.projectChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMavenProjectChangedListener(IMavenProjectChangedListener listener) {
        if (listener == null) {
            return;
        }
        Set<IMavenProjectChangedListener> set = this.projectChangeListeners;
        synchronized (set) {
            this.projectChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyProjectChangeListeners(List<MavenProjectChangedEvent> events, IProgressMonitor monitor) {
        if (events.size() > 0) {
            MavenProjectChangedEvent[] eventsArray = events.toArray(new MavenProjectChangedEvent[events.size()]);
            ArrayList<IMavenProjectChangedListener> listeners = new ArrayList<IMavenProjectChangedListener>();
            Set<IMavenProjectChangedListener> set = this.projectChangeListeners;
            synchronized (set) {
                listeners.addAll(this.projectChangeListeners);
            }
            listeners.addAll(ExtensionReader.readProjectChangedEventListenerExtentions());
            for (IMavenProjectChangedListener listener : listeners) {
                listener.mavenProjectChanged(eventsArray, monitor);
            }
        }
    }

    public MavenProjectFacade getMavenProject(String groupId, String artifactId, String version) {
        return this.projectRegistry.getProjectFacade(groupId, artifactId, version);
    }

    MavenProject readProjectWithDependencies(IFile pomFile, ResolverConfiguration resolverConfiguration, IProgressMonitor monitor) throws CoreException {
        Map<File, MavenExecutionResult> results = this.readProjectsWithDependencies(this.projectRegistry, Collections.singletonList(pomFile), resolverConfiguration, monitor);
        if (results.size() != 1) {
            throw new IllegalStateException("Results should contain one entry.");
        }
        MavenExecutionResult result = results.values().iterator().next();
        MavenProject mavenProject = result.getProject();
        if (mavenProject != null && !ProjectRegistryManager.hasError(result)) {
            return mavenProject;
        }
        MultiStatus status = new MultiStatus("org.eclipse.m2e.core", 0, Messages.MavenProjectFacade_error, null);
        List exceptions = result.getExceptions();
        for (Throwable e : exceptions) {
            status.add((IStatus)new Status(4, "org.eclipse.m2e.core", 0, e.getMessage(), e));
        }
        throw new CoreException((IStatus)status);
    }

    private static boolean hasError(MavenExecutionResult mavenExecutionResult) {
        if (!mavenExecutionResult.getExceptions().stream().anyMatch(ex -> !(ex instanceof ProjectBuildingException))) {
            if (!mavenExecutionResult.getExceptions().stream().map(ProjectBuildingException.class::cast).flatMap(ex -> ex.getResults().stream()).flatMap(result -> result.getProblems().stream()).map(ModelProblem::getSeverity).anyMatch(severity -> severity != ModelProblem.Severity.WARNING)) {
                return false;
            }
        }
        return true;
    }

    Map<File, MavenExecutionResult> readProjectsWithDependencies(IProjectRegistry state, Collection<IFile> pomFiles, ResolverConfiguration resolverConfiguration, IProgressMonitor monitor) {
        try {
            return this.execute(state, pomFiles.size() == 1 ? pomFiles.iterator().next() : null, resolverConfiguration, (context, aMonitor) -> {
                ProjectBuildingRequest configuration = context.newProjectBuildingRequest();
                configuration.setResolveDependencies(true);
                return this.getMaven().readMavenProjects(pomFiles.stream().map(ProjectRegistryManager::toJavaIoFile).filter(Objects::nonNull).collect(Collectors.toList()), configuration);
            }, monitor);
        }
        catch (CoreException ex) {
            DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
            result.addException((Throwable)ex);
            return pomFiles.stream().filter(IResource::isAccessible).map(ProjectRegistryManager::toJavaIoFile).filter(Objects::nonNull).collect(HashMap::new, (arg_0, arg_1) -> ProjectRegistryManager.lambda$20((MavenExecutionResult)result, arg_0, arg_1), (container, toFold) -> container.putAll(toFold));
        }
    }

    public IMavenProjectFacade[] getProjects() {
        return this.projectRegistry.getProjects();
    }

    public IMavenProjectFacade getProject(IProject project) {
        return this.projectRegistry.getProjectFacade(this.getPom(project));
    }

    public MavenExecutionRequest createExecutionRequest(IFile pom, ResolverConfiguration resolverConfiguration, IProgressMonitor monitor) throws CoreException {
        MavenExecutionRequest request = this.getMaven().createExecutionRequest(monitor);
        this.configureExecutionRequest(request, this.projectRegistry, pom, resolverConfiguration);
        MavenExecutionContext.populateSystemProperties(request);
        return request;
    }

    MavenExecutionRequest configureExecutionRequest(MavenExecutionRequest request, IProjectRegistry state, IFile pom, ResolverConfiguration resolverConfiguration) throws CoreException {
        if (pom != null) {
            request.setPom(ProjectRegistryManager.toJavaIoFile(pom));
        }
        request.addActiveProfiles(resolverConfiguration.getActiveProfileList());
        request.addInactiveProfiles(resolverConfiguration.getInactiveProfileList());
        Properties p = request.getUserProperties();
        Properties addProperties = resolverConfiguration.getProperties();
        if (addProperties != null) {
            if (p == null) {
                p = new Properties();
            }
            p.putAll((Map<?, ?>)addProperties);
        }
        request.setLocalRepository(this.getMaven().getLocalRepository());
        request.setWorkspaceReader((WorkspaceReader)this.getWorkspaceReader(state, pom, resolverConfiguration));
        return request;
    }

    private EclipseWorkspaceArtifactRepository getWorkspaceReader(IProjectRegistry state, IFile pom, ResolverConfiguration resolverConfiguration) {
        Context context = new Context(state, resolverConfiguration, pom);
        EclipseWorkspaceArtifactRepository workspaceReader = new EclipseWorkspaceArtifactRepository(context);
        return workspaceReader;
    }

    public MavenArtifactRepository getWorkspaceLocalRepository() throws CoreException {
        ResolverConfiguration resolverConfiguration = new ResolverConfiguration();
        resolverConfiguration.setResolveWorkspaceProjects(true);
        EclipseWorkspaceArtifactRepository workspaceReader = this.getWorkspaceReader(this.projectRegistry, null, resolverConfiguration);
        DelegatingLocalArtifactRepository localRepo = new DelegatingLocalArtifactRepository(this.getMaven().getLocalRepository());
        localRepo.setIdeWorkspace((LocalArtifactRepository)workspaceReader);
        return localRepo;
    }

    MutableProjectRegistry newMutableProjectRegistry() {
        return new MutableProjectRegistry(this.projectRegistry);
    }

    void applyMutableProjectRegistry(MutableProjectRegistry newState, IProgressMonitor monitor) throws CoreException {
        MavenProjectFacade[] mavenProjectFacadeArray = newState.getProjects();
        int n = mavenProjectFacadeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenProjectFacade facade = mavenProjectFacadeArray[n2];
            MavenProject mavenProject = this.getMavenProject(facade);
            if (mavenProject != null) {
                this.getMaven().detachFromSession(mavenProject);
            }
            ++n2;
        }
        List<MavenProjectChangedEvent> events = this.projectRegistry.apply(newState);
        this.notifyProjectChangeListeners(events, monitor);
    }

    public void writeWorkspaceState() {
        if (this.stateReader != null && this.projectRegistry != null) {
            this.stateReader.writeWorkspaceState(this.projectRegistry);
        }
    }

    IMaven getMaven() {
        return this.maven;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MojoExecution setupMojoExecution(MavenProjectFacade projectFacade, MojoExecution mojoExecution, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = null;
        if (MavenExecutionContext.getThreadContext() == null) {
            Map<MavenProjectFacade, MavenProject> map = this.legacyMavenProjects;
            synchronized (map) {
                mavenProject = this.legacyMavenProjects.get(projectFacade);
                if (mavenProject == null) {
                    mavenProject = this.getMavenProject(projectFacade, monitor);
                    this.legacyMavenProjects.put(projectFacade, mavenProject);
                }
            }
        }
        if (mavenProject == null) {
            mavenProject = this.getMavenProject(projectFacade, monitor);
        }
        return this.maven.setupMojoExecution(mavenProject, mojoExecution, monitor);
    }

    private <V> V execute(IProjectRegistry state, IFile pom, ResolverConfiguration resolverConfiguration, ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        return this.createExecutionContext(state, pom, resolverConfiguration).execute(callable, monitor);
    }

    private MavenExecutionContext createExecutionContext(IProjectRegistry state, IFile pom, ResolverConfiguration resolverConfiguration) throws CoreException {
        MavenExecutionContext context = this.maven.createExecutionContext();
        this.configureExecutionRequest(context.getExecutionRequest(), state, pom, resolverConfiguration);
        return context;
    }

    public MavenExecutionContext createExecutionContext(IFile pom, ResolverConfiguration resolverConfiguration) throws CoreException {
        return this.createExecutionContext(this.projectRegistry, pom, resolverConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MavenProject getMavenProject(MavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject;
        Map<MavenProjectFacade, MavenProject> map = this.legacyMavenProjects;
        synchronized (map) {
            mavenProject = this.legacyMavenProjects.get(facade);
        }
        if (mavenProject != null) {
            return mavenProject;
        }
        Map<MavenProjectFacade, MavenProject> mavenProjects = this.getContextProjects();
        mavenProject = mavenProjects.get(facade);
        if (mavenProject == null) {
            try {
                mavenProject = (MavenProject)this.mavenProjectCache.get((Object)facade, () -> this.readProjectWithDependencies(facade.getPom(), facade.getResolverConfiguration(), monitor));
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof CoreException) {
                    throw (CoreException)cause;
                }
                throw new RuntimeException(cause);
            }
            mavenProjects.put(facade, mavenProject);
        }
        return mavenProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MavenProject getMavenProject(MavenProjectFacade facade) {
        MavenProject mavenProject;
        Map<MavenProjectFacade, MavenProject> map = this.legacyMavenProjects;
        synchronized (map) {
            mavenProject = this.legacyMavenProjects.get(facade);
        }
        if (mavenProject == null && (mavenProject = (MavenProject)this.mavenProjectCache.getIfPresent((Object)facade)) != null) {
            this.putMavenProject(facade, mavenProject);
        }
        if (mavenProject == null) {
            mavenProject = this.getContextProjects().get(facade);
        }
        return mavenProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMavenProject(MavenProjectFacade facade, MavenProject mavenProject) {
        Map<MavenProjectFacade, MavenProject> mavenProjects = this.getContextProjects();
        if (mavenProject != null) {
            mavenProjects.put(facade, mavenProject);
            if (this.addContextProjectListener != null) {
                this.addContextProjectListener.accept(mavenProjects);
            }
        } else {
            mavenProjects.remove(facade);
            Map<MavenProjectFacade, MavenProject> map = this.legacyMavenProjects;
            synchronized (map) {
                this.legacyMavenProjects.remove(facade);
            }
        }
    }

    Map<MavenProjectFacade, MavenProject> getContextProjects() {
        IdentityHashMap projects = null;
        MavenExecutionContext context = MavenExecutionContext.getThreadContext(false);
        if (context != null && (projects = (IdentityHashMap)context.getValue(CTX_MAVENPROJECTS)) == null) {
            projects = new IdentityHashMap();
            context.setValue(CTX_MAVENPROJECTS, projects);
        }
        if (projects == null) {
            projects = new IdentityHashMap();
        }
        return projects;
    }

    private Cache<MavenProjectFacade, MavenProject> createProjectCache() {
        RemovalListener removalListener = notification -> {
            if (notification.getCause() == RemovalCause.SIZE || notification.getCause() == RemovalCause.REPLACED) {
                MavenProjectFacade facade = (MavenProjectFacade)notification.getKey();
                MavenProject mavenProject = (MavenProject)notification.getValue();
                Map<MavenProjectFacade, MavenProject> contextProjects = this.getContextProjects();
                if (contextProjects != null && !contextProjects.containsKey(facade)) {
                    this.flushMavenCaches(facade.getPomFile(), facade.getArtifactKey(), mavenProject, false);
                }
            }
        };
        return CacheBuilder.newBuilder().maximumSize(5L).removalListener(removalListener).build();
    }

    private Set<IFile> flushCaches(MutableProjectRegistry newState, IFile pom, MavenProjectFacade facade, boolean forceDependencyUpdate) {
        ArtifactKey key = null;
        MavenProject project = null;
        if (facade != null) {
            key = facade.getArtifactKey();
            project = this.getMavenProject(facade);
            this.mavenProjectCache.invalidate((Object)facade);
            HashSet<IFile> ifiles = new HashSet<IFile>();
            for (File file : this.flushMavenCaches(facade.getPomFile(), key, project, forceDependencyUpdate)) {
                MavenProjectFacade affected = this.projectRegistry.getProjectFacade(file);
                if (affected == null) continue;
                ifiles.add(affected.getPom());
            }
            return ifiles;
        }
        return Collections.emptySet();
    }

    Set<File> flushMavenCaches(File pom, ArtifactKey key, MavenProject project, boolean force) {
        HashSet<File> affected = new HashSet<File>();
        affected.addAll(this.flushMavenCache(ProjectRealmCache.class, pom, key, force));
        affected.addAll(this.flushMavenCache(ExtensionRealmCache.class, pom, key, force));
        affected.addAll(this.flushMavenCache(PluginRealmCache.class, pom, key, force));
        affected.addAll(this.flushMavenCache(MavenMetadataCache.class, pom, key, force));
        affected.addAll(this.flushMavenCache(PluginArtifactsCache.class, pom, key, force));
        return affected;
    }

    private Set<File> flushMavenCache(Class<?> clazz, File pom, ArtifactKey key, boolean force) {
        try {
            IManagedCache cache = (IManagedCache)this.maven.getPlexusContainer().lookup(clazz);
            return cache.removeProject(pom, key, force);
        }
        catch (ComponentLookupException componentLookupException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    static File toJavaIoFile(IFile file) {
        IPath path = file.getLocation();
        if (path == null) {
            return ProjectRegistryManager.getRemoteFile(file);
        }
        return path.toFile();
    }

    private static File getRemoteFile(IFile file) {
        try {
            URI fileLocation = file.getLocationURI();
            IFileStore fileStore = EFS.getStore((URI)fileLocation);
            return fileStore.toLocalFile(4096, null);
        }
        catch (CoreException ex) {
            log.warn("Failed to create local file representation of " + file);
            return null;
        }
    }

    private static /* synthetic */ void lambda$20(MavenExecutionResult mavenExecutionResult, HashMap map, File pomFile) {
        MavenExecutionResult mavenExecutionResult2 = map.put(pomFile, mavenExecutionResult);
    }

    static class Context {
        final IProjectRegistry state;
        final ResolverConfiguration resolverConfiguration;
        final IFile pom;

        Context(IProjectRegistry state, ResolverConfiguration resolverConfiguration, IFile pom) {
            this.state = state;
            this.resolverConfiguration = resolverConfiguration;
            this.pom = pom;
        }
    }
}

