/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import org.eclipse.core.internal.refresh.MonitorManager;
import org.eclipse.core.internal.refresh.PollingMonitor;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class InternalRefreshProvider {
    protected IRefreshMonitor createPollingMonitor(IResource resource) {
        Workspace workspace = (Workspace)resource.getWorkspace();
        RefreshManager refreshManager = workspace.getRefreshManager();
        MonitorManager monitors = refreshManager.monitors;
        PollingMonitor pollingMonitor = monitors.pollMonitor;
        pollingMonitor.monitor(resource);
        return pollingMonitor;
    }

    public void resetMonitors(IResource resource, IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2);
        MonitorManager manager = ((Workspace)resource.getWorkspace()).getRefreshManager().monitors;
        manager.unmonitor(resource, (IProgressMonitor)subMonitor.split(1));
        manager.monitor(resource, (IProgressMonitor)subMonitor.split(1));
    }
}

