/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.commands.BuildPathCommand;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenameSupport;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringTickProvider;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.internal.core.refactoring.NotCancelableProgressMonitor;

public class FileEventHandler {
    public static WorkspaceEdit handleRenameFiles(FileRenameParams params, IProgressMonitor monitor) {
        if (params.files == null || params.files.isEmpty()) {
            return null;
        }
        FileRenameEvent[] files = (FileRenameEvent[])params.files.stream().filter(event -> FileEventHandler.isFileNameRenameEvent(event)).toArray(FileRenameEvent[]::new);
        if (files.length == 0) {
            return null;
        }
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Computing rename updates...", (int)(100 * files.length));
        WorkspaceEdit root = null;
        FileRenameEvent[] fileRenameEventArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                FileRenameEvent event2 = fileRenameEventArray[n2];
                String oldUri = event2.oldUri;
                String newUri = event2.newUri;
                ICompilationUnit unit = JDTUtils.resolveCompilationUnit(newUri);
                SubMonitor splitedMonitor = submonitor.split(100);
                try {
                    try {
                        if (unit != null && !unit.exists()) {
                            final ICompilationUnit[] units = new ICompilationUnit[]{unit};
                            try {
                                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                                    public void run(IProgressMonitor monitor) throws CoreException {
                                        units[0] = FileEventHandler.createCompilationUnit(units[0]);
                                    }
                                }, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException e) {
                                JavaLanguageServerPlugin.logException(e.getMessage(), e);
                            }
                            unit = units[0];
                        }
                        if (unit != null) {
                            String oldPrimaryType = FileEventHandler.getPrimaryTypeName(oldUri);
                            String newPrimaryType = FileEventHandler.getPrimaryTypeName(newUri);
                            if (!unit.getType(newPrimaryType).exists() && unit.getType(oldPrimaryType).exists()) {
                                WorkspaceEdit edit = FileEventHandler.getRenameEdit((IJavaElement)unit.getType(oldPrimaryType), newPrimaryType, (IProgressMonitor)splitedMonitor);
                                root = ChangeUtil.mergeChanges(root, edit, true);
                            }
                        }
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.logException("Computing the rename edit: ", e);
                        splitedMonitor.done();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    splitedMonitor.done();
                    throw throwable;
                }
                splitedMonitor.done();
            }
            ++n2;
        }
        submonitor.done();
        return root;
    }

    public static WorkspaceEdit handleWillRenameFiles(FileRenameParams params, IProgressMonitor monitor) {
        if (params.files == null || params.files.isEmpty()) {
            return null;
        }
        FileRenameEvent[] renamefolders = (FileRenameEvent[])params.files.stream().filter(event -> FileEventHandler.isFolderRenameEvent(event)).toArray(FileRenameEvent[]::new);
        if (renamefolders.length == 0) {
            return null;
        }
        BuildPathCommand.SourcePath[] sourcePaths = FileEventHandler.getSourcePaths();
        if (sourcePaths == null || sourcePaths.length == 0) {
            return null;
        }
        return FileEventHandler.computePackageRenameEdit(renamefolders, sourcePaths, monitor);
    }

    private static WorkspaceEdit computePackageRenameEdit(FileRenameEvent[] renameEvents, BuildPathCommand.SourcePath[] sourcePaths, IProgressMonitor monitor) {
        WorkspaceEdit[] root = new WorkspaceEdit[1];
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Computing package rename updates...", (int)(100 * renameEvents.length));
        FileRenameEvent[] fileRenameEventArray = renameEvents;
        int n = renameEvents.length;
        int n2 = 0;
        while (n2 < n) {
            FileRenameEvent event = fileRenameEventArray[n2];
            IPath oldLocation = ResourceUtils.filePathFromURI(event.oldUri);
            IPath newLocation = ResourceUtils.filePathFromURI(event.newUri);
            BuildPathCommand.SourcePath[] sourcePathArray = sourcePaths;
            int n3 = sourcePaths.length;
            int n4 = 0;
            while (n4 < n3) {
                BuildPathCommand.SourcePath sourcePath = sourcePathArray[n4];
                IPath sourceLocation = Path.fromOSString((String)sourcePath.path);
                IPath sourceEntry = Path.fromOSString((String)sourcePath.classpathEntry);
                if (sourceLocation.isPrefixOf(oldLocation)) {
                    IPackageFragmentRoot packageRoot;
                    SubMonitor renameMonitor;
                    block12: {
                        IJavaProject javaProject;
                        block11: {
                            renameMonitor = submonitor.split(100);
                            javaProject = ProjectUtils.getJavaProject(sourcePath.projectName);
                            if (javaProject != null) break block11;
                            renameMonitor.done();
                            break;
                        }
                        packageRoot = javaProject.findPackageFragmentRoot(sourceEntry);
                        if (packageRoot != null) break block12;
                        renameMonitor.done();
                        break;
                    }
                    try {
                        try {
                            String oldPackageName = String.join((CharSequence)".", oldLocation.makeRelativeTo(sourceLocation).segments());
                            String newPackageName = String.join((CharSequence)".", newLocation.makeRelativeTo(sourceLocation).segments());
                            IPackageFragment oldPackageFragment = packageRoot.getPackageFragment(oldPackageName);
                            if (oldPackageFragment != null && !oldPackageFragment.isDefaultPackage() && oldPackageFragment.getResource() != null) {
                                oldPackageFragment.getResource().refreshLocal(2, null);
                                if (oldPackageFragment.exists()) {
                                    ResourcesPlugin.getWorkspace().run(pm -> {
                                        WorkspaceEdit edit = FileEventHandler.getRenameEdit((IJavaElement)oldPackageFragment, newPackageName, pm);
                                        workspaceEditArray[0] = ChangeUtil.mergeChanges(root[0], edit, true);
                                    }, oldPackageFragment.getSchedulingRule(), 0, (IProgressMonitor)renameMonitor);
                                }
                            }
                        }
                        catch (CoreException e) {
                            JavaLanguageServerPlugin.logException("Failed to compute the package rename update", e);
                            renameMonitor.done();
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        renameMonitor.done();
                        throw throwable;
                    }
                    renameMonitor.done();
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        submonitor.done();
        return ChangeUtil.hasChanges(root[0]) ? root[0] : null;
    }

    private static BuildPathCommand.SourcePath[] getSourcePaths() {
        BuildPathCommand.SourcePath[] sourcePaths = new BuildPathCommand.SourcePath[]{};
        BuildPathCommand.ListCommandResult result = (BuildPathCommand.ListCommandResult)BuildPathCommand.listSourcePaths();
        if (result.status && result.data != null && result.data.length > 0) {
            sourcePaths = result.data;
        }
        Arrays.sort(sourcePaths, (a, b) -> b.path.length() - a.path.length());
        return sourcePaths;
    }

    private static boolean isFileNameRenameEvent(FileRenameEvent event) {
        IPath oldPath = ResourceUtils.filePathFromURI(event.oldUri);
        IPath newPath = ResourceUtils.filePathFromURI(event.newUri);
        return newPath.toFile().isFile() && oldPath.lastSegment().endsWith(".java") && newPath.lastSegment().endsWith(".java") && Objects.equals(oldPath.removeLastSegments(1), newPath.removeLastSegments(1));
    }

    private static boolean isFolderRenameEvent(FileRenameEvent event) {
        IPath oldPath = ResourceUtils.filePathFromURI(event.oldUri);
        IPath newPath = ResourceUtils.filePathFromURI(event.newUri);
        return (oldPath.toFile().isDirectory() || newPath.toFile().isDirectory()) && Objects.equals(oldPath.removeLastSegments(1), newPath.removeLastSegments(1));
    }

    private static String getPrimaryTypeName(String uri) {
        String fileName = ResourceUtils.filePathFromURI(uri).lastSegment();
        int idx = fileName.lastIndexOf(".");
        if (idx >= 0) {
            return fileName.substring(0, idx);
        }
        return fileName;
    }

    private static ICompilationUnit createCompilationUnit(ICompilationUnit unit) {
        try {
            IJavaElement parent;
            unit.getResource().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            if (unit.getResource().exists() && (parent = unit.getParent()) instanceof IPackageFragment) {
                IPackageFragment pkg = (IPackageFragment)parent;
                if (JavaModelManager.determineIfOnClasspath((IResource)unit.getResource(), (IJavaProject)unit.getJavaProject()) != null) {
                    unit = pkg.createCompilationUnit(unit.getElementName(), unit.getSource(), true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return unit;
    }

    private static WorkspaceEdit getRenameEdit(IJavaElement targetElement, String newName, IProgressMonitor monitor) throws CoreException {
        RenameSupport renameSupport = RenameSupport.create(targetElement, newName, 1);
        if (renameSupport == null) {
            return null;
        }
        if (targetElement instanceof IPackageFragment) {
            ((RenamePackageProcessor)renameSupport.getJavaRenameProcessor()).setRenameSubpackages(true);
        }
        RenameRefactoring renameRefactoring = renameSupport.getRenameRefactoring();
        RefactoringTickProvider rtp = renameRefactoring.getRefactoringTickProvider();
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating rename changes...", (int)rtp.getAllTicks());
        CheckConditionsOperation checkConditionOperation = new CheckConditionsOperation((Refactoring)renameRefactoring, 6);
        checkConditionOperation.run((IProgressMonitor)submonitor.split(rtp.getCheckAllConditionsTicks()));
        if (checkConditionOperation.getStatus().getSeverity() >= 4) {
            JavaLanguageServerPlugin.logError(checkConditionOperation.getStatus().getMessageMatchingSeverity(3));
        }
        Change change = renameRefactoring.createChange((IProgressMonitor)submonitor.split(rtp.getCreateChangeTicks()));
        change.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)submonitor.split(rtp.getInitializeChangeTicks())));
        return ChangeUtil.convertToWorkspaceEdit(change);
    }

    public static class FileRenameEvent {
        public String oldUri;
        public String newUri;

        public FileRenameEvent() {
        }

        public FileRenameEvent(String oldUri, String newUri) {
            this.oldUri = oldUri;
            this.newUri = newUri;
        }
    }

    public static class FileRenameParams {
        public List<FileRenameEvent> files;

        public FileRenameParams() {
        }

        public FileRenameParams(List<FileRenameEvent> files) {
            this.files = files;
        }
    }
}

