"use strict";
/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginsKeyValueStorage = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const fs = require("@theia/core/shared/fs-extra");
const path = require("path");
const file_uri_1 = require("@theia/core/lib/node/file-uri");
const promise_util_1 = require("@theia/core/lib/common/promise-util");
const env_variables_1 = require("@theia/core/lib/common/env-variables");
const const_1 = require("./paths/const");
const plugin_paths_protocol_1 = require("../common/plugin-paths-protocol");
let PluginsKeyValueStorage = class PluginsKeyValueStorage {
    constructor() {
        this.deferredGlobalDataPath = new promise_util_1.Deferred();
    }
    async init() {
        try {
            const configDirUri = await this.envServer.getConfigDirUri();
            const globalStorageFsPath = path.join(file_uri_1.FileUri.fsPath(configDirUri), const_1.PluginPaths.PLUGINS_GLOBAL_STORAGE_DIR);
            const exists = await fs.pathExists(globalStorageFsPath);
            if (!exists) {
                await fs.mkdirs(globalStorageFsPath);
            }
            const globalDataFsPath = path.join(globalStorageFsPath, 'global-state.json');
            this.deferredGlobalDataPath.resolve(globalDataFsPath);
        }
        catch (e) {
            console.error('Failed to initialize global state path: ', e);
            this.deferredGlobalDataPath.resolve(undefined);
        }
    }
    async set(key, value, kind) {
        const dataPath = await this.getDataPath(kind);
        if (!dataPath) {
            console.warn('Cannot save data: no opened workspace');
            return false;
        }
        const data = await this.readFromFile(dataPath);
        if (value === undefined || value === {}) {
            delete data[key];
        }
        else {
            data[key] = value;
        }
        await this.writeToFile(dataPath, data);
        return true;
    }
    async get(key, kind) {
        const dataPath = await this.getDataPath(kind);
        if (!dataPath) {
            return {};
        }
        const data = await this.readFromFile(dataPath);
        return data[key];
    }
    async getAll(kind) {
        const dataPath = await this.getDataPath(kind);
        if (!dataPath) {
            return {};
        }
        return this.readFromFile(dataPath);
    }
    async getDataPath(kind) {
        if (!kind) {
            return this.deferredGlobalDataPath.promise;
        }
        const storagePath = await this.pluginPathsService.getHostStoragePath(kind.workspace, kind.roots);
        return storagePath ? path.join(storagePath, 'workspace-state.json') : undefined;
    }
    async readFromFile(pathToFile) {
        if (!await fs.pathExists(pathToFile)) {
            return {};
        }
        try {
            return await fs.readJSON(pathToFile);
        }
        catch (error) {
            console.error('Failed to parse data from "', pathToFile, '". Reason:', error);
            return {};
        }
    }
    async writeToFile(pathToFile, data) {
        await fs.ensureDir(path.dirname(pathToFile));
        await fs.writeJSON(pathToFile, data);
    }
};
__decorate([
    inversify_1.inject(plugin_paths_protocol_1.PluginPathsService),
    __metadata("design:type", Object)
], PluginsKeyValueStorage.prototype, "pluginPathsService", void 0);
__decorate([
    inversify_1.inject(env_variables_1.EnvVariablesServer),
    __metadata("design:type", Object)
], PluginsKeyValueStorage.prototype, "envServer", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PluginsKeyValueStorage.prototype, "init", null);
PluginsKeyValueStorage = __decorate([
    inversify_1.injectable()
], PluginsKeyValueStorage);
exports.PluginsKeyValueStorage = PluginsKeyValueStorage;
//# sourceMappingURL=plugins-key-value-storage.js.map