/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { illegalArgument } from '../../../base/common/errors';
import { UILabelProvider, AriaLabelProvider, ElectronAcceleratorLabelProvider, UserSettingsLabelProvider } from '../../../base/common/keybindingLabels';
import { ResolvedKeybinding, ResolvedKeybindingPart } from '../../../base/common/keyCodes';
var BaseResolvedKeybinding = /** @class */ (function (_super) {
    __extends(BaseResolvedKeybinding, _super);
    function BaseResolvedKeybinding(os, parts) {
        var _this = _super.call(this) || this;
        if (parts.length === 0) {
            throw illegalArgument("parts");
        }
        _this._os = os;
        _this._parts = parts;
        return _this;
    }
    BaseResolvedKeybinding.prototype.getLabel = function () {
        var _this = this;
        return UILabelProvider.toLabel(this._os, this._parts, function (keybinding) { return _this._getLabel(keybinding); });
    };
    BaseResolvedKeybinding.prototype.getAriaLabel = function () {
        var _this = this;
        return AriaLabelProvider.toLabel(this._os, this._parts, function (keybinding) { return _this._getAriaLabel(keybinding); });
    };
    BaseResolvedKeybinding.prototype.getElectronAccelerator = function () {
        var _this = this;
        if (this._parts.length > 1) {
            // Electron cannot handle chords
            return null;
        }
        return ElectronAcceleratorLabelProvider.toLabel(this._os, this._parts, function (keybinding) { return _this._getElectronAccelerator(keybinding); });
    };
    BaseResolvedKeybinding.prototype.getUserSettingsLabel = function () {
        var _this = this;
        return UserSettingsLabelProvider.toLabel(this._os, this._parts, function (keybinding) { return _this._getUserSettingsLabel(keybinding); });
    };
    BaseResolvedKeybinding.prototype.isWYSIWYG = function () {
        var _this = this;
        return this._parts.every(function (keybinding) { return _this._isWYSIWYG(keybinding); });
    };
    BaseResolvedKeybinding.prototype.isChord = function () {
        return (this._parts.length > 1);
    };
    BaseResolvedKeybinding.prototype.getParts = function () {
        var _this = this;
        return this._parts.map(function (keybinding) { return _this._getPart(keybinding); });
    };
    BaseResolvedKeybinding.prototype._getPart = function (keybinding) {
        return new ResolvedKeybindingPart(keybinding.ctrlKey, keybinding.shiftKey, keybinding.altKey, keybinding.metaKey, this._getLabel(keybinding), this._getAriaLabel(keybinding));
    };
    BaseResolvedKeybinding.prototype.getDispatchParts = function () {
        var _this = this;
        return this._parts.map(function (keybinding) { return _this._getDispatchPart(keybinding); });
    };
    BaseResolvedKeybinding.prototype.getSingleModifierDispatchParts = function () {
        var _this = this;
        return this._parts.map(function (keybinding) { return _this._getSingleModifierDispatchPart(keybinding); });
    };
    return BaseResolvedKeybinding;
}(ResolvedKeybinding));
export { BaseResolvedKeybinding };
