/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.environment;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.java.model.CompilationUnitInfo;
import org.eclipse.scout.sdk.core.java.model.CompilationUnitInfoWithClasspath;
import org.eclipse.scout.sdk.core.java.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.java.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.spi.JavaEnvironmentSpi;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.environment.SdkFuture;
import org.eclipse.scout.sdk.core.util.Ensure;

public abstract class AbstractEnvironment
implements IEnvironment {
    private final Map<CompilationUnitInfo, CharSequence> m_createdCompilationUnits = new ConcurrentHashMap<CompilationUnitInfo, CharSequence>();
    private final Map<IFuture<?>, Boolean> m_uncompletedFutures = new ConcurrentHashMap();

    @Override
    public IType writeCompilationUnit(ICompilationUnitGenerator<?> generator, IClasspathEntry targetFolder) {
        return this.writeCompilationUnit(generator, targetFolder, null);
    }

    @Override
    public IType writeCompilationUnit(ICompilationUnitGenerator<?> generator, IClasspathEntry targetFolder, IProgress progress) {
        return this.writeCompilationUnitGenerator(generator, targetFolder, progress, true).result();
    }

    @Override
    public IFuture<IType> writeCompilationUnitAsync(ICompilationUnitGenerator<?> generator, IClasspathEntry targetFolder, IProgress progress) {
        return this.writeCompilationUnitGenerator(generator, targetFolder, progress, false);
    }

    public StringBuilder createResource(ISourceGenerator<ISourceBuilder<?>> generator, Path filePath) {
        IJavaEnvironment context = this.findJavaEnvironment(filePath).orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot find Java environment for path '{}'.", (Object[])new Object[]{filePath}));
        return this.runGenerator(generator, context, filePath);
    }

    @Override
    public IFuture<IType> writeCompilationUnitAsync(CharSequence newSource, ICompilationUnit existingCompilationUnit, IProgress progress) {
        return this.overwriteExistingCu(newSource, existingCompilationUnit, progress, false);
    }

    @Override
    public IType writeCompilationUnit(CharSequence newSource, ICompilationUnit existingCompilationUnit, IProgress progress) {
        return this.overwriteExistingCu(newSource, existingCompilationUnit, progress, true).result();
    }

    protected IFuture<IType> overwriteExistingCu(CharSequence newSource, ICompilationUnit existingCompilationUnit, IProgress progress, boolean sync) {
        IClasspathEntry sourceFolder = (IClasspathEntry)existingCompilationUnit.containingClasspathFolder().orElseThrow(() -> Ensure.newFail((CharSequence)"Compilation unit '{}' cannot be updated because the containing source folder could not be computed.", (Object[])new Object[]{existingCompilationUnit}));
        return this.writeCuWithExistingSource(newSource, sourceFolder, existingCompilationUnit.path(), progress, sync);
    }

    @Override
    public IFuture<IType> writeCompilationUnitAsync(CharSequence source, IClasspathEntry targetSourceFolder, Path sourceFolderRelPath, IProgress progress) {
        return this.writeCuWithExistingSource(source, targetSourceFolder, sourceFolderRelPath, progress, false);
    }

    @Override
    public IType writeCompilationUnit(CharSequence source, IClasspathEntry targetSourceFolder, Path sourceFolderRelPath, IProgress progress) {
        return this.writeCuWithExistingSource(source, targetSourceFolder, sourceFolderRelPath, progress, true).result();
    }

    protected IFuture<IType> writeCuWithExistingSource(CharSequence source, IClasspathEntry targetSourceFolder, Path sourceFolderRelPath, IProgress progress, boolean sync) {
        CompilationUnitInfoWithClasspath cuInfo = new CompilationUnitInfoWithClasspath(targetSourceFolder, sourceFolderRelPath);
        return this.writeCompilationUnit(source, cuInfo, progress, sync);
    }

    @Override
    public void writeResource(CharSequence content, Path filePath, IProgress progress) {
        this.writeResource(content, filePath, progress, true).awaitDoneThrowingOnErrorOrCancel();
    }

    @Override
    public void writeResource(ISourceGenerator<ISourceBuilder<?>> generator, Path filePath, IProgress progress) {
        this.writeResource(this.createResource(generator, filePath), filePath, progress);
    }

    @Override
    public IFuture<Void> writeResourceAsync(ISourceGenerator<ISourceBuilder<?>> generator, Path filePath, IProgress progress) {
        return this.writeResourceAsync(this.createResource(generator, filePath), filePath, progress);
    }

    @Override
    public IFuture<Void> writeResourceAsync(CharSequence content, Path filePath, IProgress progress) {
        return this.writeResource(content, filePath, progress, false);
    }

    protected IFuture<Void> writeResource(CharSequence content, Path filePath, IProgress progress, boolean sync) {
        return this.handleUncompletedFuture(this.doWriteResource(content, filePath, progress, sync));
    }

    protected IFuture<IType> writeCompilationUnitGenerator(ICompilationUnitGenerator<?> generator, IClasspathEntry targetFolder, IProgress progress, boolean sync) {
        Ensure.isTrue((boolean)((IClasspathEntry)Ensure.notNull((Object)targetFolder)).isSourceFolder(), (CharSequence)"{} is no source folder. It is only allowed to generate new source into source folders.", (Object[])new Object[]{targetFolder});
        CompilationUnitInfoWithClasspath info = new CompilationUnitInfoWithClasspath(targetFolder, generator);
        StringBuilder code = this.runGenerator((ISourceGenerator<ISourceBuilder<?>>)generator, targetFolder.javaEnvironment(), info.targetFile());
        return this.writeCompilationUnit((CharSequence)code, info, progress, sync);
    }

    protected IFuture<IType> writeCompilationUnit(CharSequence source, CompilationUnitInfoWithClasspath cuInfo, IProgress progress, boolean sync) {
        return this.handleUncompletedFuture(this.doWriteCompilationUnit(source, cuInfo, progress, sync));
    }

    protected <T> IFuture<T> handleUncompletedFuture(IFuture<T> future) {
        this.m_uncompletedFutures.put(future, Boolean.FALSE);
        future.whenComplete((f, e) -> this.m_uncompletedFutures.remove(future));
        return future;
    }

    protected IType registerCompilationUnit(CharSequence code, CompilationUnitInfoWithClasspath cuInfo) {
        this.m_createdCompilationUnits.put((CompilationUnitInfo)cuInfo, code);
        this.registerInJavaEnvironments(code, (CompilationUnitInfo)cuInfo);
        return cuInfo.classpathEntry().javaEnvironment().findType(cuInfo.mainTypeFullyQualifiedName()).orElse(null);
    }

    protected void registerInJavaEnvironments(CharSequence code, CompilationUnitInfo cuInfo) {
        Path cuPath = cuInfo.targetFile();
        this.javaEnvironments().stream().map(JavaEnvironmentSpi::wrap).filter(je -> je.classpathContains(cuPath)).filter(je -> je.registerCompilationUnitOverride(code, cuInfo)).forEach(IJavaEnvironment::reload);
    }

    protected <T extends JavaEnvironmentSpi> T initNewJavaEnvironment(T javaEnvironment) {
        if (this.m_createdCompilationUnits.isEmpty()) {
            return javaEnvironment;
        }
        IJavaEnvironment env = javaEnvironment.wrap();
        this.m_createdCompilationUnits.entrySet().stream().filter(e -> env.classpathContains(((CompilationUnitInfo)e.getKey()).targetFile())).forEach(e -> env.registerCompilationUnitOverride((CharSequence)e.getValue(), (CompilationUnitInfo)e.getKey()));
        return javaEnvironment;
    }

    @Override
    public StringBuilder executeGenerator(ISourceGenerator<ISourceBuilder<?>> generator, IClasspathEntry targetFolder) {
        return this.runGenerator(generator, targetFolder.javaEnvironment(), targetFolder.path());
    }

    @Override
    public void close() {
        SdkFuture.awaitAllLoggingOnError(this.m_uncompletedFutures.keySet());
        this.m_uncompletedFutures.clear();
        this.m_createdCompilationUnits.clear();
    }

    protected abstract Collection<? extends JavaEnvironmentSpi> javaEnvironments();

    protected abstract StringBuilder runGenerator(ISourceGenerator<ISourceBuilder<?>> var1, IJavaEnvironment var2, Path var3);

    protected abstract IFuture<Void> doWriteResource(CharSequence var1, Path var2, IProgress var3, boolean var4);

    protected abstract IFuture<IType> doWriteCompilationUnit(CharSequence var1, CompilationUnitInfoWithClasspath var2, IProgress var3, boolean var4);
}

