/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.Messages;
import org.eclipse.wst.common.componentcore.ui.ModuleCoreUIPlugin;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier.DeploymentAssemblyVerifierData;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier.IDeploymentAssemblyVerifier;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier.VerifierRegistry;
import org.eclipse.wst.common.componentcore.ui.propertypage.AddModuleDependenciesPropertiesPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class DeploymentAssemblyVerifierHelper {
    public static IStatus verify(IVirtualComponent component, IRuntime runtime, ArrayList<IVirtualReference> currentReferences, ArrayList<AddModuleDependenciesPropertiesPage.ComponentResourceProxy> resourceMappings, boolean resourceMappingsChanged) {
        IProject project = component.getProject();
        List verifiers = DeploymentAssemblyVerifierHelper.collectAllVerifiers(project, runtime);
        if (verifiers.isEmpty()) {
            return Status.OK_STATUS;
        }
        MultiStatus masterStatus = new MultiStatus("org.eclipse.wst.common.modulecore.ui", 0, Messages.DeploymentAssemblyVerifierHelper_0, null);
        int i = 0;
        while (i < verifiers.size()) {
            if (verifiers.get(i) instanceof IConfigurationElement) {
                IDeploymentAssemblyVerifier verifier = null;
                try {
                    verifier = (IDeploymentAssemblyVerifier)((IConfigurationElement)verifiers.get(i)).createExecutableExtension("class");
                    DeploymentAssemblyVerifierData data = new DeploymentAssemblyVerifierData(component, runtime, currentReferences, resourceMappings, resourceMappingsChanged);
                    IStatus verifyStatus = verifier.verify(data);
                    if (verifyStatus != null && verifyStatus.isMultiStatus()) {
                        masterStatus.addAll(verifyStatus);
                    } else {
                        masterStatus.add(verifyStatus);
                    }
                }
                catch (Exception e) {
                    ModuleCoreUIPlugin.log(e);
                }
            }
            ++i;
        }
        return masterStatus;
    }

    public static List collectAllVerifiers(IProject project, IRuntime runtime) {
        IFacetedProject fProj = null;
        try {
            fProj = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            ModuleCoreUIPlugin.log((Exception)((Object)e));
            return Collections.EMPTY_LIST;
        }
        Set facets = fProj.getProjectFacets();
        ArrayList verifiers = new ArrayList();
        for (IProjectFacetVersion facet : facets) {
            String facetId = facet.getProjectFacet().getId();
            String runtimeId = runtime == null ? null : runtime.getProperty("id");
            verifiers.addAll(VerifierRegistry.instance().getVerifierExtensions(facetId, runtimeId));
        }
        return verifiers;
    }
}

