/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.junit.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.AssertionVMArg;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitMigrationDelegate;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.ExceptionHandler;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class JUnitLaunchShortcut
implements ILaunchShortcut2 {
    private static final String EMPTY_STRING = "";
    private static final Pattern METHOD_AND_CLASS_NAME_PATTERN = Pattern.compile("(.*)\\((.*)\\)");

    public void launch(IEditorPart editor, String mode) {
        ITypeRoot element = JavaUI.getEditorInputTypeRoot((IEditorInput)editor.getEditorInput());
        if (element != null) {
            IMember selectedMember = this.resolveSelectedMemberName(editor, element);
            if (selectedMember != null) {
                this.launch(new Object[]{selectedMember}, mode);
            } else {
                this.launch(new Object[]{element}, mode);
            }
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    private IMember resolveSelectedMemberName(IEditorPart editor, ITypeRoot element) {
        IJavaElement elementAtOffset;
        ITextSelection textSelection;
        block8: {
            ISelection selection;
            block7: {
                ISelectionProvider selectionProvider;
                block6: {
                    selectionProvider = editor.getSite().getSelectionProvider();
                    if (selectionProvider != null) break block6;
                    return null;
                }
                selection = selectionProvider.getSelection();
                if (selection instanceof ITextSelection) break block7;
                return null;
            }
            textSelection = (ITextSelection)selection;
            elementAtOffset = SelectionConverter.getElementAtOffset((ITypeRoot)element, (ITextSelection)textSelection);
            if (elementAtOffset instanceof IMethod || elementAtOffset instanceof IType) break block8;
            return null;
        }
        try {
            IMember member = (IMember)elementAtOffset;
            ISourceRange nameRange = member.getNameRange();
            if (nameRange.getOffset() <= textSelection.getOffset() && textSelection.getOffset() + textSelection.getLength() <= nameRange.getOffset() + nameRange.getLength()) {
                return member;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.launch(((IStructuredSelection)selection).toArray(), mode);
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    private void launch(Object[] elements, String mode) {
        try {
            IJavaElement elementToLaunch = null;
            if (elements.length == 1) {
                Object selected = elements[0];
                if (!(selected instanceof IJavaElement) && selected instanceof IAdaptable) {
                    selected = ((IAdaptable)selected).getAdapter(IJavaElement.class);
                }
                if (selected instanceof IJavaElement) {
                    IJavaElement element = (IJavaElement)selected;
                    switch (element.getElementType()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: {
                            elementToLaunch = element;
                            break;
                        }
                        case 6: {
                            if (!(element instanceof IOrdinaryClassFile)) break;
                            elementToLaunch = ((IOrdinaryClassFile)element).getType();
                            break;
                        }
                        case 5: {
                            elementToLaunch = this.findTypeToLaunch((ICompilationUnit)element, mode);
                        }
                    }
                }
            }
            if (elementToLaunch == null) {
                this.showNoTestsFoundDialog();
                return;
            }
            this.performLaunch(elementToLaunch, mode);
        }
        catch (InterruptedException elementToLaunch) {
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), JUnitMessages.JUnitLaunchShortcut_dialog_title, JUnitMessages.JUnitLaunchShortcut_message_launchfailed);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), JUnitMessages.JUnitLaunchShortcut_dialog_title, JUnitMessages.JUnitLaunchShortcut_message_launchfailed);
        }
    }

    private void showNoTestsFoundDialog() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)JUnitMessages.JUnitLaunchShortcut_dialog_title, (String)JUnitMessages.JUnitLaunchShortcut_message_notests);
    }

    private IType findTypeToLaunch(ICompilationUnit cu, String mode) throws InterruptedException, InvocationTargetException {
        Set<IType> types = this.findTypesToLaunch(cu);
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() > 1) {
            return this.chooseType(types, mode);
        }
        return types.iterator().next();
    }

    private Set<IType> findTypesToLaunch(ICompilationUnit cu) throws InterruptedException, InvocationTargetException {
        ITestKind testKind = TestKindRegistry.getContainerTestKind((IJavaElement)cu);
        return TestSearchEngine.findTests((IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (IJavaElement)cu, testKind);
    }

    private void performLaunch(IJavaElement element, String mode) throws InterruptedException, CoreException {
        ILaunchConfigurationWorkingCopy temparary = this.createLaunchConfiguration(element);
        ILaunchConfiguration config = this.findExistingLaunchConfiguration(temparary, mode);
        if (config == null) {
            config = temparary.doSave();
        }
        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
    }

    private IType chooseType(Set<IType> types, String mode) throws InterruptedException {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(2048), new TreeProvider(types)){

            protected TreeViewer createTreeViewer(Composite parent) {
                TreeViewer tree = super.createTreeViewer(parent);
                tree.expandAll();
                return tree;
            }
        };
        dialog.setTitle(JUnitMessages.JUnitLaunchShortcut_dialog_title2);
        dialog.setAllowMultiple(false);
        dialog.setInput(TreeProvider.ROOT);
        if ("debug".equals(mode)) {
            dialog.setMessage(JUnitMessages.JUnitLaunchShortcut_message_selectTestToDebug);
        } else {
            dialog.setMessage(JUnitMessages.JUnitLaunchShortcut_message_selectTestToRun);
        }
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        throw new InterruptedException();
    }

    private Shell getShell() {
        return JUnitPlugin.getActiveWorkbenchShell();
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList, String mode) throws InterruptedException {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(JUnitMessages.JUnitLaunchShortcut_message_selectConfiguration);
        if ("debug".equals(mode)) {
            dialog.setMessage(JUnitMessages.JUnitLaunchShortcut_message_selectDebugConfiguration);
        } else {
            dialog.setMessage(JUnitMessages.JUnitLaunchShortcut_message_selectRunConfiguration);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        throw new InterruptedException();
    }

    protected String getLaunchConfigurationTypeId() {
        return "org.eclipse.jdt.junit.launchconfig";
    }

    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(IJavaElement element) throws CoreException {
        return this.createLaunchConfiguration(element, null);
    }

    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(IJavaElement element, String testName) throws CoreException {
        boolean isRunWithJUnitPlatform;
        String containerHandleId;
        String mainTypeQualifiedName = switch (element.getElementType()) {
            case 2, 3, 4 -> {
                containerHandleId = element.getHandleIdentifier();
                yield EMPTY_STRING;
            }
            case 7 -> {
                containerHandleId = EMPTY_STRING;
                yield ((IType)element).getFullyQualifiedName('.');
            }
            case 9 -> {
                IMethod method = (IMethod)element;
                testName = method.getElementName();
                testName = (String)testName + JUnitStubUtility.getParameterTypes(method, false);
                containerHandleId = EMPTY_STRING;
                IType declaringType = method.getDeclaringType();
                yield declaringType.getFullyQualifiedName('.');
            }
            default -> throw new IllegalArgumentException("Invalid element type to create a launch configuration: " + element.getClass().getName());
        };
        String testKindId = TestKindRegistry.getContainerTestKindId((IJavaElement)element);
        ILaunchConfigurationType configType = this.getLaunchManager().getLaunchConfigurationType(this.getLaunchConfigurationTypeId());
        String configName = this.getLaunchManager().generateLaunchConfigurationName(this.suggestLaunchConfigurationName(element, (String)testName));
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, configName);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainTypeQualifiedName);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, element.getJavaProject().getElementName());
        wc.setAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
        wc.setAttribute("org.eclipse.jdt.junit.CONTAINER", containerHandleId);
        wc.setAttribute("org.eclipse.jdt.junit.TEST_KIND", testKindId);
        JUnitMigrationDelegate.mapResources((ILaunchConfigurationWorkingCopy)wc);
        AssertionVMArg.setArgDefault(wc);
        if (testName != null) {
            wc.setAttribute("org.eclipse.jdt.junit.TESTNAME", (String)testName);
        }
        if (isRunWithJUnitPlatform = TestKindRegistry.isRunWithJUnitPlatform((IJavaElement)element)) {
            wc.setAttribute("org.eclipse.jdt.junit.IS_RUN_WITH_JUNIT_PLATFORM", true);
        }
        return wc;
    }

    protected String suggestLaunchConfigurationName(IJavaElement element, String fullTestName) {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        boolean useQualification = preferenceStore.getBoolean("launch_name_fully_qualified_for_junit_test");
        switch (element.getElementType()) {
            case 2: 
            case 3: 
            case 4: {
                String name = JavaElementLabels.getTextLabel((Object)element, (long)2235681801344L);
                return name.substring(name.lastIndexOf(47) + 1);
            }
            case 7: {
                if (fullTestName != null) {
                    Matcher matcher = METHOD_AND_CLASS_NAME_PATTERN.matcher(fullTestName);
                    if (matcher.matches()) {
                        String typeFQN = matcher.group(2);
                        String testName = matcher.group(1);
                        int typeFQNDot = typeFQN.lastIndexOf(46);
                        String typeName = typeFQNDot >= 0 ? typeFQN.substring(typeFQNDot + 1) : typeFQN;
                        return typeName + " " + testName;
                    }
                    return (useQualification ? ((IType)element).getFullyQualifiedName('.') : element.getElementName()) + " " + fullTestName;
                }
                return useQualification ? ((IType)element).getFullyQualifiedName('.') : element.getElementName();
            }
            case 9: {
                IMethod method = (IMethod)element;
                Object methodName = method.getElementName();
                methodName = (String)methodName + JUnitStubUtility.getParameterTypes(method, true);
                return useQualification ? method.getDeclaringType().getFullyQualifiedName('.') : method.getDeclaringType().getElementName() + "." + (String)methodName;
            }
        }
        throw new IllegalArgumentException("Invalid element type to create a launch configuration: " + element.getClass().getName());
    }

    protected String[] getAttributeNamesToCompare() {
        return new String[]{IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "org.eclipse.jdt.junit.CONTAINER", IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.jdt.junit.TESTNAME"};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasSameAttributes(ILaunchConfiguration config1, ILaunchConfiguration config2, String[] attributeToCompare) {
        try {
            String[] stringArray = attributeToCompare;
            int n = attributeToCompare.length;
            int n2 = 0;
            while (true) {
                String val2;
                if (n2 >= n) {
                    return true;
                }
                String element = stringArray[n2];
                String val1 = config1.getAttribute(element, EMPTY_STRING);
                if (!val1.equals(val2 = config2.getAttribute(element, EMPTY_STRING))) {
                    return false;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private ILaunchConfiguration findExistingLaunchConfiguration(ILaunchConfigurationWorkingCopy temporary, String mode) throws InterruptedException, CoreException {
        List<ILaunchConfiguration> candidateConfigs = this.findExistingLaunchConfigurations(temporary);
        int candidateCount = candidateConfigs.size();
        switch (candidateCount) {
            case 0: {
                return null;
            }
            case 1: {
                return candidateConfigs.get(0);
            }
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    private List<ILaunchConfiguration> findExistingLaunchConfigurations(ILaunchConfigurationWorkingCopy temporary) throws CoreException {
        ILaunchConfigurationType configType = temporary.getType();
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
        String[] attributeToCompare = this.getAttributeNamesToCompare();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (JUnitLaunchShortcut.hasSameAttributes(config, (ILaunchConfiguration)temporary, attributeToCompare)) {
                candidateConfigs.add(config);
            }
            ++n2;
        }
        return candidateConfigs;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            return this.findExistingLaunchConfigurations(ss.getFirstElement());
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editor) {
        ITypeRoot element = JavaUI.getEditorInputTypeRoot((IEditorInput)editor.getEditorInput());
        if (element != null) {
            IMember selectedMember = null;
            if (Display.getCurrent() == null) {
                AtomicReference temp = new AtomicReference();
                Runnable runnable = () -> temp.set(this.resolveSelectedMemberName(editor, element));
                Display.getDefault().syncExec(runnable);
                selectedMember = (IMember)temp.get();
            } else {
                selectedMember = this.resolveSelectedMemberName(editor, element);
            }
            ITypeRoot candidate = element;
            if (selectedMember != null) {
                candidate = selectedMember;
            }
            return this.findExistingLaunchConfigurations(candidate);
        }
        return null;
    }

    private ILaunchConfiguration[] findExistingLaunchConfigurations(Object candidate) {
        if (!(candidate instanceof IJavaElement) && candidate instanceof IAdaptable) {
            candidate = ((IAdaptable)candidate).getAdapter(IJavaElement.class);
        }
        if (candidate instanceof IJavaElement) {
            IJavaElement elementToLaunch;
            block10: {
                IJavaElement element = (IJavaElement)candidate;
                elementToLaunch = null;
                switch (element.getElementType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: {
                        elementToLaunch = element;
                        break;
                    }
                    case 6: {
                        if (!(element instanceof IOrdinaryClassFile)) break;
                        elementToLaunch = ((IOrdinaryClassFile)element).getType();
                        break;
                    }
                    case 5: {
                        elementToLaunch = ((ICompilationUnit)element).findPrimaryType();
                    }
                }
                if (elementToLaunch != null) break block10;
                return null;
            }
            try {
                ILaunchConfigurationWorkingCopy workingCopy = this.createLaunchConfiguration(elementToLaunch);
                List<ILaunchConfiguration> list = this.findExistingLaunchConfigurations(workingCopy);
                return list.toArray(new ILaunchConfiguration[list.size()]);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            Object selected = ss.getFirstElement();
            if (!(selected instanceof IJavaElement) && selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(IJavaElement.class);
            }
            if (selected instanceof IJavaElement) {
                return ((IJavaElement)selected).getResource();
            }
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editor) {
        ITypeRoot element = JavaUI.getEditorInputTypeRoot((IEditorInput)editor.getEditorInput());
        if (element != null) {
            try {
                return element.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    static class TreeProvider
    implements ITreeContentProvider {
        private static final Object ROOT = new Object();
        private final Map<Object, List<IType>> tree = new HashMap<Object, List<IType>>();

        public TreeProvider(Set<IType> types) {
            for (IType type : types) {
                IJavaElement parent = type.getParent();
                Object parentInTree = types.contains(parent) ? parent : ROOT;
                this.tree.compute(parentInTree, (key, value) -> {
                    List list = value != null ? value : new ArrayList();
                    list.add(type);
                    return list;
                });
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.tree.get(ROOT).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            List<IType> children = this.tree.get(parentElement);
            return children != null ? children.toArray() : new Object[]{};
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            List<IType> children = this.tree.get(element);
            return children != null && !children.isEmpty();
        }
    }
}

