/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AP1931
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1931(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (entryContext.getMessageEntry().isMimeContent() && entryContext.getMessageEntry().getMimeParts().getRootPart() != null) {
            try {
                Document doc = XMLUtils.parseXML(entryContext.getMessageEntry().getMimeParts().getRootPart().getContent());
                Element el = doc.getDocumentElement();
                if (!el.getLocalName().equals(WSITag.ELEM_SOAP_ENVELOPE.getLocalPart()) || !el.getNamespaceURI().equals(WSITag.ELEM_SOAP_ENVELOPE.getNamespaceURI())) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail("the entity body of the root part is {" + el.getNamespaceURI() + "}" + el.getLocalName(), entryContext);
                }
            }
            catch (Exception exception) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("the entity body of the root part does not contain \"soap:Envelope\" element", entryContext);
            }
        } else {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

