/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.merge.GitCompareEditorInput;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

public class CompareCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode>
implements IElementUpdater {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes = this.getSelectedNodes();
        if (nodes.isEmpty()) return null;
        if (nodes.size() > 2) {
            return null;
        }
        try {
            RevCommit b;
            RevCommit a;
            IWorkbenchPage workbenchPage;
            ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
            Repository repo = ((RepositoryTreeNode)nodes.get(0)).getRepository();
            int numberOfRefs = 0;
            Iterator iterator = nodes.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    if (numberOfRefs != 2) {
                        if (numberOfRefs != 1) return null;
                        workbenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
                        this.compare(workbenchPage, repo, null, ((RevCommit)commits.get(0)).getName());
                        return null;
                    }
                    workbenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
                    a = (RevCommit)commits.get(0);
                    b = (RevCommit)commits.get(1);
                    if (a.getCommitTime() > b.getCommitTime()) break;
                    this.compare(workbenchPage, repo, b.getName(), a.getName());
                    return null;
                }
                RepositoryTreeNode node = (RepositoryTreeNode)iterator.next();
                RevCommit commit = this.getCommit(repo, node);
                if (commit == null) {
                    return null;
                }
                commits.add(commit);
                ++numberOfRefs;
            }
            this.compare(workbenchPage, repo, a.getName(), b.getName());
            return null;
        }
        catch (IOException e) {
            throw new ExecutionException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void compare(IWorkbenchPage workbenchPage, Repository repo, String compareCommit, String baseCommit) throws ExecutionException {
        GitCompareEditorInput compareInput = new GitCompareEditorInput(compareCommit, baseCommit, repo, new IPath[0]);
        CompareUtils.openInCompare(workbenchPage, repo, compareInput);
    }

    private RevCommit getCommit(Repository repository, RepositoryTreeNode<?> node) throws IOException {
        if (node instanceof TagNode) {
            String oid = ((TagNode)node).getCommitId();
            if (oid == null) {
                return null;
            }
            return repository.parseCommit((AnyObjectId)ObjectId.fromString((String)oid));
        }
        if (node instanceof RefNode || node instanceof AdditionalRefNode) {
            Ref ref = (Ref)node.getObject();
            if ((ref = repository.exactRef(ref.getName())) != null) {
                return repository.parseCommit((AnyObjectId)ref.getObjectId());
            }
        }
        return null;
    }

    private Ref getRef(RepositoryTreeNode node) {
        if (node instanceof TagNode) {
            return (Ref)((TagNode)node).getObject();
        }
        if (node instanceof RefNode || node instanceof AdditionalRefNode) {
            return (Ref)node.getObject();
        }
        return null;
    }

    public boolean isEnabled() {
        List nodes = this.getSelectedNodes();
        int numberOfNodes = nodes.size();
        if (numberOfNodes > 1) {
            return numberOfNodes == 2 && nodes.stream().map(RepositoryTreeNode::getRepository).distinct().count() == 1L;
        }
        return numberOfNodes == 1 && this.getRef((RepositoryTreeNode)nodes.get(0)) != null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IStructuredSelection selection = SelectionUtils.getSelection(((IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class)).getCurrentState());
        if (selection.size() == 1) {
            element.setText(UIText.CompareCommand_WithWorkingTreeLabel);
        }
    }
}

