/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.commons.core.XmlStringConverter;
import org.eclipse.mylyn.internal.context.core.AggregateInteractionEvent;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxContextContentHandler
extends DefaultHandler {
    private static final int EXPECTING_ROOT = 0;
    private static final int EXPECTING_EVENT = 1;
    private int state = 0;
    private InteractionContext context;
    private final IInteractionContextScaling contextScaling;
    private final String contextHandleIdentifier;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z", Locale.ENGLISH);
    static final String ATTRIBUTE_INTERACTION_EVENT = "InteractionEvent";
    static final String ATTRIBUTE_CONTENT = "Content";

    public SaxContextContentHandler(String contextHandleIdentifier, IInteractionContextScaling contextScaling) {
        this.contextHandleIdentifier = contextHandleIdentifier;
        this.contextScaling = contextScaling;
    }

    public InteractionContext getContext() {
        return this.context;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                this.context = new InteractionContext(this.contextHandleIdentifier, this.contextScaling);
                String limitContentTo = attributes.getValue(ATTRIBUTE_CONTENT);
                if (limitContentTo != null) {
                    this.context.setContentLimitedTo(limitContentTo);
                }
                this.state = 1;
                break;
            }
            case 1: {
                try {
                    InteractionEvent ie = this.createEventFromAttributes(attributes);
                    this.context.parseEvent(ie);
                    break;
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.context.core", "Ignored unexpected activity event", (Throwable)e));
                }
            }
        }
    }

    private InteractionEvent createEventFromAttributes(Attributes attributes) throws ParseException {
        String delta = XmlStringConverter.convertXmlToString((String)attributes.getValue("Delta"));
        String endDate = attributes.getValue("EndDate");
        String interest = attributes.getValue("Interest");
        String kind = attributes.getValue("Kind");
        String navigation = XmlStringConverter.convertXmlToString((String)attributes.getValue("Navigation"));
        String originId = XmlStringConverter.convertXmlToString((String)attributes.getValue("OriginId"));
        String startDate = attributes.getValue("StartDate");
        String structureHandle = XmlStringConverter.convertXmlToString((String)attributes.getValue("StructureHandle"));
        String structureKind = XmlStringConverter.convertXmlToString((String)attributes.getValue("StructureKind"));
        String numEventsString = attributes.getValue("NumEvents");
        int numEvents = 1;
        if (numEventsString != null && numEventsString.length() != 0) {
            try {
                numEvents = Integer.parseInt(numEventsString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String eventCountOnCreationString = attributes.getValue("CreationCount");
        int eventCountOnCreation = -1;
        if (eventCountOnCreationString != null && eventCountOnCreationString.length() != 0) {
            try {
                eventCountOnCreation = Integer.parseInt(eventCountOnCreationString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Date dStartDate = this.dateFormat.parse(startDate);
        Date dEndDate = this.dateFormat.parse(endDate);
        float iInterest = Float.parseFloat(interest);
        Object ie = null;
        ie = numEventsString == null || eventCountOnCreationString == null ? new InteractionEvent(InteractionEvent.Kind.fromString((String)kind), structureKind, structureHandle, originId, navigation, delta, iInterest, dStartDate, dEndDate) : new AggregateInteractionEvent(InteractionEvent.Kind.fromString((String)kind), structureKind, structureHandle, originId, navigation, delta, iInterest, dStartDate, dEndDate, numEvents, eventCountOnCreation);
        return ie;
    }
}

