/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.cview.IncludeRefContainer;
import org.eclipse.cdt.internal.ui.cview.IncludeReferenceProxy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.ChangeConfigAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class ChangeBuildConfigActionBase {
    protected HashSet<IProject> fProjects = new HashSet();

    protected void fillMenu(Menu menu) {
        MenuItem[] items;
        if (menu == null) {
            return;
        }
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item2 = menuItemArray[n2];
            item2.dispose();
            ++n2;
        }
        TreeSet<Object> configNames = new TreeSet<Object>();
        String sCurrentConfig = null;
        boolean bCurrentConfig = true;
        for (IProject prj : this.fProjects) {
            ICConfigurationDescription[] cfgDescs = this.getCfgs(prj);
            Object sActiveConfig = null;
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescs;
            int n3 = cfgDescs.length;
            int n4 = 0;
            while (n4 < n3) {
                ICConfigurationDescription cfgDesc = iCConfigurationDescriptionArray[n4];
                String s = cfgDesc.getName();
                if (!configNames.contains(s)) {
                    configNames.add(s);
                }
                if (cfgDesc.isActive()) {
                    sActiveConfig = s;
                }
                ++n4;
            }
            if (!bCurrentConfig) continue;
            if (sCurrentConfig == null) {
                sCurrentConfig = sActiveConfig;
                continue;
            }
            if (sCurrentConfig.equals(sActiveConfig)) continue;
            bCurrentConfig = false;
        }
        int accel = 0;
        for (String string : configNames) {
            String sDesc = null;
            boolean commonName = true;
            boolean commonDesc = true;
            boolean firstProj = true;
            for (IProject prj : this.fProjects) {
                ICConfigurationDescription[] cfgDescs = this.getCfgs(prj);
                int i = 0;
                while (i < cfgDescs.length) {
                    if (cfgDescs[i].getName().equals(string)) {
                        String sNewDesc = cfgDescs[i].getDescription();
                        if (sNewDesc != null && sNewDesc.length() == 0) {
                            sNewDesc = null;
                        }
                        if (!commonDesc) break;
                        if (firstProj) {
                            sDesc = sNewDesc;
                            firstProj = false;
                            break;
                        }
                        if ((sNewDesc != null || sDesc == null) && (sNewDesc == null || sNewDesc.equals(sDesc))) break;
                        commonDesc = false;
                        break;
                    }
                    ++i;
                }
                if (i != cfgDescs.length) continue;
                commonName = false;
                break;
            }
            if (!commonName) continue;
            StringBuffer builder = new StringBuffer(string);
            if (commonDesc) {
                if (sDesc != null) {
                    builder.append(" (");
                    builder.append(sDesc);
                    builder.append(")");
                }
            } else {
                builder.append(" (...)");
            }
            IAction action = this.makeAction(string, builder, accel);
            if (bCurrentConfig && sCurrentConfig != null && sCurrentConfig.equals(string)) {
                action.setChecked(true);
            }
            ActionContributionItem item = new ActionContributionItem(action);
            item.fill(menu, -1);
            ++accel;
        }
    }

    protected IAction makeAction(String sName, StringBuffer builder, int accel) {
        return new ChangeConfigAction(this.fProjects, sName, builder.toString(), accel + 1);
    }

    protected void onSelectionChanged(IAction action, ISelection selection) {
        Iterator<IProject> iter;
        ICConfigurationDescription[] firstConfigs;
        IProject project;
        this.fProjects.clear();
        boolean badObject = false;
        if (selection != null) {
            if (selection instanceof IStructuredSelection) {
                Object o;
                IWorkbenchPart part;
                IWorkbenchPage page;
                if (selection.isEmpty() && (page = CUIPlugin.getActivePage()) != null && (part = page.getActivePart()) != null && (o = part.getAdapter(IResource.class)) != null && o instanceof IResource) {
                    this.fProjects.add(((IResource)o).getProject());
                }
                for (Object selItem : (IStructuredSelection)selection) {
                    Object adapter;
                    project = null;
                    if (selItem instanceof ICElement) {
                        ICProject cproject = ((ICElement)selItem).getCProject();
                        if (cproject != null) {
                            project = cproject.getProject();
                        }
                    } else if (selItem instanceof IResource) {
                        project = ((IResource)selItem).getProject();
                    } else if (selItem instanceof IncludeRefContainer) {
                        ICProject fCProject = ((IncludeRefContainer)((Object)selItem)).getCProject();
                        if (fCProject != null) {
                            project = fCProject.getProject();
                        }
                    } else if (selItem instanceof IncludeReferenceProxy) {
                        ICProject fCProject;
                        IncludeRefContainer irc = ((IncludeReferenceProxy)((Object)selItem)).getIncludeRefContainer();
                        if (irc != null && (fCProject = irc.getCProject()) != null) {
                            project = fCProject.getProject();
                        }
                    } else if (selItem instanceof IAdaptable && (adapter = ((IAdaptable)selItem).getAdapter(IProject.class)) != null && adapter instanceof IProject) {
                        project = (IProject)adapter;
                    }
                    if (project != null) {
                        if (!CoreModel.getDefault().isNewStyleProject(project)) {
                            project = null;
                        } else {
                            ICConfigurationDescription[] tmp = this.getCfgs(project);
                            if (tmp.length == 0) {
                                project = null;
                            }
                        }
                    }
                    if (project != null) {
                        this.fProjects.add(project);
                        continue;
                    }
                    badObject = true;
                    break;
                }
            } else if (selection instanceof ITextSelection) {
                IEditorPart epart;
                IResource resource;
                IWorkbenchPart part;
                IWorkbenchPage page;
                IWorkbenchWindow window = CUIPlugin.getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) instanceof IEditorPart && (resource = (IResource)(epart = (IEditorPart)part).getEditorInput().getAdapter(IResource.class)) != null) {
                    IProject project2 = resource.getProject();
                    boolean bl = badObject = project2 == null || !CoreModel.getDefault().isNewStyleProject(project2);
                    if (!badObject) {
                        this.fProjects.add(project2);
                    }
                }
            } else if (selection instanceof ImaginarySelection) {
                this.fProjects.add(((ImaginarySelection)selection).getProject());
            }
        }
        boolean enable = false;
        if (!badObject && !this.fProjects.isEmpty() && (firstConfigs = this.getCfgs((iter = this.fProjects.iterator()).next())) != null) {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = firstConfigs;
            int project2 = firstConfigs.length;
            int resource = 0;
            while (resource < project2) {
                ICConfigurationDescription firstConfig = iCConfigurationDescriptionArray[resource];
                boolean common = true;
                Iterator<IProject> iter2 = this.fProjects.iterator();
                while (iter2.hasNext()) {
                    ICConfigurationDescription[] currentConfigs = this.getCfgs(iter2.next());
                    int j = 0;
                    while (j < currentConfigs.length) {
                        if (firstConfig.getName().equals(currentConfigs[j].getName())) break;
                        ++j;
                    }
                    if (j != currentConfigs.length) continue;
                    common = false;
                    break;
                }
                if (common) {
                    enable = true;
                    break;
                }
                ++resource;
            }
        }
        action.setEnabled(enable);
        if (badObject || this.fProjects.isEmpty()) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            if (projects != null && projects.length == 1) {
                project = projects[0];
                if (CoreModel.getDefault().isNewStyleProject(project) && this.getCfgs(project).length > 0) {
                    this.onSelectionChanged(action, new ImaginarySelection(project));
                    return;
                }
            }
            IWorkbenchPage page = CUIPlugin.getActivePage();
            int viewCount = 0;
            if (page != null) {
                ISelection cdtSelection;
                IViewPart view;
                IViewReference theViewRef = null;
                IViewReference viewRef = null;
                theViewRef = page.findViewReference("org.eclipse.cdt.ui.CView");
                viewCount += theViewRef != null ? 1 : 0;
                viewRef = page.findViewReference("org.eclipse.ui.navigator.ProjectExplorer");
                viewCount += viewRef != null ? 1 : 0;
                theViewRef = theViewRef == null ? viewRef : theViewRef;
                viewRef = page.findViewReference("org.eclipse.ui.views.ResourceNavigator");
                IViewReference iViewReference = theViewRef = theViewRef == null ? viewRef : theViewRef;
                if (theViewRef != null && (viewCount += viewRef != null ? 1 : 0) == 1 && (view = theViewRef.getView(false)) != null && (cdtSelection = view.getSite().getSelectionProvider().getSelection()) != null && !cdtSelection.isEmpty() && !cdtSelection.equals(selection)) {
                    this.onSelectionChanged(action, cdtSelection);
                }
            }
        }
    }

    private ICConfigurationDescription[] getCfgs(IProject prj) {
        ICConfigurationDescription[] cfgs;
        ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(prj, false);
        if (prjd != null && (cfgs = prjd.getConfigurations()) != null) {
            return cfgs;
        }
        return new ICConfigurationDescription[0];
    }

    private static class ImaginarySelection
    implements ISelection {
        private IProject fProject;

        ImaginarySelection(IProject project) {
            this.fProject = project;
        }

        public boolean isEmpty() {
            return this.fProject == null;
        }

        IProject getProject() {
            return this.fProject;
        }
    }
}

