/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.m2e.pde.target.MavenSourceBundle;
import org.eclipse.m2e.pde.target.MavenTargetBundle;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;

class TargetBundles {
    private final Map<Artifact, TargetBundle> bundles = new HashMap<Artifact, TargetBundle>();
    private final Map<File, Artifact> artifacts = new HashMap<File, Artifact>();
    private final Map<Artifact, MavenSourceBundle> sourceBundles = new HashMap<Artifact, MavenSourceBundle>();
    final Set<Artifact> ignoredArtifacts = new HashSet<Artifact>();
    final List<TargetFeature> features = new ArrayList<TargetFeature>();
    final Map<MavenTargetDependency, List<DependencyNode>> dependencyNodes = new HashMap<MavenTargetDependency, List<DependencyNode>>();

    TargetBundles() {
    }

    Optional<DependencyNode> getDependencyNode(Artifact artifact) {
        return this.dependencyNodes.values().stream().flatMap(Collection::stream).filter(node -> artifact.equals(node.getArtifact())).findAny();
    }

    Optional<MavenTargetBundle> getMavenTargetBundle(Artifact artifact) {
        return Optional.ofNullable(this.bundles.get(artifact)).filter(MavenTargetBundle.class::isInstance).map(MavenTargetBundle.class::cast);
    }

    Optional<TargetBundle> getTargetBundle(Artifact artifact, boolean source) {
        Map<Artifact, MavenSourceBundle> bundlesMap = source ? this.sourceBundles : this.bundles;
        return Optional.ofNullable((TargetBundle)bundlesMap.get(artifact));
    }

    Optional<MavenTargetBundle> getTargetBundle(MavenTargetDependency dependency) {
        List<DependencyNode> list = this.dependencyNodes.get((Object)dependency);
        if (list != null) {
            Optional<Artifact> artifact = list.stream().filter(node -> node.getData().get("dependencynode.root") == dependency).findFirst().map(DependencyNode::getArtifact);
            return artifact.flatMap(this::getMavenTargetBundle);
        }
        return Optional.empty();
    }

    public void addBundle(Artifact artifact, TargetBundle bundle) {
        File file = artifact.getFile();
        if (file == null) {
            this.bundles.put(artifact, bundle);
        } else if (this.artifacts.put(file, artifact) == null) {
            this.bundles.put(artifact, bundle);
        }
    }

    public void addSourceBundle(Artifact artifact, MavenSourceBundle sourceBundle) {
        this.sourceBundles.put(artifact, sourceBundle);
    }

    public Stream<Map.Entry<Artifact, TargetBundle>> bundles() {
        return this.bundles.entrySet().stream();
    }

    public Optional<Artifact> getArtifact(File file) {
        return Optional.ofNullable(this.artifacts.get(file));
    }
}

