/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.model.resource;

import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.FilterParser;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.resource.SupportingResource;
import aQute.bnd.unmodifiable.Maps;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.pde.bnd.ui.BoldStyler;
import org.eclipse.pde.bnd.ui.ResourceUtils;
import org.eclipse.pde.bnd.ui.internal.ItalicStyler;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class R5LabelFormatter {
    private static final Pattern EE_PATTERN = Pattern.compile("osgi.ee=([^)]*).*version=([^)]*)");
    private static final Map<String, Pattern> FILTER_PATTERNS = Maps.of((Object)"osgi.ee", (Object)EE_PATTERN, (Object)"osgi.wiring.package", (Object)Pattern.compile("osgi\\.wiring\\.package=([^)]*)"));
    public static final String PLUGIN_ID = "bndtools.core";

    public static String getVersionAttributeName(String ns) {
        Object r = ns == null ? null : (ns.equals("osgi.identity") ? "version" : (ns.equals("osgi.content") ? null : (ns.equals("osgi.wiring.bundle") ? "bundle-version" : (ns.equals("osgi.wiring.host") ? "bundle-version" : (ns.equals("osgi.ee") ? "version" : (ns.equals("osgi.wiring.package") ? "version" : (ns.equals("osgi.extender") ? "version" : (ns.equals("osgi.contract") ? "version" : (ns.equals("osgi.service") ? null : null)))))))));
        return r;
    }

    public static Pattern getFilterPattern(String ns) {
        return FILTER_PATTERNS.get(ns);
    }

    public static String getMainAttributeName(String ns) {
        if ("osgi.service".equals(ns)) {
            return "objectClass";
        }
        return ns;
    }

    public static String getNamespaceImagePath(String ns) {
        String r = "brkpi_obj.svg";
        if ("osgi.wiring.bundle".equals(ns) || "osgi.wiring.host".equals(ns)) {
            r = "bundle.png";
        } else if ("osgi.ee".equals(ns)) {
            r = "jcu_obj.svg";
        } else if ("osgi.wiring.package".equals(ns)) {
            r = "package_obj.svg";
        } else if ("osgi.service".equals(ns)) {
            r = "service.png";
        } else if ("osgi.extender".equals(ns)) {
            r = "tricks.svg";
        } else if ("osgi.contract".equals(ns)) {
            r = "signed_yes_tbl.svg";
        } else if ("osgi.whiteboard".equals(ns)) {
            r = "whiteboard.png";
        } else if ("bnd.multirelease".equals(ns)) {
            r = "jar_obj.svg";
        } else if ("osgi.unresolvable".equalsIgnoreCase(ns) || "osgi.missing".equalsIgnoreCase(ns) || "donotresolve".equalsIgnoreCase(ns) || "compile-only".equalsIgnoreCase(ns)) {
            r = "excludeMode_filter.svg";
        }
        return r;
    }

    public static void appendNamespaceWithValue(StyledString label, String ns, String value, boolean shorten) {
        String prefix = ns;
        if (shorten) {
            if ("osgi.identity".equals(ns)) {
                prefix = "id";
            } else if ("osgi.wiring.bundle".equals(ns)) {
                prefix = "";
            } else if ("osgi.wiring.host".equals(ns)) {
                prefix = "host";
            } else if ("osgi.ee".equals(ns)) {
                prefix = "";
            } else if ("osgi.wiring.package".equals(ns)) {
                prefix = "";
            } else if ("osgi.service".equals(ns)) {
                prefix = "";
            } else if ("osgi.contract".equals(ns)) {
                prefix = "";
            } else if ("osgi.whiteboard".equals(ns)) {
                prefix = "";
            }
        }
        if (prefix.length() > 0) {
            label.append(prefix + "=", StyledString.QUALIFIER_STYLER);
        }
        label.append(value, (StyledString.Styler)BoldStyler.INSTANCE_DEFAULT);
    }

    public static void appendCapability(StyledString label, Capability cap, boolean shorten) {
        SupportingResource sr;
        int index;
        String ns = cap.getNamespace();
        Resource r = cap.getResource();
        if (r instanceof SupportingResource && (index = (sr = (SupportingResource)r).getSupportingIndex()) >= 0) {
            label.append("[" + index + "] ");
        }
        Object nsValue = cap.getAttributes().get(R5LabelFormatter.getMainAttributeName(ns));
        String versionAttributeName = R5LabelFormatter.getVersionAttributeName(ns);
        if (nsValue != null) {
            Object version;
            R5LabelFormatter.appendNamespaceWithValue(label, ns, nsValue.toString(), shorten);
            if (versionAttributeName != null && (version = cap.getAttributes().get(versionAttributeName)) != null) {
                label.append(", " + versionAttributeName, StyledString.QUALIFIER_STYLER);
                label.append(" " + version.toString(), (StyledString.Styler)BoldStyler.INSTANCE_COUNTER);
            }
        } else {
            label.append(ns, (StyledString.Styler)BoldStyler.INSTANCE_DEFAULT);
        }
        label.append(" ", StyledString.QUALIFIER_STYLER);
        if (!cap.getAttributes().isEmpty()) {
            boolean first = true;
            for (Map.Entry entry : cap.getAttributes().entrySet()) {
                String key = (String)entry.getKey();
                if (key.equals(ns) || key.equals(versionAttributeName)) continue;
                if (first) {
                    label.append("[", StyledString.QUALIFIER_STYLER);
                } else {
                    label.append(", ", StyledString.QUALIFIER_STYLER);
                }
                first = false;
                label.append(key + "=", StyledString.QUALIFIER_STYLER);
                label.append(entry.getValue() != null ? entry.getValue().toString() : "<null>", StyledString.QUALIFIER_STYLER);
            }
            if (!first) {
                label.append("]", StyledString.QUALIFIER_STYLER);
            }
        }
        if (!cap.getDirectives().isEmpty()) {
            label.append(" ");
            boolean first = true;
            for (Map.Entry directive : cap.getDirectives().entrySet()) {
                label.append((String)directive.getKey() + ":=" + (String)directive.getValue(), StyledString.QUALIFIER_STYLER);
                if (first) continue;
                label.append(", ", StyledString.QUALIFIER_STYLER);
            }
        }
    }

    public static void appendResourceLabel(StyledString label, Resource resource) {
        ResourceUtils.IdentityCapability identity = aQute.bnd.osgi.resource.ResourceUtils.getIdentityCapability((Resource)resource);
        String name = aQute.bnd.osgi.resource.ResourceUtils.getIdentity((Capability)identity);
        if (name == null) {
            name = resource != null ? resource.toString() : "<unknown>";
        }
        label.append(name, (StyledString.Styler)BoldStyler.INSTANCE_DEFAULT);
        Version version = ResourceUtils.getVersion((Capability)identity);
        if (version != null) {
            label.append(" " + String.valueOf(version), StyledString.COUNTER_STYLER);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void appendRequirementLabel(StyledString label, Requirement requirement, boolean shorten) {
        try {
            requirement = CapReqBuilder.unalias((Requirement)requirement);
        }
        catch (Exception e) {
            ILog.get().log((IStatus)new Status(2, "bndtools.core", 0, "Error parsing aliased requirement, using original", (Throwable)e));
        }
        namespace = requirement.getNamespace();
        filter = (String)requirement.getDirectives().get("filter");
        optional = "optional".equals(requirement.getDirectives().get("resolution"));
        r = requirement.getResource();
        if (r instanceof SupportingResource && (index = (sr = (SupportingResource)r).getSupportingIndex()) >= 0) {
            label.append("[" + index + "] ");
        }
        fp = new FilterParser();
        if (filter == null) {
            if (namespace.contains("$")) {
                pattern = Pattern.compile("\\{(.*?)\\}");
                matcher = pattern.matcher(namespace);
                label.append(namespace);
                while (matcher.find()) {
                    begin = matcher.start(1);
                    end = matcher.end(1);
                    label.setStyle(begin, end - begin, (StyledString.Styler)BoldStyler.INSTANCE_DEFAULT);
                }
            } else {
                label.append(namespace + ": <no filter>", ItalicStyler.INSTANCE_ERROR);
            }
        } else {
            try {
                exp = fp.parse(filter);
                if (exp instanceof FilterParser.WithRangeExpression) {
                    R5LabelFormatter.appendNamespaceWithValue(label, namespace, ((FilterParser.WithRangeExpression)exp).printExcludingRange(), shorten);
                    range = ((FilterParser.WithRangeExpression)exp).getRangeExpression();
                    if (range == null) ** GOTO lbl56
                    label.append(" ").append(R5LabelFormatter.formatRangeString(range), StyledString.COUNTER_STYLER);
                }
                if ("osgi.ee".equals(namespace)) {
                    matcher = R5LabelFormatter.EE_PATTERN.matcher(filter);
                    if (matcher.find()) {
                        eename = matcher.group(1);
                        version = matcher.group(2);
                        R5LabelFormatter.appendNamespaceWithValue(label, namespace, eename, true);
                        label.append(" ").append(version, StyledString.COUNTER_STYLER);
                    }
                    R5LabelFormatter.appendNamespaceWithValue(label, namespace, filter, true);
                }
                R5LabelFormatter.appendNamespaceWithValue(label, namespace, filter, true);
            }
            catch (Exception e) {
                label.append(namespace + ": ", StyledString.QUALIFIER_STYLER);
                label.append("<parse error>", ItalicStyler.INSTANCE_ERROR);
            }
        }
lbl56:
        // 8 sources

        first = true;
        for (Map.Entry<K, V> directive : requirement.getDirectives().entrySet()) {
            if ("resolution".equals(directive.getKey()) || "filter".equals(directive.getKey())) continue;
            buf = new StringBuilder();
            buf.append(first != false ? " " : ", ");
            buf.append((String)directive.getKey()).append(":=").append((String)directive.getValue());
            label.append(buf.toString(), StyledString.QUALIFIER_STYLER);
            first = false;
        }
        if (optional) {
            label.setStyle(0, label.length(), StyledString.QUALIFIER_STYLER);
            label.append(" <optional>", ItalicStyler.INSTANCE_DEFAULT);
        }
    }

    public static String formatRangeString(FilterParser.RangeExpression range) {
        StringBuilder sb = new StringBuilder();
        FilterParser.SimpleExpression low = range.getLow();
        if (low == null) {
            sb.append("[0");
        } else {
            if (low.getOp() == FilterParser.Op.GREATER) {
                sb.append("(");
            } else {
                sb.append("[");
            }
            sb.append(low.getValue());
        }
        sb.append(", ");
        FilterParser.SimpleExpression high = range.getHigh();
        if (high == null) {
            sb.append("\u221e]");
        } else {
            sb.append(high.getValue());
            if (high.getOp() == FilterParser.Op.LESS) {
                sb.append(")");
            } else {
                sb.append("]");
            }
        }
        return sb.toString();
    }
}

