/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.internal.corext.fix.InlineMethodFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessorUtil;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class InlineDeprecatedMethodCleanUpCore
extends AbstractMultiFix {
    public InlineDeprecatedMethodCleanUpCore() {
        this(Collections.emptyMap());
    }

    public InlineDeprecatedMethodCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.replace_deprecated_calls");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.replace_deprecated_calls")) {
            return new String[]{MultiFixMessages.InlineDeprecatedMethodCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        bld.append("Class E {\n");
        bld.append("  /**\n");
        bld.append("   * @deprecated use {@link foo(int)} instead\n");
        bld.append("   * @param a - first int\n");
        bld.append("   * @param b - second int\n");
        bld.append("   */\n");
        bld.append("  @Deprecated\n");
        bld.append("  public static int foo(int a, int b) {\n");
        bld.append("    return foo(a + b);\n");
        bld.append("  }\n");
        bld.append("  public static int foo(int a) {\n");
        bld.append("    return a + 7;\n");
        bld.append("  }\n");
        bld.append("}\n\n");
        if (this.isEnabled("cleanup.replace_deprecated_calls")) {
            bld.append("return E.foo(x + y);\n");
        } else {
            bld.append("return E.foo(x, y);\n");
        }
        return bld.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (!this.isEnabled("cleanup.replace_deprecated_calls")) {
            return null;
        }
        if (compilationUnit == null) {
            return null;
        }
        final ArrayList<MethodInvocation> deprecatedInvocations = new ArrayList<MethodInvocation>();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(MethodInvocation node) {
                if (QuickAssistProcessorUtil.isDeprecatedMethodCallWithReplacement((ASTNode)node)) {
                    deprecatedInvocations.add(node);
                }
                return true;
            }
        };
        compilationUnit.accept(visitor);
        if (deprecatedInvocations.isEmpty()) {
            return null;
        }
        return InlineMethodFixCore.create(this.getPreview(), compilationUnit, deprecatedInvocations);
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }
}

