/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.admin;

import java.io.IOException;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.admin.CDOAdmin;
import org.eclipse.emf.cdo.common.admin.CDOAdminRepository;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.RepositoryStateChangedEvent;
import org.eclipse.emf.cdo.common.util.RepositoryTypeChangedEvent;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositorySynchronizer;
import org.eclipse.emf.cdo.server.ISynchronizableRepository;
import org.eclipse.emf.cdo.server.internal.admin.CDOAdminServer;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataOutputImpl;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.monitor.NotifyingMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitorProgress;

public class CDOAdminServerRepository
extends Notifier
implements CDOAdminRepository {
    private final CDOAdminServer admin;
    private final IRepository delegate;
    private IListener delegateListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof CDOCommonRepository.TypeChangedEvent) {
                CDOCommonRepository.TypeChangedEvent e = (CDOCommonRepository.TypeChangedEvent)event;
                CDOCommonRepository.Type oldType = e.getOldType();
                CDOCommonRepository.Type newType = e.getNewType();
                CDOAdminServerRepository.this.fireEvent((IEvent)new RepositoryTypeChangedEvent((INotifier)CDOAdminServerRepository.this, oldType, newType));
                CDOAdminServerRepository.this.admin.repositoryTypeChanged(CDOAdminServerRepository.this.getName(), oldType, newType);
            } else if (event instanceof CDOCommonRepository.StateChangedEvent) {
                CDOCommonRepository.StateChangedEvent e = (CDOCommonRepository.StateChangedEvent)event;
                CDOCommonRepository.State oldState = e.getOldState();
                CDOCommonRepository.State newState = e.getNewState();
                CDOAdminServerRepository.this.fireEvent((IEvent)new RepositoryStateChangedEvent((INotifier)CDOAdminServerRepository.this, oldState, newState));
                CDOAdminServerRepository.this.admin.repositoryStateChanged(CDOAdminServerRepository.this.getName(), oldState, newState);
            }
        }
    };
    private IListener delegateSynchronizerListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof OMMonitorProgress) {
                OMMonitorProgress e = (OMMonitorProgress)event;
                double totalWork = e.getTotalWork();
                double work = e.getWork();
                CDOAdminServerRepository.this.fireEvent((IEvent)new NotifyingMonitor.ProgressEvent((INotifier)CDOAdminServerRepository.this, totalWork, work));
                CDOAdminServerRepository.this.admin.repositoryReplicationProgressed(CDOAdminServerRepository.this.getName(), totalWork, work);
            }
        }
    };

    public CDOAdminServerRepository(CDOAdminServer admin, IRepository delegate) {
        this.admin = admin;
        this.delegate = delegate;
        delegate.addListener(this.delegateListener);
        if (delegate instanceof ISynchronizableRepository) {
            IRepositorySynchronizer synchronizer = ((ISynchronizableRepository)delegate).getSynchronizer();
            synchronizer.addListener(this.delegateSynchronizerListener);
        }
    }

    public final CDOAdmin getAdmin() {
        return this.admin;
    }

    public final IRepository getDelegate() {
        return this.delegate;
    }

    public boolean delete(String type) {
        return this.admin.deleteRepository(this, type);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getUUID() {
        return this.delegate.getUUID();
    }

    public CDOCommonRepository.Type getType() {
        return this.delegate.getType();
    }

    public CDOCommonRepository.State getState() {
        return this.delegate.getState();
    }

    public String getStoreType() {
        return this.delegate.getStoreType();
    }

    public Set<CDOID.ObjectType> getObjectIDTypes() {
        return this.delegate.getObjectIDTypes();
    }

    public long getCreationTime() {
        return this.delegate.getCreationTime();
    }

    public CDOID getRootResourceID() {
        return this.delegate.getRootResourceID();
    }

    public boolean isAuthenticating() {
        return this.delegate.isAuthenticating();
    }

    public boolean isSupportingAudits() {
        return this.delegate.isSupportingAudits();
    }

    public boolean isSupportingLoginPeeks() {
        return this.delegate.isSupportingLoginPeeks();
    }

    public boolean isSupportingBranches() {
        return this.delegate.isSupportingBranches();
    }

    public boolean isSupportingUnits() {
        return this.delegate.isSupportingUnits();
    }

    public boolean isSerializingCommits() {
        return this.delegate.isSerializingCommits();
    }

    public boolean isEnsuringReferentialIntegrity() {
        return this.delegate.isEnsuringReferentialIntegrity();
    }

    public boolean isAuthorizingOperations() {
        return this.delegate.isAuthorizingOperations();
    }

    public boolean waitWhileInitial(IProgressMonitor monitor) {
        return this.delegate.waitWhileInitial(monitor);
    }

    public CDOCommonRepository.IDGenerationLocation getIDGenerationLocation() {
        return this.delegate.getIDGenerationLocation();
    }

    public String getLobDigestAlgorithm() {
        return this.delegate.getLobDigestAlgorithm();
    }

    public CDOCommonRepository.CommitInfoStorage getCommitInfoStorage() {
        return this.delegate.getCommitInfoStorage();
    }

    public long getTimeStamp() throws UnsupportedOperationException {
        return this.delegate.getTimeStamp();
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)((Object)this), (Class)adapter, (boolean)false);
    }

    public void write(ExtendedDataOutputStream out) throws IOException {
        out.writeString(this.getName());
        out.writeString(this.getUUID());
        out.writeEnum((Enum)this.getType());
        out.writeEnum((Enum)this.getState());
        out.writeString(this.getStoreType());
        Set<CDOID.ObjectType> objectIDTypes = this.getObjectIDTypes();
        int types = objectIDTypes.size();
        out.writeInt(types);
        for (CDOID.ObjectType objectIDType : objectIDTypes) {
            out.writeEnum((Enum)objectIDType);
        }
        out.writeLong(this.getCreationTime());
        CDODataOutputImpl wrapper = new CDODataOutputImpl((ExtendedDataOutput)out);
        wrapper.writeCDOID(this.getRootResourceID());
        if (ObjectUtil.never()) {
            wrapper.close();
        }
        out.writeBoolean(this.isAuthenticating());
        out.writeBoolean(this.isSupportingLoginPeeks());
        out.writeBoolean(this.isSupportingAudits());
        out.writeBoolean(this.isSupportingBranches());
        out.writeBoolean(this.isSupportingUnits());
        out.writeBoolean(this.isSerializingCommits());
        out.writeBoolean(this.isEnsuringReferentialIntegrity());
        out.writeBoolean(this.isAuthorizingOperations());
        out.writeEnum((Enum)this.getIDGenerationLocation());
        out.writeString(this.getLobDigestAlgorithm());
        out.writeEnum((Enum)this.getCommitInfoStorage());
    }

    public void dispose() {
        this.delegate.removeListener(this.delegateListener);
        if (this.delegate instanceof ISynchronizableRepository) {
            IRepositorySynchronizer synchronizer = ((ISynchronizableRepository)this.delegate).getSynchronizer();
            synchronizer.removeListener(this.delegateSynchronizerListener);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Deprecated
    public boolean isSupportingEcore() {
        throw new UnsupportedOperationException();
    }
}

